/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenDropDownList
extends GUISimpleElement<OxygenDropDownList> {
    private final List<OxygenDropDownListWrapperEntry> elements = new ArrayList<OxygenDropDownListWrapperEntry>(5);
    @Nullable
    private ElementClickListener elementClickListener;

    public OxygenDropDownList(int xPosition, int yPosition, int width, String displayText) {
        this.setPosition(xPosition, yPosition);
        this.setSize(width, 9);
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f);
        this.setDisplayText(displayText);
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.enableFull();
    }

    public <T> void setElementClickListener(ElementClickListener<T> listener) {
        this.elementClickListener = listener;
    }

    public List<OxygenDropDownListWrapperEntry> getElements() {
        return this.elements;
    }

    public void addElement(OxygenDropDownListWrapperEntry element) {
        element.initScreen(this.getScreen());
        element.setPosition(this.getX(), this.getY() + this.getHeight() * (this.elements.size() + 1));
        element.setSize(this.getWidth(), this.getHeight());
        element.setScale(this.getScale());
        element.setTextScale(this.getTextScale());
        element.init();
        this.elements.add(element);
        this.bind(element);
    }

    public void reset() {
        this.elements.clear();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged()) {
                int size = this.elements.size() + 1;
                OxygenDropDownList.drawRect(0, this.getHeight(), this.getWidth(), this.getHeight() * size, this.getEnabledBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, this.getHeight(), 0.4, this.getHeight() * size, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, this.getHeight(), this.getWidth(), this.getHeight() * size, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() + 0.4, this.getWidth(), (float)this.getHeight() + 0.4f, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (double)(this.getHeight() * size) + 0.4, this.getWidth(), this.getHeight() * size, this.getStaticBackgroundColor());
            }
            OxygenDropDownList.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, this.getWidth(), 0.4, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() - 0.4, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                iconU = 3;
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered() && !this.isDragged()) {
                iconU = 6;
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SORT_DOWN_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(this.getWidth() - 5, (this.getHeight() - 3) / 2, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179121_F();
            if (this.isDragged()) {
                for (OxygenDropDownListWrapperEntry element : this.elements) {
                    element.draw(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX <= this.getX() + (int)(this.getScale() * (float)this.getWidth()) && mouseY < this.getY() + (int)(this.getScale() * (float)(this.isDragged() ? this.getHeight() * (this.elements.size() + 1) : this.getHeight())));
            if (this.isDragged()) {
                for (OxygenDropDownListWrapperEntry element : this.elements) {
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (OxygenDropDownListWrapperEntry element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setDisplayText(element.getDisplayText());
                this.setDragged(false);
                element.setHovered(false);
                if (this.elementClickListener != null) {
                    this.elementClickListener.click(element);
                }
                this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.CONTEXT_CLOSE.getSoundEvent(), 0.5f, 1.0f);
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged()) {
            this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.DROP_DOWN_LIST_OPEN.getSoundEvent(), 0.5f, 1.0f);
        }
        this.setDragged(flag && mouseButton == 0);
        return false;
    }

    public static class OxygenDropDownListWrapperEntry<T>
    extends GUISimpleElement<OxygenDropDownListWrapperEntry> {
        protected final T wrapped;

        public OxygenDropDownListWrapperEntry(T wrapped, String displayText) {
            this.wrapped = wrapped;
            this.setDisplayText(displayText);
            this.setStaticBackgroundColor(EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
            this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
            this.enableFull();
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHovered()) {
                int third = this.getWidth() / 3;
                OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.RIGHT);
                OxygenDropDownListWrapperEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), this.getStaticBackgroundColor());
                OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.LEFT);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }

        public T getWrapped() {
            return this.wrapped;
        }
    }

    @FunctionalInterface
    public static interface ElementClickListener<T> {
        public void click(T var1);
    }
}

