/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.api;

import austeretony.oxygen_core.client.OxygenManagerClient;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class TimeHelperClient {
    public static ZoneId getZoneId() {
        return OxygenManagerClient.instance().getTimeManager().getZoneId();
    }

    public static Clock getClock() {
        return OxygenManagerClient.instance().getTimeManager().getClock();
    }

    public static long getCurrentMillis() {
        return OxygenManagerClient.instance().getTimeManager().getClock().millis();
    }

    public static Instant getInstant() {
        return OxygenManagerClient.instance().getTimeManager().getInstant();
    }

    public static ZonedDateTime getZonedDateTime() {
        return OxygenManagerClient.instance().getTimeManager().getZonedDateTime();
    }

    public static ZonedDateTime getZonedDateTime(long epochMilli) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), TimeHelperClient.getZoneId());
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return OxygenManagerClient.instance().getTimeManager().getDateTimeFormatter();
    }

    public static ZoneId getServerZoneId() {
        return OxygenManagerClient.instance().getTimeManager().getServerZoneId();
    }

    public static ZonedDateTime getServerZonedDateTime() {
        return OxygenManagerClient.instance().getTimeManager().getServerZonedDateTime();
    }

    public static ZonedDateTime getServerZonedDateTime(long epochMilli) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), TimeHelperClient.getServerZoneId());
    }
}

