/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.api;

import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.privilege.RoleData;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.value.TypedValueBoolean;
import austeretony.oxygen_core.common.value.TypedValueFloat;
import austeretony.oxygen_core.common.value.TypedValueInteger;
import austeretony.oxygen_core.common.value.TypedValueLong;
import austeretony.oxygen_core.common.value.TypedValueString;
import java.util.Set;
import javax.annotation.Nullable;

public class PrivilegesProviderClient {
    @Nullable
    public static RoleData getRoleData(int roleId) {
        return OxygenManagerClient.instance().getPrivilegesContainer().getRoleData(roleId);
    }

    public static Set<Integer> getPlayerRolesIds() {
        return OxygenManagerClient.instance().getPrivilegesContainer().getClientPlayerRolesIds();
    }

    @Nullable
    public static Role getPlayerRole(int roleId) {
        return OxygenManagerClient.instance().getPrivilegesContainer().getClientPlayerRole(roleId);
    }

    @Nullable
    public static Role getPriorityPlayerRole() {
        return OxygenManagerClient.instance().getPrivilegesManager().getPriorityPlayerRole();
    }

    @Nullable
    public static Privilege getPriorityPlayerPrivilege(int privilegeId) {
        return OxygenManagerClient.instance().getPrivilegesManager().getPriorityPlayerPrivilege(privilegeId);
    }

    public static boolean getAsBoolean(int privilegeId, boolean defaultValue) {
        Privilege privilege = PrivilegesProviderClient.getPriorityPlayerPrivilege(privilegeId);
        if (privilege != null) {
            return ((TypedValueBoolean)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static int getAsInt(int privilegeId, int defaultValue) {
        Privilege privilege = PrivilegesProviderClient.getPriorityPlayerPrivilege(privilegeId);
        if (privilege != null) {
            return ((TypedValueInteger)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static long getAsLong(int privilegeId, long defaultValue) {
        Privilege privilege = PrivilegesProviderClient.getPriorityPlayerPrivilege(privilegeId);
        if (privilege != null) {
            return ((TypedValueLong)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static float getAsFloat(int privilegeId, float defaultValue) {
        Privilege privilege = PrivilegesProviderClient.getPriorityPlayerPrivilege(privilegeId);
        if (privilege != null) {
            return ((TypedValueFloat)privilege.get()).getValue().floatValue();
        }
        return defaultValue;
    }

    public static String getAsString(int privilegeId, String defaultValue) {
        Privilege privilege = PrivilegesProviderClient.getPriorityPlayerPrivilege(privilegeId);
        if (privilege != null) {
            return ((TypedValueString)privilege.get()).getValue();
        }
        return defaultValue;
    }
}

