/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.settings.SettingValue;
import austeretony.oxygen_core.common.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class OxygenClientSettingsManager {
    private final Map<String, SettingValue> settings = new TreeMap<String, SettingValue>();
    private volatile boolean changed;

    protected OxygenClientSettingsManager() {
    }

    public void register(SettingValue setting) {
        this.settings.put(setting.getKey(), setting);
    }

    @Nullable
    public SettingValue getSettingValue(String key) {
        return this.settings.get(key);
    }

    public Future<?> loadSettings() {
        return OxygenHelperClient.addIOTask(this::load);
    }

    private void load() {
        String pathStr = OxygenHelperCommon.getConfigFolder() + "data/client/settings/settings.json";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonObject settingsObject = JsonUtils.getExternalJsonData(pathStr).getAsJsonObject();
                for (SettingValue setting : this.settings.values()) {
                    setting.load(settingsObject);
                }
                JsonUtils.createExternalJsonFile(pathStr, (JsonElement)settingsObject);
                OxygenMain.LOGGER.info("[Core] Client setting loaded.");
            }
            catch (IOException | NullPointerException exception) {
                OxygenMain.LOGGER.error("[Core] Client settings file damaged!", (Throwable)exception);
            }
        } else {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonObject settingsObject = new JsonObject();
                for (SettingValue setting : this.settings.values()) {
                    setting.save(settingsObject);
                }
                JsonUtils.createExternalJsonFile(pathStr, (JsonElement)settingsObject);
                OxygenMain.LOGGER.info("[Core] Client setting file created.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to create client settings file!");
                exception.printStackTrace();
            }
        }
    }

    public void changed() {
        this.changed = true;
    }

    void save() {
        if (this.changed) {
            this.changed = false;
            String pathStr = OxygenHelperCommon.getConfigFolder() + "data/client/settings/settings.json";
            Path path = Paths.get(pathStr, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    JsonObject settingsObject = new JsonObject();
                    for (SettingValue setting : this.settings.values()) {
                        setting.save(settingsObject);
                    }
                    JsonUtils.createExternalJsonFile(pathStr, (JsonElement)settingsObject);
                }
                catch (IOException | NullPointerException exception) {
                    OxygenMain.LOGGER.error("[Core] Client settings file damaged!", (Throwable)exception);
                }
            }
        }
    }
}

