/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.text;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.UIUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;

public class GUITextBoxField
extends GUISimpleElement<GUITextBoxField> {
    protected String typedText;
    protected final int maxStringLength;
    protected int cursorCounter;
    protected int lineOffset;
    protected boolean newLine;
    protected boolean selected;
    private final List<String> lines = new ArrayList<String>(5);

    public GUITextBoxField(int xPosition, int yPosition, int width, int height, int maxStringLength) {
        this.setPosition(xPosition, yPosition);
        this.setSize(width, height);
        this.maxStringLength = maxStringLength > 1000 ? 1000 : maxStringLength;
        this.typedText = "";
        this.lineOffset = 2;
        this.enableFull();
    }

    @Override
    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public String getTypedText() {
        return this.typedText;
    }

    public GUITextBoxField setText(String text) {
        if (this.selected) {
            text = "";
            this.selected = false;
        }
        this.typedText = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
        UIUtils.divideText(this.lines, this.typedText, this.getWidth() - 4, this.getHeight(), this.getTextScale(), this.lineOffset);
        return this;
    }

    public void reset() {
        this.setText("");
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.selected = false;
        boolean flag = false;
        if (this.isDoubleClickRequired()) {
            if (this.isClickedLately()) {
                flag = true;
                this.setLastClickTime(0L);
            } else {
                this.setLastClickTime(Minecraft.func_71386_F());
            }
        } else {
            flag = true;
        }
        if (flag && this.isEnabled()) {
            this.setDragged(this.isHovered());
            if (this.isDragged() && this.shouldCancelDraggedLogic()) {
                GUITextBoxField.resetDragged();
            }
            if (this.isDragged() && this.isHovered()) {
                this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
                this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
                if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                    this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        if (!this.isDragged()) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.selected = true;
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            if (this.selected) {
                GuiScreen.func_146275_d((String)this.getTypedText());
            }
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.isEnabled()) {
                this.setText(this.getTypedText() + GuiScreen.func_146277_j());
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            if (this.selected && this.isEnabled()) {
                GuiScreen.func_146275_d((String)this.getTypedText());
                this.setText("");
            }
            return true;
        }
        switch (keyCode) {
            case 14: {
                String s = this.getTypedText();
                if (!s.isEmpty()) {
                    this.setText(s.substring(0, s.length() - 1));
                }
                return true;
            }
            case 28: 
            case 156: {
                this.append("\n");
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)keyChar)) {
            this.append(Character.toString(keyChar));
        }
        return true;
    }

    private void append(String string) {
        this.setText(this.getTypedText() + string);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDynamicBackgroundEnabled()) {
                if (this.isEnabled()) {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
                } else {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
                }
                if (this.isDragged()) {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getHoveredBackgroundColor());
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)2.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged() && this.lines.isEmpty() && this.cursorCounter / 6 % 2 == 0) {
                this.mc.field_71466_p.func_175065_a("_", 0.0f, 0.0f, this.getEnabledTextColor(), this.isTextShadowEnabled());
            }
            int index = 0;
            for (String line : this.lines) {
                if (this.isDragged() && !this.newLine && index == this.lines.size() - 1 && this.cursorCounter / 6 % 2 == 0) {
                    this.mc.field_71466_p.func_175065_a(line + "_", 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * index), this.getEnabledTextColor(), this.isTextShadowEnabled());
                } else {
                    this.mc.field_71466_p.func_175065_a(line, 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * index), this.getEnabledTextColor(), this.isTextShadowEnabled());
                }
                ++index;
            }
            if (this.isDragged() && this.newLine && this.cursorCounter / 6 % 2 == 0) {
                this.mc.field_71466_p.func_175065_a("_", 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * this.lines.size()), this.getEnabledTextColor(), this.isTextShadowEnabled());
            }
            GlStateManager.func_179121_F();
            if (this.selected) {
                this.drawSelectionBox(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void drawSelectionBox(int xStart, int yStart, int xEnd, int yEnd) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xStart, (double)yStart, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public GUITextBoxField setLineOffset(int offset) {
        this.lineOffset = offset;
        return this;
    }
}

