/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUIBaseSection;
import austeretony.alternateui.util.EnumGUIAlignment;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;

public class GUIWorkspace
extends GUIAdvancedElement<GUIWorkspace> {
    private boolean enableDefaultBackground;
    private final Set<AbstractGUISection> sectionsList = new LinkedHashSet<AbstractGUISection>(3);
    private AbstractGUISection currentSection;
    private int xAlignment;
    private int yAlignment;
    private int defBackgroundColor = 2014318608;

    public GUIWorkspace(AbstractGUIScreen screen, int width, int height) {
        this.initScreen(screen);
        this.setSize(width, height);
        this.setPosition((screen.field_146294_l - width) / 2, (screen.field_146295_m - height) / 2);
        this.setVisible(true);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isDefaultBackgroundEnabled()) {
            this.drawDefaultBackground();
        }
        super.draw(mouseX, mouseY);
        if (this.isTextureEnabled()) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            this.mc.func_110434_K().func_110577_a(this.getTexture());
            GUIWorkspace.drawCustomSizedTexturedRect(this.getX() + this.getTextureOffsetX(), this.getY() + this.getTextureOffsetY(), 0, 0, this.getTextureWidth(), this.getTextureHeight(), this.getTextureWidth(), this.getTextureHeight());
            GlStateManager.func_179084_k();
            GlStateManager.func_179097_i();
            GlStateManager.func_179145_e();
        }
    }

    public void drawDefaultBackground() {
        GUIWorkspace.drawRect(0, 0, this.mc.field_71443_c, this.mc.field_71440_d, this.getDefaultBackgroundColor());
    }

    public Set<AbstractGUISection> getSections() {
        return this.sectionsList;
    }

    public AbstractGUISection getCurrentSection() {
        return this.currentSection;
    }

    public AbstractGUISection createSection() {
        GUIBaseSection section = new GUIBaseSection(this.screen);
        section.setPosition(this.getX(), this.getY());
        section.setSize(this.getWidth(), this.getHeight());
        this.getSections().add(section);
        return section;
    }

    public AbstractGUISection initSection(AbstractGUISection section) {
        section.setPosition(this.getX(), this.getY());
        section.setSize(this.getWidth(), this.getHeight());
        this.getSections().add(section);
        return section;
    }

    public void setCurrentSection(AbstractGUISection section) {
        this.currentSection = section;
    }

    public int getXAlignment() {
        return this.xAlignment;
    }

    public int getYAlignment() {
        return this.yAlignment;
    }

    public GUIWorkspace setAlignment(EnumGUIAlignment alignment, int xOffset, int yOffset) {
        this.xAlignment = xOffset;
        this.yAlignment = yOffset;
        int xPos = 0;
        int yPos = 0;
        switch (alignment) {
            case BOTTOM: {
                xPos = (this.screen.field_146294_l - this.getWidth()) / 2;
                yPos = this.screen.field_146295_m - this.getHeight();
                break;
            }
            case BOTTOM_LEFT: {
                xPos = 0;
                yPos = this.screen.field_146295_m - this.getHeight();
                break;
            }
            case BOTTOM_RIGHT: {
                xPos = 0;
                yPos = this.screen.field_146295_m - this.getHeight();
                break;
            }
            case CENTER: {
                xPos = (this.screen.field_146294_l - this.getWidth()) / 2;
                yPos = (this.screen.field_146295_m - this.getHeight()) / 2;
                break;
            }
            case LEFT: {
                xPos = 0;
                yPos = (this.screen.field_146295_m - this.getHeight()) / 2;
                break;
            }
            case RIGHT: {
                xPos = this.screen.field_146294_l - this.getWidth();
                yPos = (this.screen.field_146295_m - this.getHeight()) / 2;
                break;
            }
            case TOP: {
                xPos = (this.screen.field_146294_l - this.getWidth()) / 2;
                yPos = 0;
                break;
            }
            case TOP_LEFT: {
                xPos = 0;
                yPos = 0;
                break;
            }
            case TOP_RIGHT: {
                xPos = this.screen.field_146294_l - this.getWidth();
                yPos = 0;
            }
        }
        this.setPosition(xPos + xOffset, yPos + yOffset);
        return this;
    }

    public boolean isDefaultBackgroundEnabled() {
        return this.enableDefaultBackground;
    }

    public GUIWorkspace enableDefaultBackground() {
        this.enableDefaultBackground = true;
        return this;
    }

    public GUIWorkspace enableDefaultBackground(int colorHex) {
        this.enableDefaultBackground();
        this.defBackgroundColor = colorHex;
        return this;
    }

    public int getDefaultBackgroundColor() {
        return this.defBackgroundColor;
    }

    public GUIWorkspace setDefaultBackgroundColor(int colorHex) {
        this.defBackgroundColor = colorHex;
        return this;
    }
}

