/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.screen.browsing.GUIScroller;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.alternateui.util.AlternateUIReference;
import austeretony.alternateui.util.GUISoundEffect;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundEvent;

public class GUIBaseElement<T extends GUIBaseElement> {
    protected final Minecraft mc = AlternateUIReference.getMinecraft();
    protected AbstractGUIScreen screen;
    public static final long DOUBLE_CLICK_TIME = 500L;
    private int xPosition;
    private int yPosition;
    private int width;
    private int height;
    private int visibleElementsAmount;
    private int maxElementsAmount;
    private long lastClickTimeMillis;
    private boolean isEnabled;
    private boolean isVisible;
    private boolean isHovered;
    private boolean isToggled;
    private boolean isDragged;
    private boolean hasSound;
    private boolean canNotBeDragged;
    private boolean needDoubleClick;
    private boolean hasScroller;
    private boolean hasSearchField;
    private boolean isSearchField;
    private boolean hasContextMenu;
    private boolean cancelDraggedLogic;
    private GUIScroller scroller;
    private GUITextField searchField;
    private GUIContextMenu contextMenu;
    protected GUISoundEffect soundEffect;
    private Set<GUIBaseElement> boundElements;
    private static GUIBaseElement draggedElement;
    private static boolean hasDraggedElement;

    public void bind(GUIBaseElement element) {
        if (this.boundElements == null) {
            this.boundElements = new HashSet<GUIBaseElement>();
        }
        this.boundElements.add(element);
    }

    public void unbind(GUIBaseElement element) {
        if (this.boundElements != null) {
            this.boundElements.remove(element);
        }
    }

    public boolean isBound(GUIBaseElement element) {
        if (this.boundElements == null) {
            return false;
        }
        return this.boundElements.contains(element);
    }

    public static void setDragged(GUIBaseElement element) {
        hasDraggedElement = true;
        draggedElement = element;
    }

    public static void resetDragged() {
        hasDraggedElement = false;
        draggedElement = null;
    }

    public static boolean hasDraggedElement() {
        return hasDraggedElement;
    }

    public T cancelDraggedElementLogic(boolean flag) {
        this.cancelDraggedLogic = flag;
        return (T)this;
    }

    public boolean shouldCancelDraggedLogic() {
        return this.cancelDraggedLogic;
    }

    public void init() {
    }

    public void update() {
    }

    public void draw(int mouseX, int mouseY) {
    }

    public void drawTooltip(int mouseX, int mouseY) {
    }

    public void drawContextMenu(int mouseX, int mouseY) {
    }

    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight());
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = false;
        if (this.isDoubleClickRequired()) {
            if (this.isClickedLately()) {
                flag = true;
                this.lastClickTimeMillis = 0L;
            } else {
                this.lastClickTimeMillis = Minecraft.func_71386_F();
            }
        } else {
            flag = true;
        }
        if (this.isHovered() && flag && this.hasSound()) {
            this.mc.field_71439_g.func_184185_a(this.soundEffect.sound, this.soundEffect.volume, this.soundEffect.pitch);
        }
        return this.isHovered() && flag;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        return false;
    }

    public void updateCursorCounter() {
    }

    public void handleScroller(boolean isScrolling) {
    }

    public void handleSlider() {
    }

    public void clear() {
    }

    public boolean hasScroller() {
        return this.hasScroller;
    }

    public void setHasScroller() {
        this.hasScroller = true;
    }

    public GUIScroller getScroller() {
        return this.scroller;
    }

    public T initScroller(GUIScroller scroller) {
        scroller.initScreen(this.getScreen());
        this.setScrollingParams(scroller.rowsVisible, scroller.getRowsAmount());
        this.scroller = this.scroller == null ? scroller : this.scroller;
        this.hasScroller = true;
        return (T)this;
    }

    public boolean hasSearchField() {
        return this.hasSearchField;
    }

    public GUITextField getSearchField() {
        return this.searchField;
    }

    public T initSearchField(GUITextField searchField) {
        searchField.setSearchField();
        searchField.initScreen(this.getScreen());
        this.searchField = searchField;
        this.hasSearchField = true;
        return (T)this;
    }

    public boolean hasContextMenu() {
        return this.hasContextMenu;
    }

    public GUIContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public T initContextMenu(GUIContextMenu contextMenu) {
        contextMenu.initScreen(this.getScreen());
        this.contextMenu = contextMenu;
        this.hasContextMenu = true;
        return (T)this;
    }

    public int getVisibleElementsAmount() {
        return this.visibleElementsAmount;
    }

    public int getMaxElementsAmount() {
        return this.maxElementsAmount;
    }

    public T setScrollingParams(int visibleButtonsAmount, int maxButtonsAmount) {
        this.visibleElementsAmount = visibleButtonsAmount;
        this.maxElementsAmount = maxButtonsAmount;
        return (T)this;
    }

    public long getLastClickTime() {
        return this.lastClickTimeMillis;
    }

    public void setLastClickTime(long timeMillis) {
        this.lastClickTimeMillis = timeMillis;
    }

    public boolean isDoubleClickRequired() {
        return this.needDoubleClick;
    }

    public AbstractGUIScreen getScreen() {
        return this.screen;
    }

    public T initScreen(AbstractGUIScreen screen) {
        this.screen = screen;
        return (T)this;
    }

    public T requireDoubleClick() {
        this.needDoubleClick = true;
        return (T)this;
    }

    public boolean isClickedLately() {
        return Minecraft.func_71386_F() - this.lastClickTimeMillis < 500L;
    }

    public int getX() {
        return this.xPosition;
    }

    public T setX(int xPosition) {
        this.xPosition = xPosition;
        return (T)this;
    }

    public int getY() {
        return this.yPosition;
    }

    public T setY(int yPosition) {
        this.yPosition = yPosition;
        return (T)this;
    }

    public T setPosition(int xPosition, int yPosition) {
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        return (T)this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public T setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public T setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return (T)this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public T setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return (T)this;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public T setHovered(boolean isHovered) {
        if (!hasDraggedElement || this == draggedElement || draggedElement.isBound(this)) {
            this.isHovered = isHovered;
        }
        return (T)this;
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public T toggle() {
        this.isToggled = true;
        return (T)this;
    }

    public T toggle(boolean isToggled) {
        this.isToggled = isToggled;
        return (T)this;
    }

    public boolean setToggled(boolean isToggled) {
        this.isToggled = isToggled;
        return isToggled;
    }

    public boolean isDragged() {
        return this.isDragged;
    }

    public T setDragged(boolean isDragged) {
        if (!this.isCanNotBeDragged()) {
            this.isDragged = isDragged;
        }
        if (this.isDragged) {
            GUIBaseElement.setDragged(this);
        } else {
            GUIBaseElement.resetDragged();
        }
        return (T)this;
    }

    public boolean isCanNotBeDragged() {
        return this.canNotBeDragged;
    }

    public T setCanNotBeDragged() {
        this.canNotBeDragged = true;
        return (T)this;
    }

    public boolean hasSound() {
        return this.hasSound;
    }

    public GUISoundEffect getSound() {
        return this.soundEffect;
    }

    public T setSound(GUISoundEffect sound) {
        this.soundEffect = sound;
        this.hasSound = true;
        return (T)this;
    }

    public T setSound(SoundEvent sound) {
        this.soundEffect = new GUISoundEffect(sound, 0.5f, 1.0f);
        this.hasSound = true;
        return (T)this;
    }

    public T disable() {
        this.setEnabled(false);
        return (T)this;
    }

    public T enable() {
        this.setEnabled(true);
        return (T)this;
    }

    public boolean isSearchField() {
        return this.isSearchField;
    }

    public void setSearchField() {
        this.isSearchField = true;
    }
}

