/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.button;

import austeretony.alternateui.screen.browsing.GUIScroller;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GUISlider
extends GUIAdvancedElement<GUISlider> {
    private GUIScroller scroller;
    private ResourceLocation slidebarTexture;
    private boolean isSlidebarBackgroundEnabled;
    private boolean isSlidebarTextureEnabled;
    private int slidebarX;
    private int slidebarY;
    private int slidebarWidth;
    private int slidebarHeight;
    private int slidebarTextureU;
    private int slidebarTextureV;

    public GUISlider(int xPosition, int yPosition, int sliderWidth, int sliderHeight) {
        this.setPosition(xPosition, yPosition);
        this.setSize(sliderWidth, sliderHeight);
        this.setSlidebarPosition(xPosition, yPosition);
        this.setEnabled(true);
        this.setVisible(true);
        this.enableSlidebarBackground();
        this.cancelDraggedElementLogic(true);
    }

    public void setScroller(GUIScroller scroller) {
        this.scroller = scroller;
        this.setSlidebarSize(this.getWidth(), (int)((float)this.getHeight() / ((float)scroller.getRowsAmount() / (float)scroller.rowsVisible)) > 10 ? (int)((float)this.getHeight() / ((float)scroller.getRowsAmount() / (float)scroller.rowsVisible)) : 10);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            if (this.isTextureEnabled()) {
                this.mc.func_110434_K().func_110577_a(this.getTexture());
                GlStateManager.func_179147_l();
                GUISlider.drawCustomSizedTexturedRect((this.getWidth() - this.getTextureWidth()) / 2, (this.getHeight() - this.getTextureHeight()) / 2, this.getTextureU(), this.getTextureV(), this.getTextureWidth(), this.getTextureHeight(), this.getImageWidth(), this.getImageHeight());
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getSlidebarX(), (float)this.getSlidebarY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            if (this.isSlidebarTextureEnabled()) {
                int u = this.getSlidebarTextureU();
                this.mc.func_110434_K().func_110577_a(this.getSlidebarTexture());
                u = this.isHovered() || this.isToggled() ? (u += this.getSlidebarWidth() * 2) : (u += this.getSlidebarWidth());
                GUISlider.drawCustomSizedTexturedRect(0, 0, u, this.getSlidebarTextureV(), this.getTextureWidth(), this.getTextureHeight(), this.getImageWidth(), this.getImageHeight());
            }
            int color = !this.isEnabled() ? this.getDisabledBackgroundColor() : (this.isHovered() ? this.getHoveredBackgroundColor() : this.getEnabledBackgroundColor());
            GUISlider.drawRect(0, 0, this.getSlidebarWidth(), this.getSlidebarHeight(), color);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (!this.isDragged()) {
            this.setHovered(this.isEnabled() && mouseX >= this.getSlidebarX() && mouseY >= this.getSlidebarY() && mouseX < this.getSlidebarX() + (int)((float)this.getSlidebarWidth() * this.getScale()) && mouseY < this.getSlidebarY() + (int)((float)this.getSlidebarHeight() * this.getScale()));
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (Mouse.isButtonDown((int)0) && this.isHovered()) {
            this.setDragged(true);
            return true;
        }
        return false;
    }

    public void resetSlidebarPosition() {
        this.setSlidebarPosition(this.getX(), this.getY());
    }

    public void setSlidebarNotDragged() {
        this.setDragged(false);
        this.setHovered(false);
    }

    public void handleSlidebarViaScroller() {
        this.setSlidebarY(this.getY() + (int)((float)(this.getHeight() - this.getSlidebarHeight()) / (float)this.scroller.getMaxPosition() * (float)this.scroller.getPosition()));
    }

    public void handleSlidebarViaCursor(int slidebarY) {
        this.setSlidebarY(slidebarY >= this.getY() ? (slidebarY <= this.getY() + (this.getHeight() - this.getSlidebarHeight()) ? slidebarY : this.getY() + (this.getHeight() - this.getSlidebarHeight())) : this.getY());
    }

    public boolean isSlidebarBackgroundEnabled() {
        return this.isSlidebarBackgroundEnabled;
    }

    public GUISlider enableSlidebarBackground() {
        this.isSlidebarBackgroundEnabled = true;
        return this;
    }

    public int getSlidebarX() {
        return this.slidebarX;
    }

    public void setSlidebarX(int xPosition) {
        this.slidebarX = xPosition;
    }

    public int getSlidebarY() {
        return this.slidebarY;
    }

    public void setSlidebarY(int yPosition) {
        this.slidebarY = yPosition;
    }

    public void setSlidebarPosition(int xPosition, int yPosition) {
        this.slidebarX = xPosition;
        this.slidebarY = yPosition;
    }

    public int getSlidebarWidth() {
        return this.slidebarWidth;
    }

    public void setSlidebarWidth(int slidebarWidth) {
        this.slidebarWidth = slidebarWidth;
    }

    public int getSlidebarHeight() {
        return this.slidebarHeight;
    }

    public void setSlidebarHeight(int slidebarHeight) {
        this.slidebarHeight = slidebarHeight;
    }

    public void setSlidebarSize(int slidebarWidth, int slidebarHeight) {
        this.slidebarWidth = slidebarWidth;
        this.slidebarHeight = slidebarHeight;
    }

    public boolean isSlidebarTextureEnabled() {
        return this.isSlidebarTextureEnabled;
    }

    public GUISlider enableSlidebarTexture() {
        this.isSlidebarTextureEnabled = true;
        return this;
    }

    public ResourceLocation getSlidebarTexture() {
        return this.slidebarTexture;
    }

    public int getSlidebarTextureU() {
        return this.slidebarTextureU;
    }

    public int getSlidebarTextureV() {
        return this.slidebarTextureV;
    }

    public GUISlider setSlidebarTexture(ResourceLocation texture) {
        this.slidebarTexture = texture;
        return this;
    }

    public GUISlider setSlidebarTexture(ResourceLocation texture, int u, int v) {
        this.slidebarTexture = texture;
        this.slidebarTextureU = u;
        this.slidebarTextureV = v;
        return this;
    }
}

