/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.browsing;

import austeretony.alternateui.container.framework.GUISlotsFramework;
import austeretony.alternateui.screen.button.GUISlider;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import org.lwjgl.input.Mouse;

public class GUIScroller {
    private AbstractGUIScreen screen;
    public final EnumScrollerType scrollerType = EnumScrollerType.STANDARD;
    public final int rowsVisible;
    private int maxPosition;
    private int currentPosition;
    private int rowsAmount;
    private boolean ignoreBorders;
    private boolean hasSlider;
    private boolean isScrollingDown;
    private boolean isScrollingUp;
    private GUISlider slider;

    public GUIScroller(int rowsAmount, int rowsVisible) {
        this.rowsAmount = rowsAmount;
        this.rowsVisible = rowsVisible;
        this.maxPosition = rowsAmount - rowsVisible;
        this.currentPosition = 0;
    }

    public void updateRowsAmount(int value) {
        this.rowsAmount = value;
        this.maxPosition = this.rowsAmount - this.rowsVisible;
        if (this.slider != null) {
            this.slider.setScroller(this);
            if (value > this.rowsVisible) {
                this.slider.enableFull();
            } else {
                this.slider.disableFull();
            }
        }
    }

    public int getRowsAmount() {
        return this.rowsAmount;
    }

    public GUIScroller(GUISlotsFramework framework) {
        this.rowsAmount = (int)((float)(framework.lastSlotIndex - framework.firstSlotIndex + 1) / (float)(framework.rows * framework.columns) * (float)framework.rows);
        this.rowsVisible = framework.rows;
        this.maxPosition = this.rowsAmount - this.rowsVisible;
        this.currentPosition = 0;
    }

    public GUIScroller initScreen(AbstractGUIScreen screen) {
        this.screen = screen;
        return this;
    }

    public AbstractGUIScreen getScreen() {
        return this.screen;
    }

    public GUIScroller initSlider(GUISlider slider) {
        slider.initScreen(this.getScreen());
        this.slider = this.slider == null ? slider : this.slider;
        this.hasSlider = true;
        this.slider.setScroller(this);
        return this;
    }

    public boolean hasSlider() {
        return this.hasSlider;
    }

    public boolean isScrollingDown() {
        return this.isScrollingDown;
    }

    public void setScrollingDown(boolean value) {
        if (this.isSmooth()) {
            this.isScrollingDown = value;
        }
    }

    public boolean isScrollingUp() {
        return this.isScrollingUp;
    }

    public void setScrollingUp(boolean value) {
        if (this.isSmooth()) {
            this.isScrollingUp = value;
        }
    }

    public GUISlider getSlider() {
        return this.slider;
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public boolean incrementPosition() {
        if (this.currentPosition < this.maxPosition) {
            this.setScrollingDown(true);
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    public boolean decrementPosition() {
        if (this.currentPosition > 0) {
            this.setScrollingUp(true);
            --this.currentPosition;
            return true;
        }
        return false;
    }

    public boolean handleScroller() {
        int i = Mouse.getEventDWheel();
        if (i > 0) {
            return this.decrementPosition();
        }
        if (i < 0) {
            return this.incrementPosition();
        }
        return false;
    }

    public void setPosition(int position) {
        this.currentPosition = position >= 0 ? (position <= this.maxPosition ? position : this.maxPosition) : 0;
    }

    public void reset() {
        this.currentPosition = 0;
        if (this.slider != null) {
            this.slider.resetSlidebarPosition();
        }
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public GUIScroller ignoreBorders() {
        this.ignoreBorders = true;
        return this;
    }

    public boolean shouldIgnoreBorders() {
        return this.ignoreBorders;
    }

    public EnumScrollerType getType() {
        return this.scrollerType;
    }

    public boolean isStandard() {
        return this.scrollerType == EnumScrollerType.STANDARD;
    }

    public boolean isSmooth() {
        return this.scrollerType == EnumScrollerType.SMOOTH;
    }

    public static enum EnumScrollerType {
        STANDARD,
        SMOOTH;

    }
}

