/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.paintings.mod.entity.EntityNewPainting;

public class CPacketSyncPaintingData
implements IMessage {
    private int entityID;
    private BlockPos position;
    private EnumFacing facing;
    private String title;
    private UUID uniqueID;

    public CPacketSyncPaintingData() {
    }

    public CPacketSyncPaintingData(EntityNewPainting painting) {
        this.entityID = painting.func_145782_y();
        this.position = painting.func_174857_n();
        this.facing = painting.field_174860_b;
        this.title = painting.art;
        this.uniqueID = painting.func_110124_au();
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.position = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.facing = EnumFacing.func_176731_b((int)buf.readByte());
        this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.uniqueID = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.position.func_177958_n());
        buf.writeInt(this.position.func_177956_o());
        buf.writeInt(this.position.func_177952_p());
        buf.writeByte(this.facing.func_176736_b());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
        buf.writeLong(this.uniqueID.getMostSignificantBits());
        buf.writeLong(this.uniqueID.getLeastSignificantBits());
    }

    public static class CPacketSyncPaintingDataHandler
    implements IMessageHandler<CPacketSyncPaintingData, IMessage> {
        public IMessage onMessage(CPacketSyncPaintingData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message));
            return null;
        }

        private void process(CPacketSyncPaintingData message) {
            Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
            if (e instanceof EntityNewPainting) {
                EntityNewPainting enp = (EntityNewPainting)e;
                enp.field_174860_b = message.facing;
                enp.art = message.title;
                enp.func_70107_b(message.position.func_177958_n(), message.position.func_177956_o(), message.position.func_177952_p());
                enp.field_70177_z = message.facing.func_185119_l();
            }
        }
    }
}

