/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.traits;

import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.util.DamageSourceInfinitySword;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public class TraitCosmic
extends AbstractTrait {
    public static String id = "cosmic";

    public TraitCosmic() {
        super(id, 0xFF5555);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        int plusmod = 5;
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + plusmod;
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
        boolean harvest = false;
        boolean weapon = false;
        for (Category category : TagUtil.getCategories((NBTTagCompound)rootCompound)) {
            if (category == Category.HARVEST) {
                harvest = true;
            }
            if (category != Category.WEAPON) continue;
            weapon = true;
        }
        if (weapon) {
            TraitCosmic.setEnchantmentLevel(rootCompound, Enchantments.field_185304_p, 10);
        }
        if (harvest) {
            TraitCosmic.setEnchantmentLevel(rootCompound, Enchantments.field_185308_t, 10);
        }
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        AvaritiaEventHandler.applyLuck((BlockEvent.HarvestDropsEvent)event, (int)4);
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (target instanceof EntityPlayer) {
            EntityPlayer pvp = (EntityPlayer)target;
            if (AvaritiaEventHandler.isInfinite((EntityPlayer)pvp)) {
                target.func_70097_a(new DamageSourceInfinitySword((Entity)player).func_76348_h(), 4.0f);
                return;
            }
            if (pvp.func_184586_b(EnumHand.MAIN_HAND) != null && pvp.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.infinity_sword && pvp.func_184587_cr()) {
                return;
            }
        }
        target.func_110142_aN().func_94547_a((DamageSource)new DamageSourceInfinitySword((Entity)player), target.func_110143_aJ(), target.func_110143_aJ());
        target.func_70606_j(0.0f);
        target.func_70645_a((DamageSource)new EntityDamageSource("infinity", (Entity)player));
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (!event.getEntityLiving().field_70122_E) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
        if (!event.getEntityLiving().func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)event.getEntityLiving())) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    public static void setEnchantmentLevel(NBTTagCompound rootTag, Enchantment enchantment, int level) {
        NBTTagList enchantments = rootTag.func_150295_c("ench", 10);
        NBTTagCompound enchTag = new NBTTagCompound();
        int enchId = Enchantment.func_185258_b((Enchantment)enchantment);
        int id = -1;
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            if (enchantments.func_150305_b(i).func_74765_d("id") != enchId) continue;
            enchTag = enchantments.func_150305_b(i);
            id = i;
            break;
        }
        enchTag.func_74777_a("id", (short)enchId);
        enchTag.func_74777_a("lvl", (short)level);
        if (id < 0) {
            enchantments.func_74742_a((NBTBase)enchTag);
        } else {
            enchantments.func_150304_a(id, (NBTBase)enchTag);
        }
        rootTag.func_74782_a("ench", (NBTBase)enchantments);
    }
}

