/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.render;

import com.google.common.collect.ImmutableList;
import com.rcx.materialis.render.TriColorTexture;
import java.awt.image.DirectColorModel;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;

public class TexturedOutlineTexture
extends TriColorTexture {
    protected final ResourceLocation textureLocation;
    protected TextureAtlasSprite texture;
    protected int[] textureData;
    protected int textureWidth;
    protected int textureHeight;
    protected float scale;
    protected boolean edgeMode;
    protected boolean bothMode;
    protected boolean brightnessMode;
    boolean[] outer;
    boolean[] edge;

    public TexturedOutlineTexture(ResourceLocation baseTexture, String spriteName, ResourceLocation texture, String mode, int bright, int mid, int dark, int midThreshold, int darkThreshold) {
        super(baseTexture, spriteName, bright, mid, dark, midThreshold, darkThreshold);
        this.textureLocation = texture;
        this.edgeMode = mode.equals("edge");
        this.bothMode = mode.equals("both");
        this.brightnessMode = mode.equals("brightness");
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll((Iterable)super.getDependencies()).add((Object)this.textureLocation).build();
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.texture = textureGetter.apply(this.textureLocation);
        super.load(manager, location, textureGetter);
        return false;
    }

    protected void preProcess(int[] data) {
        super.preProcess(data);
        DirectColorModel color = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        this.edge = new boolean[this.field_130223_c * this.field_130224_d];
        this.outer = new boolean[this.field_130223_c * this.field_130224_d];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int c;
                if (x == 0 || y == 0 || x == this.field_130223_c - 1 || y == this.field_130224_d - 1) {
                    this.edge[this.coord((int)x, (int)y)] = true;
                }
                if ((c = data[this.coord(x, y)]) != 0 && color.getAlpha(c) >= 64) continue;
                this.outer[this.coord((int)x, (int)y)] = true;
                if (x > 0) {
                    this.edge[this.coord((int)(x - 1), (int)y)] = true;
                }
                if (y > 0) {
                    this.edge[this.coord((int)x, (int)(y - 1))] = true;
                }
                if (x < this.field_130223_c - 1) {
                    this.edge[this.coord((int)(x + 1), (int)y)] = true;
                }
                if (y >= this.field_130224_d - 1) continue;
                this.edge[this.coord((int)x, (int)(y + 1))] = true;
            }
        }
        this.textureData = this.texture.func_147965_a(0)[0];
        this.textureWidth = this.texture.func_94211_a();
        this.textureHeight = this.texture.func_94216_b();
        this.scale = (float)this.textureHeight / (float)this.textureWidth;
    }

    protected void postProcess(int[] data) {
        super.postProcess(data);
        this.textureData = null;
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        if (!this.outer[pxCoord]) {
            if ((this.edgeMode || this.bothMode) && this.edge[pxCoord] || (this.brightnessMode || this.bothMode) && (float)(RenderUtil.red((int)pixel) + RenderUtil.green((int)pixel) + RenderUtil.blue((int)pixel)) < this.darkCap * 3.0f) {
                int texCoord = pxCoord;
                if (this.field_130223_c > this.textureWidth || this.field_130223_c < this.textureWidth) {
                    int texX = pxCoord % this.field_130223_c % this.textureWidth;
                    int texY = pxCoord / this.field_130224_d % this.textureHeight;
                    texCoord = texY * this.textureWidth + texX;
                }
                int c = this.textureData[texCoord];
                int a = RenderUtil.alpha((int)pixel);
                int r = RenderUtil.red((int)c);
                int b = RenderUtil.blue((int)c);
                int g = RenderUtil.green((int)c);
                return RenderUtil.compose((int)r, (int)g, (int)b, (int)a);
            }
            return super.colorPixel(pixel, pxCoord);
        }
        return pixel;
    }
}

