/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.core.item.ModeledItemBlock;
import thedarkcolour.futuremc.block.villagepillage.ScaffoldingBlock;
import thedarkcolour.futuremc.registry.FBlocks;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J:\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002JH\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016\u00a8\u0006 "}, d2={"Lthedarkcolour/futuremc/item/ScaffoldingItem;", "Lthedarkcolour/core/item/ModeledItemBlock;", "()V", "canPlaceBlockOnSide", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lnet/minecraft/util/EnumFacing;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "stack", "Lnet/minecraft/item/ItemStack;", "canPlaceIgnoreBlockCheck", "level", "blockIn", "Lnet/minecraft/block/Block;", "skipCollisionCheck", "sidePlacedOn", "placer", "Lnet/minecraft/entity/Entity;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "hitX", "", "hitY", "hitZ", "future-mc"})
public final class ScaffoldingItem
extends ModeledItemBlock {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        IBlockState clickedState;
        Intrinsics.checkParameterIsNotNull((Object)((Object)player), (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        BlockPos placementPos = pos;
        IBlockState iBlockState = clickedState = worldIn.func_180495_p(placementPos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"clickedState");
        if (!iBlockState.func_177230_c().func_176200_f((IBlockAccess)worldIn, placementPos) && Intrinsics.areEqual((Object)clickedState.func_177230_c(), (Object)this.field_150939_a) ^ true) {
            BlockPos blockPos = placementPos.func_177972_a(facing);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"placementPos.offset(facing)");
            placementPos = blockPos;
        } else {
            if (Intrinsics.areEqual((Object)clickedState.func_177230_c(), (Object)this.field_150939_a) ^ true && ScaffoldingBlock.Companion.getHorizontalDistance(worldIn, placementPos) == 7) {
                return EnumActionResult.FAIL;
            }
            EnumFacing direction = player.func_70093_af() ? facing : (facing == EnumFacing.UP ? player.func_174811_aO() : EnumFacing.UP);
            int i2 = 0;
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(placementPos).func_189536_c(direction);
            boolean found = false;
            while (i2 < 7) {
                IBlockState state;
                if (!worldIn.field_72995_K && !worldIn.func_175723_af().func_177746_a((BlockPos)cursor)) {
                    if (!(player instanceof EntityPlayerMP)) break;
                    BlockPos.MutableBlockPos mutableBlockPos = cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"cursor");
                    if (mutableBlockPos.func_177956_o() >= 255) break;
                    break;
                }
                IBlockState iBlockState2 = state = worldIn.func_180495_p((BlockPos)cursor);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
                if (Intrinsics.areEqual((Object)iBlockState2.func_177230_c(), (Object)this.field_150939_a) ^ true) {
                    if (!state.func_177230_c().func_176200_f((IBlockAccess)worldIn, (BlockPos)cursor)) break;
                    BlockPos.MutableBlockPos mutableBlockPos = cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"cursor");
                    placementPos = (BlockPos)mutableBlockPos;
                    found = true;
                    break;
                }
                cursor.func_189536_c(direction);
                EnumFacing enumFacing = direction;
                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"direction");
                EnumFacing.Axis axis = enumFacing.func_176740_k();
                Intrinsics.checkExpressionValueIsNotNull((Object)axis, (String)"direction.axis");
                if (!axis.func_176722_c()) continue;
                ++i2;
            }
            if (!found) {
                return EnumActionResult.FAIL;
            }
        }
        ItemStack itemStack = stack = player.func_184586_b(hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        if (!itemStack.func_190926_b() && player.func_175151_a(placementPos, facing, stack)) {
            Block block = this.field_150939_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"this.block");
            if (this.canPlaceIgnoreBlockCheck(worldIn, block, placementPos, false, facing, (Entity)player)) {
                int meta = this.func_77647_b(stack.func_77960_j());
                IBlockState state = this.field_150939_a.getStateForPlacement(worldIn, placementPos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand);
                if (this.placeBlockAt(stack, player, worldIn, placementPos, facing, hitX, hitY, hitZ, state)) {
                    SoundType soundType;
                    IBlockState iBlockState3 = state = worldIn.func_180495_p(placementPos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"state");
                    SoundType soundType2 = soundType = iBlockState3.func_177230_c().getSoundType(state, worldIn, placementPos, (Entity)player);
                    Intrinsics.checkExpressionValueIsNotNull((Object)soundType2, (String)"soundType");
                    worldIn.func_184133_a(player, placementPos, soundType2.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_179222_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumFacing side, @NotNull EntityPlayer player, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)((Object)player), (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    private final boolean canPlaceIgnoreBlockCheck(World level, Block blockIn, BlockPos pos, boolean skipCollisionCheck, EnumFacing sidePlacedOn, Entity placer) {
        AxisAlignedBB bounds;
        AxisAlignedBB axisAlignedBB;
        IBlockState state = level.func_180495_p(pos);
        if (skipCollisionCheck) {
            axisAlignedBB = null;
        } else {
            Block block = this.field_150939_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"this.block");
            axisAlignedBB = bounds = block.func_176223_P().func_185890_d((IBlockAccess)level, pos);
        }
        if (!(placer instanceof EntityPlayer)) {
            BlockEvent.EntityPlaceEvent entityPlaceEvent = ForgeEventFactory.onBlockPlace((Entity)placer, (BlockSnapshot)new BlockSnapshot(level, pos, blockIn.func_176223_P()), (EnumFacing)sidePlacedOn);
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlaceEvent, (String)"ForgeEventFactory.onBloc\u2026aultState), sidePlacedOn)");
            if (entityPlaceEvent.isCanceled()) {
                return false;
            }
        }
        if (bounds != null && !level.func_72917_a(bounds.func_186670_a(pos), placer)) {
            return false;
        }
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return iBlockState.func_177230_c().func_176200_f((IBlockAccess)level, pos);
    }

    public ScaffoldingItem() {
        super(FBlocks.INSTANCE.getSCAFFOLDING());
    }
}

