/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.recipe.smithing.SmithingRecipe;
import thedarkcolour.futuremc.recipe.smithing.SmithingRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.SmithingTable")
public final class SmithingTable {
    @ZenMethod
    public static void addRecipe(IIngredient input, IIngredient material, IItemStack result) {
        CraftTweakerAPI.apply((IAction)new AddAction(input, material, result));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, IItemStack material) {
        CraftTweakerAPI.apply((IAction)new RemoveAction(input, material));
    }

    @ZenMethod
    public static void clearDefaults() {
        SmithingRecipes.INSTANCE.getRecipes().clear();
    }

    private static final class RemoveAction
    implements IAction {
        private final IItemStack input;
        private final IItemStack material;

        private RemoveAction(IItemStack input, IItemStack material) {
            this.input = input;
            this.material = material;
        }

        public void apply() {
            SmithingRecipes.INSTANCE.removeRecipe(CraftTweakerMC.getItemStack((IItemStack)this.input), CraftTweakerMC.getItemStack((IItemStack)this.material));
        }

        public String describe() {
            return "Removed a recipe from the smithing table";
        }
    }

    private static final class AddAction
    implements IAction {
        private final Ingredient input;
        private final Ingredient material;
        private final ItemStack result;

        private AddAction(IIngredient input, IIngredient material, IItemStack result) {
            this.input = CraftTweakerMC.getIngredient((IIngredient)input);
            this.material = CraftTweakerMC.getIngredient((IIngredient)material);
            this.result = CraftTweakerMC.getItemStack((IItemStack)result);
        }

        public void apply() {
            SmithingRecipes.INSTANCE.getRecipes().add(new SmithingRecipe(this.input, this.material, this.result));
        }

        public String describe() {
            return "Added a recipe for the smithing table - Input: " + this.input + ", Material: , Output: " + this.result;
        }
    }
}

