/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.Preconditions;
import forestry.api.genetics.DatabaseMode;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IDatabaseElement;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IElementLayout;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.style.ITextStyle;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.PaneLayout;
import forestry.core.gui.elements.layouts.VerticalLayout;
import forestry.core.utils.Translator;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class DatabaseElement
extends VerticalLayout
implements IDatabaseElement {
    private DatabaseMode mode = DatabaseMode.ACTIVE;
    @Nullable
    private IIndividual individual;
    private int secondColumn = 0;
    private int thirdColumn = 0;

    public DatabaseElement(int width) {
        super(0, 0, width);
        this.secondColumn = width / 2;
    }

    @Override
    public void init(DatabaseMode mode, IIndividual individual, int secondColumn, int thirdColumn) {
        this.mode = mode;
        this.individual = individual;
        this.secondColumn = secondColumn;
        this.thirdColumn = thirdColumn;
    }

    @Override
    @Nullable
    public IIndividual getIndividual() {
        return this.individual;
    }

    @Override
    public IGenome getGenome() {
        Preconditions.checkNotNull((Object)this.individual, (Object)"Database Element has not been initialised.");
        return this.individual.getGenome();
    }

    @Override
    public void addFertilityLine(String chromosomeName, IChromosomeType chromosome, int texOffset) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            if (!(activeAllele instanceof IAlleleInteger) || !(inactiveAllele instanceof IAlleleInteger)) {
                return;
            }
            this.addLine(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleInteger)activeAllele, texOffset), GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleInteger)inactiveAllele, texOffset));
        } else {
            IAllele allele;
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele iAllele = allele = active ? activeAllele : inactiveAllele;
            if (!(allele instanceof IAlleleInteger)) {
                return;
            }
            this.addLine(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleInteger)allele, texOffset));
        }
    }

    @Override
    public void addToleranceLine(IChromosomeType chromosome) {
        IAllele allele = this.getGenome().getActiveAllele(chromosome);
        if (!(allele instanceof IAlleleTolerance)) {
            return;
        }
        this.addLine("  " + Translator.translateToLocal("for.gui.tolerance"), (IGuiElement)GuiElementFactory.INSTANCE.createToleranceInfo((IAlleleTolerance)allele));
    }

    @Override
    public void addMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        IElementGroup element = GuiElementFactory.INSTANCE.createMutation(x, y, width, height, mutation, species, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        IElementGroup element = GuiElementFactory.INSTANCE.createMutationResultant(x, y, width, height, mutation, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addLine(String firstText, String secondText, boolean dominant) {
        this.addLine(firstText, secondText, GuiElementFactory.GUI_STYLE, GuiElementFactory.INSTANCE.getStateStyle(dominant));
    }

    @Override
    public void addLine(String leftText, Function<Boolean, String> toText, boolean dominant) {
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(leftText, toText.apply(true), toText.apply(false), dominant, dominant);
        } else {
            this.addLine(leftText, toText.apply(this.mode == DatabaseMode.ACTIVE), dominant);
        }
    }

    @Override
    public void addLine(String leftText, Function<Boolean, String> toText, IChromosomeType chromosome) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(leftText, toText.apply(true), toText.apply(false), activeAllele.isDominant(), inactiveAllele.isDominant());
        } else {
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele allele = active ? activeAllele : inactiveAllele;
            this.addLine(leftText, toText.apply(active), allele.isDominant());
        }
    }

    public void addLine(String firstText, String secondText, String thirdText, boolean secondDominant, boolean thirdDominant) {
    }

    @Override
    public final void addLine(String chromosomeName, IChromosomeType chromosome) {
        this.addLine(chromosomeName, (A allele, Boolean b) -> allele.getAlleleName(), chromosome);
    }

    @Override
    public void addLine(String firstText, String secondText, ITextStyle firstStyle, ITextStyle secondStyle) {
        IElementLayout first = this.addSplitText(this.width, firstText, GuiElementAlignment.TOP_LEFT, firstStyle);
        IElementLayout second = this.addSplitText(this.width, secondText, GuiElementAlignment.TOP_LEFT, secondStyle);
        this.addLine(first, (IGuiElement)second);
    }

    private IElementLayout addSplitText(int width, String text, GuiElementAlignment alignment, ITextStyle style) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        VerticalLayout vertical = new VerticalLayout(width);
        for (String splitText : fontRenderer.func_78271_c(text, 70)) {
            vertical.label(splitText, alignment, style);
        }
        return vertical;
    }

    private void addLine(String chromosomeName, IGuiElement right) {
        int center = this.width / 2;
        IElementLayout first = this.addSplitText(center, chromosomeName, GuiElementAlignment.TOP_LEFT, GuiElementFactory.GUI_STYLE);
        this.addLine(first, right);
    }

    private void addLine(String chromosomeName, IGuiElement second, IGuiElement third) {
        int center = this.width / 2;
        IElementLayout first = this.addSplitText(center, chromosomeName, GuiElementAlignment.TOP_LEFT, GuiElementFactory.GUI_STYLE);
        this.addLine(first, second, third);
    }

    private void addLine(IGuiElement first, IGuiElement second, IGuiElement third) {
        PaneLayout panel = new PaneLayout(this.width, 0);
        first.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        second.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        third.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        panel.add(first);
        panel.add(second);
        panel.add(third);
        second.setXPosition(this.secondColumn);
        third.setXPosition(this.thirdColumn);
        this.add(panel);
    }

    private void addLine(IGuiElement first, IGuiElement second) {
        PaneLayout panel = new PaneLayout(this.width, 0);
        first.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        second.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        panel.add(first);
        panel.add(second);
        second.setXPosition(this.secondColumn);
        this.add(panel);
    }

    @Override
    public <A extends IAllele> void addLine(String chromosomeName, BiFunction<A, Boolean, String> toText, IChromosomeType chromosome) {
        this.addAlleleRow(chromosomeName, toText, chromosome, null);
    }

    @Override
    public <A extends IAllele> void addLine(String chromosomeName, BiFunction<A, Boolean, String> toText, IChromosomeType chromosome, boolean dominant) {
        this.addAlleleRow(chromosomeName, toText, chromosome, dominant);
    }

    private <A extends IAllele> void addAlleleRow(String chromosomeName, BiFunction<A, Boolean, String> toString, IChromosomeType chromosome, @Nullable Boolean dominant) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(chromosomeName, toString.apply(activeAllele, true), toString.apply(inactiveAllele, false), dominant != null ? dominant.booleanValue() : activeAllele.isDominant(), dominant != null ? dominant.booleanValue() : inactiveAllele.isDominant());
        } else {
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele allele = active ? activeAllele : inactiveAllele;
            this.addLine(chromosomeName, toString.apply(allele, active), dominant != null ? dominant.booleanValue() : allele.isDominant());
        }
    }

    @Override
    public void addSpeciesLine(String firstText, @Nullable String secondText, IChromosomeType chromosome) {
    }
}

