/*
 * Decompiled with CFR 0.152.
 */
package singulariteam.eternalsingularity.proxy;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import morph.avaritia.init.ModItems;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import singulariteam.eternalsingularity.EternalRecipeTweaker;
import singulariteam.eternalsingularity.EternalSingularityMod;
import singulariteam.eternalsingularity.item.CompoundSingularityItem;
import singulariteam.eternalsingularity.item.EternalSingularityItem;

public class CommonProxy {
    public static NonNullList<Ingredient> singularityIngredients = NonNullList.func_191196_a();
    public static final IExtremeRecipe eternalSingularityRecipe = (IExtremeRecipe)AvaritiaRecipeManager.EXTREME_RECIPES.put(EternalSingularityItem.instance.getRegistryName(), new ExtremeShapelessRecipe(singularityIngredients, new ItemStack((Item)EternalSingularityItem.instance)).setRegistryName(EternalSingularityItem.instance.getRegistryName()));
    private static final Set<Class> classSet = new HashSet<Class>();
    protected CompoundSingularityItem compoundSingularityItem = null;
    private File configFile;

    public void preInit(File file) {
        this.configFile = file;
        Configuration config = new Configuration(this.configFile);
        String[] classNameList = config.getStringList("classNameList", "general", new String[]{"morph.avaritia.item.ItemSingularity", "shadows.singularity.item.ItemSingularity", "thelm.jaopca.singularities.ItemSingularityBase", "wanion.thermsingul.ThermalSingularityItem", "wealthyturtle.uiesingularities.UniversalSingularityItem"}, "here is the absolute class name of the Item Classes that must be removed from Infinity Catalyst recipe and inserted into Eternal Singularity.");
        if (config.hasChanged()) {
            config.save();
        }
        for (String className : classNameList) {
            try {
                classSet.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                EternalSingularityMod.logger.warn("Couldn't find " + className);
            }
        }
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)EternalSingularityItem.instance);
        this.compoundSingularityItem = new CompoundSingularityItem(16);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.compoundSingularityItem);
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            EternalRecipeTweaker.init();
        }
    }

    public void init() {
    }

    public void postInit() {
        Configuration config;
        boolean useCompoundSingularities;
        if (classSet.isEmpty()) {
            return;
        }
        IExtremeRecipe catalystRecipe = null;
        for (IExtremeRecipe recipe : AvaritiaRecipeManager.EXTREME_RECIPES.values()) {
            if (!recipe.getRecipeOutput().func_77969_a(ModItems.infinity_catalyst)) continue;
            catalystRecipe = recipe;
            break;
        }
        boolean loadAllCompoundSingularities = (useCompoundSingularities = (config = new Configuration(this.configFile)).getBoolean("useCompoundSingularities", "general", false, "When useCompoundSingularities is Enabled, Basic Singularities will Need to be Crafted into Compound Singularities First.\n[If there are > 81 Basic Singularities, this Config Option will be Set to True Automatically]")) && config.getBoolean("loadAllCompoundSingularities", "general", false, "Enables all compound singularities instead of only the ones needed.");
        boolean easyMode = config.getBoolean("easyMode", "general", false, "If this Config Option is Enabled, for Every 9 Singularities Used in the Eternal Singularity Recipe, You will Receive an Additional Eternal Singularity for the Recipe Output.");
        if (config.hasChanged()) {
            config.save();
        }
        if (catalystRecipe != null && !catalystRecipe.isShapedRecipe()) {
            int compoundMax;
            block1: for (Ingredient inputIngredient : catalystRecipe.getIngredients()) {
                ItemStack[] input = inputIngredient.func_193365_a();
                if (inputIngredient.equals(Ingredient.field_193370_a) || input.length == 0) {
                    catalystRecipe.getIngredients().remove((Object)inputIngredient);
                    continue;
                }
                for (ItemStack stack : input) {
                    if (stack.func_77973_b() == null || !classSet.contains(stack.func_77973_b().getClass())) continue;
                    singularityIngredients.add((Object)inputIngredient);
                    continue block1;
                }
            }
            int singularityCount = singularityIngredients.size();
            if (singularityCount == 0 || catalystRecipe.isShapedRecipe()) {
                AvaritiaRecipeManager.EXTREME_RECIPES.remove(EternalSingularityItem.instance.getRegistryName());
                if (!useCompoundSingularities) {
                    this.compoundSingularityItem.max = 0;
                }
                return;
            }
            catalystRecipe.getIngredients().removeAll(singularityIngredients);
            boolean aboveTheLimit = singularityCount > 81;
            useCompoundSingularities = useCompoundSingularities || aboveTheLimit;
            int n = compoundMax = loadAllCompoundSingularities ? 16 : (int)Math.ceil((float)singularityCount / 9.0f);
            if (useCompoundSingularities) {
                int i;
                this.compoundSingularityItem.max = compoundMax;
                NonNullList<Ingredient> eternalSingularityRecipeInputs = singularityIngredients;
                for (i = 0; i < compoundMax; ++i) {
                    int pos;
                    NonNullList compoundIngredients = NonNullList.func_191196_a();
                    ShapelessRecipes compoundRecipe = new ShapelessRecipes(this.compoundSingularityItem.getRegistryName().toString() + i, new ItemStack((Item)this.compoundSingularityItem, 1, MathHelper.func_76125_a((int)i, (int)0, (int)64)), compoundIngredients);
                    for (int s = 0; s < 9 && (pos = 9 * i + s) <= singularityCount - 1; ++s) {
                        Ingredient input = (Ingredient)eternalSingularityRecipeInputs.get(pos);
                        compoundIngredients.add((Object)input);
                    }
                    compoundRecipe.setRegistryName(this.compoundSingularityItem.getRegistryName().toString() + i);
                    if (compoundIngredients.size() <= 0) continue;
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)compoundRecipe);
                }
                eternalSingularityRecipeInputs.clear();
                for (i = 0; i < compoundMax; ++i) {
                    eternalSingularityRecipeInputs.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)this.compoundSingularityItem, 1, i)}));
                }
            } else {
                this.compoundSingularityItem.max = 0;
            }
            catalystRecipe.getIngredients().add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)EternalSingularityItem.instance, easyMode ? MathHelper.func_76125_a((int)compoundMax, (int)1, (int)64) : 1)}));
        } else if (!useCompoundSingularities) {
            this.compoundSingularityItem.max = 0;
        }
    }
}

