/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;
import forestry.api.core.ForestryAPI;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlBiome
extends Control
implements ITooltip {
    private final Biome biome;
    private String iconCategory = "plains";

    public ControlBiome(IWidget parent, int x, int y, int w, int h, Biome biome) {
        super(parent, x, y, w, h);
        this.biome = biome;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            this.iconCategory = "hills";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            this.iconCategory = "desert";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.iconCategory = "snow";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            this.iconCategory = "forest";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            this.iconCategory = "swamp";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.iconCategory = "jungle";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            this.iconCategory = "taiga";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            this.iconCategory = "mushroom";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            this.iconCategory = "ocean";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            this.iconCategory = "nether";
        }
        if (BiomeDictionary.hasType((Biome)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            this.iconCategory = "end";
        }
        TextureAtlasSprite sprite = ForestryAPI.textureManager.getDefault("habitats/" + this.iconCategory);
        RenderUtil.drawGuiSprite(Point.ZERO, sprite);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(this.biome.func_185359_l().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2"));
    }
}

