/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.models;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DoublePassBakedModel
implements IBakedModel {
    private static final int c = DefaultVertexFormats.field_176599_b.func_177340_e() / 4;
    private static final int v = DefaultVertexFormats.field_176599_b.func_177338_f() / 4;
    private final IBakedModel mainModel;
    private int primaryColor = -16777216;
    private int secondaryColor = -16777216;

    public DoublePassBakedModel(IBakedModel mainModel, int primaryColor, int secondaryColor) {
        this.mainModel = mainModel;
        this.primaryColor |= Integer.reverseBytes(primaryColor) >> 8;
        this.secondaryColor |= Integer.reverseBytes(secondaryColor) >> 8;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List quads = this.mainModel.func_188616_a(state, side, rand);
        LinkedList<BakedQuad> recolored = new LinkedList<BakedQuad>();
        quads.forEach(quad -> {
            if (quad.func_178212_b()) {
                if (quad.func_178211_c() == 0) {
                    recolored.add(this.recolorQuad((BakedQuad)quad, this.primaryColor));
                } else {
                    recolored.add(this.recolorQuad((BakedQuad)quad, this.secondaryColor));
                }
            } else {
                recolored.add((BakedQuad)quad);
            }
        });
        return recolored;
    }

    public BakedQuad recolorQuad(BakedQuad quad, int color) {
        int[] vertexData = quad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            vertexData[DoublePassBakedModel.v * i + DoublePassBakedModel.c] = color;
        }
        return quad;
    }

    public boolean func_177555_b() {
        return this.mainModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.mainModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.mainModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.mainModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.mainModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.mainModel.func_188617_f();
    }
}

