/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DriveWatcher;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class TileDrive
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost {
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_BLINK_MASK = 0x24924924;
    private static final int BIT_STATE_MASK = -613566757;
    private final AppEngCellInventory inv = new AppEngCellInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DriveWatcher<IAEItemStack>[] invBySlot = new DriveWatcher[10];
    private final IActionSource mySrc = new MachineSource(this);
    private boolean isCached = false;
    private final Map<IStorageChannel<? extends IAEStack<?>>, List<IMEInventoryHandler>> inventoryHandlers;
    private int priority = 0;
    private boolean wasActive = false;
    private int state = 0;

    public TileDrive() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inv.setFilter(new CellValidInventoryFilter());
        this.inventoryHandlers = new IdentityHashMap();
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        int newState = 0;
        if (this.getProxy().isActive()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
        }
        data.writeInt(newState);
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || c;
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 3;
        }
        DriveWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return (this.state >> slot * 3 + 2 & 1) == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a("priority", this.priority);
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int newState = 0;
        if (currentActive) {
            newState |= Integer.MIN_VALUE;
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
        }
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            if (this.getProxy().isActive()) {
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            Collection<IStorageChannel<IAEStack<?>>> storageChannels = AEApi.instance().storage().storageChannels();
            storageChannels.forEach(channel -> this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, new ArrayList(10)));
            double power = 2.0;
            block0: for (int x = 0; x < this.inv.getSlots(); ++x) {
                ItemStack is = this.inv.getStackInSlot(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.func_190926_b()) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : storageChannels) {
                    ICellInventoryHandler<? extends IAEStack<?>> cell = this.handlersBySlot[x].getCellInventory(is, this, iStorageChannel);
                    if (cell == null) continue;
                    this.inv.setHandler(x, cell);
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    DriveWatcher ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.inventoryHandlers.get(iStorageChannel).add(ih);
                    continue block0;
                }
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        this.updateState();
        return this.inventoryHandlers.get(channel);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return AEApi.instance().definitions().blocks().drive().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_DRIVE;
    }

    private class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && AEApi.instance().registries().cell().isCellHandled(stack);
        }
    }
}

