/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.solars;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTTagCompound;

public class TileEnergyPanelBasic
extends AENetworkTile
implements IGridTickable {
    public static double powerPerTick = AEConfig.instance().getBasicSolarPanelGenPerTick();
    public static final double powerPerTickAtNight = AEConfig.instance().getBasicSolarPanelGenPerTickNight();
    public static final double internalMaxEnergyCapacity = AEConfig.instance().getBasicSolarPanelCapacity();
    public double internalCurrentEnergy;
    private static int ticksUpdateVisibility = 100;

    public TileEnergyPanelBasic() {
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        return true;
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.SolarBasic.getMin(), TickRates.SolarBasic.getMax(), this.canSleep(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean isDay = this.field_145850_b.func_72935_r();
        if (ticksUpdateVisibility > 0) {
            --ticksUpdateVisibility;
            if (!this.field_145850_b.field_73011_w.func_177495_o()) {
                return this.makeEnergy(isDay);
            }
        } else if (this.updateVisibility()) {
            ticksUpdateVisibility = 100;
            return this.makeEnergy(isDay);
        }
        return TickRateModulation.SLOWER;
    }

    public TickRateModulation makeEnergy(boolean isDay) {
        this.internalCurrentEnergy = isDay && !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() ? (this.internalCurrentEnergy += powerPerTick) : (this.internalCurrentEnergy += powerPerTickAtNight);
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double overFlow = grid.injectPower(this.internalCurrentEnergy, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, this.internalCurrentEnergy - overFlow), Actionable.MODULATE);
            this.internalCurrentEnergy = overFlow;
            return TickRateModulation.URGENT;
        }
        catch (GridAccessException e) {
            return TickRateModulation.SLOWER;
        }
    }

    public boolean updateVisibility() {
        return this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b;
    }

    public boolean canSleep() {
        return this.internalCurrentEnergy >= internalMaxEnergyCapacity;
    }
}

