/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkTile;
import appeng.util.SettingsFrom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class CreativeTileEnergyCell
extends AENetworkTile
implements IAEPowerStorage {
    private double internalCurrentPower = 9.22337203685477E14;
    private long internalMaxPower = 922337203685477L;
    private byte currentMeta = (byte)-1;

    public CreativeTileEnergyCell() {
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public void onReady() {
        super.onReady();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        int boundMetadata = (int)(8.0 * fillFactor);
        if (boundMetadata > 7) {
            boundMetadata = 7;
        }
        if (boundMetadata < 0) {
            boundMetadata = 0;
        }
        return boundMetadata;
    }

    private void changePowerLevel() {
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74780_a("internalCurrentPower", this.internalCurrentPower);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.internalCurrentPower = data.func_74769_h("internalCurrentPower");
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = compound.func_74769_h("internalCurrentPower");
        }
    }

    @Override
    public NBTTagCompound downloadSettings(SettingsFrom from) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("internalCurrentPower", this.internalCurrentPower);
            tag.func_74780_a("internalMaxPower", (double)this.getInternalMaxPower());
            return tag;
        }
        return null;
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.0) {
            this.getProxy().getNode().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > (double)this.getInternalMaxPower()) {
            amt = this.internalCurrentPower - (double)this.getInternalMaxPower();
            this.internalCurrentPower = this.getInternalMaxPower();
            return amt;
        }
        return 0.0;
    }

    @Override
    public double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return Math.min(this.internalCurrentPower, amt);
        }
        if (amt > 0.0) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        return amt;
    }

    private long getInternalMaxPower() {
        return this.internalMaxPower;
    }

    void setInternalMaxPower(long internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }
}

