/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.tile.crafting.TileCraftingTile;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public class TileCraftingStorageTile
extends TileCraftingTile {
    private static final int KILO_SCALAR = 1024;

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        Optional<Object> is;
        IBlocks blocks = AEApi.instance().definitions().blocks();
        int storage = ((TileCraftingTile)obj).getStorageBytes() / 1024;
        long storageLong = ((TileCraftingTile)obj).getStorageBytesLong();
        if (storageLong != 0L) {
            is = blocks.craftingStorage2gb().maybeStack(1);
        } else {
            Optional<Object> optional;
            switch (storage) {
                case 1: {
                    optional = blocks.craftingStorage1k().maybeStack(1);
                    break;
                }
                case 4: {
                    optional = blocks.craftingStorage4k().maybeStack(1);
                    break;
                }
                case 16: {
                    optional = blocks.craftingStorage16k().maybeStack(1);
                    break;
                }
                case 64: {
                    optional = blocks.craftingStorage64k().maybeStack(1);
                    break;
                }
                case 1024: {
                    optional = blocks.craftingStorage1mb().maybeStack(1);
                    break;
                }
                case 4096: {
                    optional = blocks.craftingStorage4mb().maybeStack(1);
                    break;
                }
                case 16384: {
                    optional = blocks.craftingStorage16mb().maybeStack(1);
                    break;
                }
                case 65536: {
                    optional = blocks.craftingStorage64mb().maybeStack(1);
                    break;
                }
                case 262144: {
                    optional = blocks.craftingStorage256mb().maybeStack(1);
                    break;
                }
                case 0x100000: {
                    optional = blocks.craftingStorage1gb().maybeStack(1);
                    break;
                }
                case 0x1FFFFF: {
                    optional = blocks.craftingStorage2gb().maybeStack(1);
                    break;
                }
                default: {
                    optional = Optional.empty();
                }
            }
            is = optional;
        }
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isAcceleratorx4() {
        return false;
    }

    @Override
    public boolean isAcceleratorx16() {
        return false;
    }

    @Override
    public boolean isAcceleratorx64() {
        return false;
    }

    @Override
    public boolean isAcceleratorx128() {
        return false;
    }

    @Override
    public boolean isAcceleratorx256() {
        return false;
    }

    @Override
    public boolean isAcceleratorx512() {
        return false;
    }

    @Override
    public boolean isAcceleratorx1024() {
        return false;
    }

    @Override
    public boolean isAcceleratorCreative() {
        return false;
    }

    @Override
    public boolean isStorage() {
        return true;
    }

    @Override
    public int getStorageBytes() {
        int n;
        if (this.field_145850_b == null || this.notLoaded() || this.func_145837_r()) {
            return 0;
        }
        BlockCraftingUnit unit = (BlockCraftingUnit)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        switch (unit.type) {
            default: {
                n = 1024;
                break;
            }
            case STORAGE_4K: {
                n = 4096;
                break;
            }
            case STORAGE_16K: {
                n = 16384;
                break;
            }
            case STORAGE_64K: {
                n = 65536;
                break;
            }
            case STORAGE_1MB: {
                n = 0x100000;
                break;
            }
            case STORAGE_4MB: {
                n = 0x400000;
                break;
            }
            case STORAGE_16MB: {
                n = 0x1000000;
                break;
            }
            case STORAGE_64MB: {
                n = 0x4000000;
                break;
            }
            case STORAGE_256MB: {
                n = 0x10000000;
                break;
            }
            case STORAGE_1GB: {
                n = 0x40000000;
                break;
            }
            case STORAGE_2GB: {
                n = Integer.MAX_VALUE;
            }
        }
        return n;
    }

    @Override
    public long getStorageBytesLong() {
        if (this.field_145850_b == null || this.notLoaded() || this.func_145837_r()) {
            return 0L;
        }
        BlockCraftingUnit unit = (BlockCraftingUnit)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (unit.type != BlockCraftingUnit.CraftingUnitType.STORAGE_CREATIVE) {
            return 0L;
        }
        return Long.MAX_VALUE;
    }
}

