/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import appeng.parts.misc.PartStorageBus;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import appeng.util.item.AEItemStack;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

class ItemHandlerAdapter
implements IMEInventory<IAEItemStack>,
IBaseMonitor<IAEItemStack>,
ITickingMonitor {
    private final Object2ObjectMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new Object2ObjectOpenHashMap();
    private IActionSource mySource;
    private final IItemHandler itemHandler;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;
    private StorageFilter mode;
    private AccessRestriction access;

    ItemHandlerAdapter(IItemHandler itemHandler, IGridProxyable proxy) {
        this.itemHandler = itemHandler;
        IGridProxyable iGridProxyable = this.proxyable = proxy;
        if (iGridProxyable instanceof PartStorageBus) {
            PartStorageBus partStorageBus = (PartStorageBus)iGridProxyable;
            this.mode = (StorageFilter)partStorageBus.getConfigManager().getSetting(Settings.STORAGE_FILTER);
            this.access = (AccessRestriction)partStorageBus.getConfigManager().getSetting(Settings.ACCESS);
        }
        this.cache = new InventoryCache(this.itemHandler, this.mode);
        this.cache.update();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack iox, Actionable type, IActionSource src) {
        ItemStack inputStack;
        ItemStack remaining = inputStack = iox.getCachedItemStack(iox.getStackSize());
        int slotCount = this.itemHandler.getSlots();
        for (int i = 0; i < slotCount && !remaining.func_190926_b(); ++i) {
            remaining = this.itemHandler.insertItem(i, remaining, type == Actionable.SIMULATE);
        }
        if (type == Actionable.SIMULATE) {
            iox.setCachedItemStack(inputStack);
        } else if (!remaining.func_190926_b()) {
            iox.setCachedItemStack(remaining);
        }
        if (remaining == inputStack) {
            return iox;
        }
        if (type == Actionable.MODULATE) {
            IAEItemStack added = (IAEItemStack)iox.copy().setStackSize(iox.getStackSize() - (long)remaining.func_190916_E());
            this.cache.currentlyCached.add(added);
            this.postDifference(Collections.singletonList(added));
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEItemStack.fromItemStack(remaining);
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        int remainingSize = Ints.saturatedCast((long)request.getStackSize());
        ItemStack gathered = ItemStack.field_190927_a;
        boolean simulate = mode == Actionable.SIMULATE;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack stackInInventorySlot = this.itemHandler.getStackInSlot(i);
            if (!request.isSameType(stackInInventorySlot)) continue;
            int stackSizeCurrentSlot = stackInInventorySlot.func_190916_E();
            int remainingCurrentSlot = Math.min(remainingSize, stackSizeCurrentSlot);
            do {
                if ((extracted = this.itemHandler.extractItem(i, remainingCurrentSlot, simulate)).func_190926_b()) continue;
                if (extracted == stackInInventorySlot) {
                    extracted = extracted.func_77946_l();
                }
                if (extracted.func_190916_E() > remainingCurrentSlot) {
                    AELog.warn("Mod that provided item handler %s is broken. Returned %s items while only requesting %d.", this.itemHandler.getClass().getName(), extracted.toString(), remainingCurrentSlot);
                    extracted.func_190920_e(remainingCurrentSlot);
                }
                if (simulate && extracted.func_190916_E() == extracted.func_77976_d() && remainingCurrentSlot > extracted.func_77976_d()) {
                    extracted.func_190920_e(remainingCurrentSlot);
                }
                if (gathered.func_190926_b()) {
                    gathered = extracted;
                } else {
                    gathered.func_190917_f(extracted.func_190916_E());
                }
                remainingCurrentSlot -= extracted.func_190916_E();
            } while (!simulate && !extracted.func_190926_b() && remainingCurrentSlot > 0);
            if ((remainingSize -= stackSizeCurrentSlot - remainingCurrentSlot) <= 0) break;
        }
        if (!gathered.func_190926_b()) {
            AEItemStack gatheredAEItemStack = AEItemStack.fromItemStack(gathered);
            if (mode == Actionable.MODULATE) {
                IAEItemStack cachedStack = this.cache.currentlyCached.findPrecise(request);
                if (cachedStack != null) {
                    cachedStack.decStackSize(gatheredAEItemStack.getStackSize());
                    this.postDifference(Collections.singletonList((IAEItemStack)gatheredAEItemStack.copy().setStackSize(-gatheredAEItemStack.getStackSize())));
                }
                try {
                    this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            return gatheredAEItemStack;
        }
        return null;
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEItemStack> changes = this.cache.update();
        if (!changes.isEmpty() && this.access.hasPermission(AccessRestriction.READ)) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        return this.cache.getAvailableItems(out);
    }

    public IItemStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        ObjectIterator i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry l = (Map.Entry)i.next();
            IMEMonitorHandlerReceiver key = (IMEMonitorHandlerReceiver)l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.mySource);
                continue;
            }
            i.remove();
        }
    }

    private static class InventoryCache
    implements Iterable<ItemSlot> {
        private final IItemHandler itemHandler;
        private final StorageFilter mode;
        IItemList<IAEItemStack> currentlyCached = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();

        public InventoryCache(IItemHandler itemHandler, StorageFilter mode) {
            this.mode = mode;
            this.itemHandler = itemHandler;
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            this.currentlyCached.iterator().forEachRemaining(out::add);
            return out;
        }

        private StorageFilter getMode() {
            return this.mode;
        }

        public List<IAEItemStack> update() {
            ArrayList<IAEItemStack> changes = new ArrayList<IAEItemStack>();
            IItemList<IAEItemStack> currentlyOnStorage = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            for (ItemSlot itemSlot : this) {
                if (this.mode == StorageFilter.EXTRACTABLE_ONLY && !itemSlot.isExtractable()) continue;
                currentlyOnStorage.add(itemSlot.getAEItemStack());
            }
            for (IAEItemStack iAEItemStack : this.currentlyCached) {
                iAEItemStack.setStackSize(-iAEItemStack.getStackSize());
            }
            for (IAEItemStack iAEItemStack : currentlyOnStorage) {
                this.currentlyCached.add(iAEItemStack);
            }
            for (IAEItemStack iAEItemStack : this.currentlyCached) {
                if (iAEItemStack.getStackSize() == 0L) continue;
                changes.add(iAEItemStack);
            }
            this.currentlyCached = currentlyOnStorage;
            return changes;
        }

        @Override
        public Iterator<ItemSlot> iterator() {
            return new ItemHandlerIterator(this.itemHandler);
        }
    }
}

