/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.core.sync.GuiBridge;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.parts.automation.PartSharedItemBusImp;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.item.AEItemStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PartImportBusImp
extends PartSharedItemBusImp
implements IInventoryDestination {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/import_bus_base_gold");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_off_gold"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_on_gold"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_has_channel_gold"));
    private final IActionSource source;
    private int itemsToSend = 4096;
    private boolean worked;

    public PartImportBusImp(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource(this);
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        try {
            IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack out = inv.injectItems((IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stack), Actionable.SIMULATE, this.source);
            if (out == null) {
                return true;
            }
            return out.getStackSize() != (long)stack.func_190916_E();
        }
        catch (GridAccessException ex) {
            return false;
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_BUS);
        }
        return true;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(4, 35, this.isSleeping(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.itemsToSend = this.itemsImpToSend();
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEItemStack ais = this.getConfig().getAEStackInSlot(x);
                    if (ais == null || this.itemsToSend <= 0) continue;
                    Configured = true;
                    while (this.itemsToSend > 0 && !this.importStuff(myAdaptor, ais, inv, energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.itemsToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, inv, energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, whatToImport, inv, fzMode);
        if (toSend == 0) {
            return true;
        }
        ItemStack newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition(), fzMode, this) : myAdaptor.removeItems(toSend, whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition(), this);
        if (!newItems.func_190926_b()) {
            IAEItemStack aeStack = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(newItems);
            IAEItemStack failed = Platform.poweredInsert(energy, inv, aeStack, this.source);
            if (failed != null) {
                IAEItemStack spill = inv.injectItems(failed, Actionable.MODULATE, this.source);
                if (spill != null) {
                    myAdaptor.addItems(spill.createItemStack());
                }
                return true;
            }
            this.itemsToSend -= newItems.func_190916_E();
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    private int calculateMaximumAmountToImport(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, FuzzyMode fzMode) {
        IAEItemStack itemAmountNotStorable;
        ItemStack simResult;
        int toSend = this.itemsToSend;
        ItemStack itemStackToImport = whatToImport == null ? ItemStack.field_190927_a : whatToImport.getDefinition();
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            simResult = myAdaptor.simulateSimilarRemove(toSend, itemStackToImport, fzMode, null);
            itemAmountNotStorable = inv.injectItems(AEItemStack.fromItemStack(simResult), Actionable.SIMULATE, this.source);
        } else {
            simResult = myAdaptor.simulateRemove(toSend, itemStackToImport, null);
            itemAmountNotStorable = inv.injectItems(AEItemStack.fromItemStack(simResult), Actionable.SIMULATE, this.source);
        }
        if (simResult.func_190926_b()) {
            return 0;
        }
        if (itemAmountNotStorable != null) {
            if ((long)simResult.func_190916_E() == itemAmountNotStorable.getStackSize()) {
                return 0;
            }
            return (int)Math.min((long)simResult.func_190916_E() - itemAmountNotStorable.getStackSize(), (long)toSend);
        }
        return toSend;
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

