/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.fluids.helper.IConfigurableFluidInventory;
import appeng.fluids.parts.PartFluidLevelEmitter;
import appeng.fluids.util.AEFluidInventory;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.ItemPart;
import appeng.items.parts.PartType;
import appeng.items.tools.quartz.ToolQuartzCuttingKnife;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.automation.PartLevelEmitter;
import appeng.parts.networking.PartCable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class AEBasePart
implements IPart,
IGridProxyable,
IActionHost,
IUpgradeableHost,
ICustomNameObject {
    private final AENetworkProxy proxy;
    private final ItemStack is;
    private TileEntity tile = null;
    private IPartHost host = null;
    private AEPartLocation side = null;

    public AEBasePart(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        this.is = is;
        this.proxy = new AENetworkProxy(this, "part", is, this instanceof PartCable);
        this.proxy.setValidSides(EnumSet.noneOf(EnumFacing.class));
    }

    public IPartHost getHost() {
        return this.host;
    }

    public PartType getType() {
        return ItemPart.instance.getTypeByStack(this.is);
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.proxy.getNode();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void securityBreak() {
        if (this.getItemStack().func_190916_E() > 0 && this.getGridNode() != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.is.func_77946_l());
            this.host.removePart(this.side, false);
            Platform.spawnDrops(this.tile.func_145831_w(), this.tile.func_174877_v(), items);
            this.is.func_190920_e(0);
        }
    }

    protected AEColor getColor() {
        if (this.host == null) {
            return AEColor.TRANSPARENT;
        }
        return this.host.getColor();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile);
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    public void saveChanges() {
        this.host.markForSave();
    }

    @Override
    public String getCustomInventoryName() {
        return this.getItemStack().func_82833_r();
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.getItemStack().func_82837_s();
    }

    @Override
    public void setCustomName(String name) {
        this.getItemStack().func_151001_c(name);
    }

    public void addEntityCrashInfo(CrashReportCategory crashreportcategory) {
        crashreportcategory.func_71507_a("Part Side", (Object)this.getSide());
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.NETWORK) {
            ItemStack copy = this.is.func_77946_l();
            copy.func_77982_d(null);
            return copy;
        }
        return this.is;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
    }

    @Override
    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.proxy.readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.proxy.writeToNBT(data);
    }

    @Override
    public int isProvidingStrongPower() {
        return 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return 0;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return this.proxy.getNode();
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public void removeFromWorld() {
        this.proxy.invalidate();
    }

    @Override
    public void addToWorld() {
        this.proxy.onReady();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        this.setSide(side);
        this.tile = tile;
        this.host = host;
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, BlockPos pos, Random r) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 3.0f;
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    @Override
    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        return null;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        IItemHandler inv;
        AEBasePart aEBasePart;
        IConfigManager cm;
        if (compound != null && (cm = this.getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if ((aEBasePart = this) instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)aEBasePart);
            pHost.setPriority(compound.func_74762_e("priority"));
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.getSlots(); ++x) {
                target.setStackInSlot(x, tmp.getStackInSlot(x));
            }
            AEBasePart aEBasePart2 = this;
            if (aEBasePart2 instanceof PartLevelEmitter) {
                PartLevelEmitter partLevelEmitter = (PartLevelEmitter)aEBasePart2;
                partLevelEmitter.setReportingValue(compound.func_74763_f("reportingValue"));
            }
        }
        if (this instanceof IConfigurableFluidInventory) {
            AEBasePart aEBasePart3;
            IFluidHandler tank = ((IConfigurableFluidInventory)((Object)this)).getFluidInventoryByName("config");
            if (tank instanceof AEFluidInventory) {
                AEFluidInventory target = (AEFluidInventory)tank;
                AEFluidInventory tmp = new AEFluidInventory(null, target.getSlots());
                tmp.readFromNBT(compound, "config");
                for (int x = 0; x < tmp.getSlots(); ++x) {
                    target.setFluidInSlot(x, tmp.getFluidInSlot(x));
                }
            }
            if ((aEBasePart3 = this) instanceof PartFluidLevelEmitter) {
                PartFluidLevelEmitter partFluidLevelEmitter = (PartFluidLevelEmitter)aEBasePart3;
                partFluidLevelEmitter.setReportingValue(compound.func_74763_f("reportingValue"));
            }
        }
    }

    protected NBTTagCompound downloadSettings(SettingsFrom from) {
        IItemHandler inv;
        AEBasePart aEBasePart;
        NBTTagCompound output = new NBTTagCompound();
        IConfigManager cm = this.getConfigManager();
        if (cm != null) {
            cm.writeToNBT(output);
        }
        if ((aEBasePart = this) instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)aEBasePart);
            output.func_74768_a("priority", pHost.getPriority());
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
            AEBasePart aEBasePart2 = this;
            if (aEBasePart2 instanceof PartLevelEmitter) {
                PartLevelEmitter partLevelEmitter = (PartLevelEmitter)aEBasePart2;
                output.func_74772_a("reportingValue", partLevelEmitter.getReportingValue());
            }
        }
        if (this instanceof IConfigurableFluidInventory) {
            AEBasePart aEBasePart3;
            IFluidHandler tank = ((IConfigurableFluidInventory)((Object)this)).getFluidInventoryByName("config");
            if (tank instanceof AEFluidInventory) {
                ((AEFluidInventory)tank).writeToNBT(output, "config");
            }
            if ((aEBasePart3 = this) instanceof PartFluidLevelEmitter) {
                PartFluidLevelEmitter partFluidLevelEmitter = (PartFluidLevelEmitter)aEBasePart3;
                output.func_74772_a("reportingValue", partFluidLevelEmitter.getReportingValue());
            }
        }
        return output.func_82582_d() ? null : output;
    }

    public boolean useStandardMemoryCard() {
        return true;
    }

    private boolean useMemoryCard(EntityPlayer player) {
        Item item;
        ItemStack memCardIS = player.field_71071_by.func_70448_g();
        if (!memCardIS.func_190926_b() && this.useStandardMemoryCard() && (item = memCardIS.func_77973_b()) instanceof IMemoryCard) {
            Optional<ItemStack> iface;
            IMemoryCard memoryCard = (IMemoryCard)item;
            ItemStack is = this.getItemStack(PartItemStack.NETWORK);
            IDefinitions definitions = AEApi.instance().definitions();
            if (definitions.parts().iface().isSameAs(is) && (iface = definitions.blocks().iface().maybeStack(1)).isPresent()) {
                is = iface.get();
            }
            String name = is.func_77977_a();
            if (player.func_70093_af()) {
                NBTTagCompound data = this.downloadSettings(SettingsFrom.MEMORY_CARD);
                if (data != null) {
                    memoryCard.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                NBTTagCompound data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.uploadSettings(SettingsFrom.MEMORY_CARD, data, player);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                }
            }
            return true;
        }
        return false;
    }

    private boolean useRenamer(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() instanceof ToolQuartzCuttingKnife) {
            if (ForgeEventFactory.onItemUseStart((EntityLivingBase)player, (ItemStack)stack, (int)1) <= 0) {
                return false;
            }
            Platform.openGUI(player, this.tile, this.side, GuiBridge.GUI_RENAMER);
            return true;
        }
        return false;
    }

    @Override
    public final boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (this.useMemoryCard(player) || this.useRenamer(player)) {
            return true;
        }
        return this.onPartActivate(player, hand, pos);
    }

    @Override
    public final boolean onShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartShiftActivate(player, hand, pos);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        return false;
    }

    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        return false;
    }

    @Override
    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack held, AEPartLocation side) {
        this.proxy.setOwner(player);
    }

    @Override
    public boolean canBePlacedOn(BusSupport what) {
        return what == BusSupport.CABLE;
    }

    @Override
    public boolean requireDynamicRender() {
        return false;
    }

    public AEPartLocation getSide() {
        return this.side;
    }

    private void setSide(AEPartLocation side) {
        this.side = side;
    }

    public ItemStack getItemStack() {
        return this.is;
    }
}

