/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.integration.modules.jei.CondenserOutputWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class CondenserCategory
implements IRecipeCategory<CondenserOutputWrapper> {
    public static final String UID = "appliedenergistics2.condenser";
    private final String localizedName = I18n.func_135052_a((String)"gui.appliedenergistics2.Condenser", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable iconTrash;
    private final IDrawableAnimated progress;
    private final IDrawable iconButton;

    public CondenserCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("appliedenergistics2", "textures/guis/condenser.png");
        this.background = guiHelper.createDrawable(location, 50, 25, 94, 48);
        ResourceLocation statesLocation = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
        this.iconTrash = guiHelper.createDrawable(statesLocation, 241, 81, 14, 14, 28, 0, 2, 0);
        this.iconButton = guiHelper.createDrawable(statesLocation, 240, 240, 16, 16, 28, 0, 78, 0);
        IDrawableStatic progressDrawable = guiHelper.createDrawable(location, 178, 25, 6, 18, 0, 0, 70, 0);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "AE2 UEL: Extended";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progress.draw(minecraft);
        this.iconTrash.draw(minecraft);
        this.iconButton.draw(minecraft);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CondenserOutputWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 54, 26);
        itemStacks.init(1, true, 50, 0);
        itemStacks.set(1, this.getViableStorageComponents(recipeWrapper));
        itemStacks.set(ingredients);
    }

    private List<ItemStack> getViableStorageComponents(CondenserOutputWrapper recipeWrapper) {
        CondenserOutput condenserOutput = recipeWrapper.getCondenserOutput();
        IMaterials materials = AEApi.instance().definitions().materials();
        ArrayList<ItemStack> viableComponents = new ArrayList<ItemStack>();
        materials.cell1kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell4kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell16kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell64kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<ItemStack> viableComponents, ItemStack itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.func_77973_b();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(itemStack);
        }
    }
}

