/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.implementations.tiles.IImprovedMAC;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.localization.GuiText;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.ItemStackHelper;
import appeng.helpers.MultiCraftingTracker;
import appeng.helpers.NonBlockingItems;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEMonitorIInventory;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.AppEngInternalOversizedInventory;
import appeng.tile.networking.TileCableBus;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.BlockingInventoryAdaptor;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class DualityInterface
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IAEAppEngInventory,
IConfigManagerHost,
ICraftingProvider,
IUpgradeableHost {
    public static final int NUMBER_OF_STORAGE_SLOTS = 9;
    public static final int NUMBER_OF_STORAGE_SLOTSIMP = 18;
    public static final int NUMBER_OF_CONFIG_SLOTS = 9;
    public static final int NUMBER_OF_CONFIG_SLOTSIMP = 18;
    public static final int NUMBER_OF_CONFIG_SLOTSADV = 27;
    public static final int NUMBER_OF_CONFIG_SLOTSPER = 36;
    public static final int NUMBER_OF_PATTERN_SLOTS = 36;
    public static final int NUMBER_OF_PATTERN_SLOTS2 = 72;
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);
    private final IAEItemStack[] requireWork = new IAEItemStack[]{null, null, null, null, null, null, null, null, null};
    private final MultiCraftingTracker craftingTracker;
    private final AENetworkProxy gridProxy;
    private final IInterfaceHost iHost;
    private final IActionSource mySource;
    private final IActionSource interfaceRequestSource;
    private final ConfigManager cm = new ConfigManager(this);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9, 512);
    private final AppEngInternalInventory storage = new AppEngInternalOversizedInventory(this, 9, 512);
    private final AppEngInternalInventory patterns = new AppEngInternalInventory(this, 36, 1);
    private final MEMonitorPassThrough<IAEItemStack> items = new MEMonitorPassThrough(new NullInventory(), AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final MEMonitorPassThrough<IAEFluidStack> fluids = new MEMonitorPassThrough(new NullInventory(), AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    private final UpgradeInventory upgrades;
    private final Accessor accessor = new Accessor();
    private boolean hasConfig = false;
    private int priority;
    private List<ICraftingPatternDetails> craftingList = null;
    private List<ItemStack> waitingToSend = null;
    private IMEInventory<IAEItemStack> destination;
    private int isWorking = -1;
    private EnumSet<EnumFacing> visitedFaces = EnumSet.noneOf(EnumFacing.class);
    private EnumMap<EnumFacing, List<ItemStack>> waitingToSendFacing = new EnumMap(EnumFacing.class);
    private boolean resetConfigCache = true;
    private IMEMonitor<IAEItemStack> configCachedHandler;

    public DualityInterface(AENetworkProxy networkProxy, IInterfaceHost ih) {
        this.gridProxy = networkProxy;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.upgrades = new StackUpgradeInventory(this.gridProxy.getMachineRepresentation(), this, 4);
        this.cm.registerSetting(Settings.BLOCK, (Enum)YesNo.NO);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, (Enum)YesNo.YES);
        this.iHost = ih;
        this.craftingTracker = new MultiCraftingTracker(this.iHost, 9);
        MachineSource actionSource = new MachineSource(this.iHost);
        this.mySource = actionSource;
        this.fluids.setChangeSource(actionSource);
        this.items.setChangeSource(actionSource);
        this.interfaceRequestSource = new InterfaceRequestSource(this.iHost);
    }

    private static boolean invIsCustomBlocking(BlockingInventoryAdaptor inv) {
        return inv.containsBlockingItems();
    }

    @Override
    public void saveChanges() {
        this.iHost.saveChanges();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isWorking == slot) {
            return;
        }
        if (!(inv != this.config || removed.func_190926_b() && added.func_190926_b())) {
            boolean cfg = this.hasConfig();
            this.readConfig();
            if (cfg != this.hasConfig) {
                this.resetConfigCache = true;
                this.notifyNeighbors();
            }
        } else if (!(inv != this.patterns || removed.func_190926_b() && added.func_190926_b())) {
            this.updateCraftingList();
        } else if (inv == this.storage && slot >= 0) {
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        this.config.writeToNBT(data, "config");
        this.patterns.writeToNBT(data, "patterns");
        this.storage.writeToNBT(data, "storage");
        this.upgrades.writeToNBT(data, "upgrades");
        this.cm.writeToNBT(data);
        this.craftingTracker.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        NBTTagList waitingToSend = new NBTTagList();
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound itemNBT = ItemStackHelper.stackToNBT(is);
                waitingToSend.func_74742_a((NBTBase)itemNBT);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
        NBTTagCompound sidedWaitList = new NBTTagCompound();
        if (this.waitingToSendFacing != null) {
            for (EnumFacing s : this.iHost.getTargets()) {
                NBTTagList waitingListSided = new NBTTagList();
                if (!this.waitingToSendFacing.containsKey(s)) continue;
                for (ItemStack is : this.waitingToSendFacing.get(s)) {
                    NBTTagCompound itemNBT = ItemStackHelper.stackToNBT(is);
                    waitingListSided.func_74742_a((NBTBase)itemNBT);
                }
                sidedWaitList.func_74782_a(s.name(), (NBTBase)waitingListSided);
            }
        }
        data.func_74782_a("sidedWaitList", (NBTBase)sidedWaitList);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.waitingToSend = null;
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        if (waitingList != null) {
            for (int x = 0; x < waitingList.func_74745_c(); ++x) {
                NBTTagCompound c = waitingList.func_150305_b(x);
                if (c == null) continue;
                ItemStack is = ItemStackHelper.stackFromNBT(c);
                this.addToSendList(is);
            }
        }
        this.waitingToSendFacing = null;
        NBTTagCompound waitingListSided = data.func_74775_l("sidedWaitList");
        for (NBTTagCompound s : EnumFacing.values()) {
            if (!waitingListSided.func_74764_b(s.name())) continue;
            NBTTagList w = waitingListSided.func_150295_c(s.name(), 10);
            for (int x = 0; x < w.func_74745_c(); ++x) {
                NBTTagCompound c = w.func_150305_b(x);
                if (c == null) continue;
                ItemStack is = ItemStackHelper.stackFromNBT(c);
                this.addToSendListFacing(is, EnumFacing.func_82600_a((int)s.func_176745_a()));
            }
        }
        this.craftingTracker.readFromNBT(data);
        NBTTagCompound up = data.func_74775_l("upgrades");
        if (up.func_74764_b("Size") && up.func_74762_e("Size") != this.upgrades.getSlots()) {
            up.func_74768_a("Size", this.upgrades.getSlots());
            this.upgrades.writeToNBT(up, "upgrades");
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.config.readFromNBT(data, "config");
        NBTTagCompound pa = data.func_74775_l("patterns");
        if (pa.func_74764_b("Size") && pa.func_74762_e("Size") != this.patterns.getSlots()) {
            pa.func_74768_a("Size", this.patterns.getSlots());
            this.upgrades.writeToNBT(pa, "patterns");
        }
        this.patterns.readFromNBT(data, "patterns");
        this.storage.readFromNBT(data, "storage");
        this.priority = data.func_74762_e("priority");
        this.cm.readFromNBT(data);
        this.readConfig();
        this.updateCraftingList();
    }

    private void addToSendList(ItemStack is) {
        if (is.func_190926_b()) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new ArrayList<ItemStack>();
        }
        this.waitingToSend.add(is);
        try {
            this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void addToSendListFacing(ItemStack is, EnumFacing f) {
        if (is.func_190926_b()) {
            return;
        }
        if (this.waitingToSendFacing == null) {
            this.waitingToSendFacing = new EnumMap(EnumFacing.class);
        }
        this.waitingToSendFacing.computeIfAbsent(f, k -> new ArrayList());
        this.waitingToSendFacing.get(f).add(is);
        try {
            this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void readConfig() {
        this.hasConfig = false;
        for (ItemStack p : this.config) {
            if (p.func_190926_b()) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 9; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeighbors();
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.patterns.getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (!this.gridProxy.isReady()) {
            return;
        }
        boolean removed = false;
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                removed = true;
                i.remove();
            }
        }
        boolean newPattern = false;
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            newPattern = true;
            this.addToCraftingList(this.patterns.getStackInSlot(x));
        }
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean hasWorkToDo() {
        if (this.hasItemsToSend()) {
            return true;
        }
        if (this.hasItemsToSendFacing()) {
            return true;
        }
        for (IAEItemStack requiredWork : this.requireWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan(int slot) {
        IAEItemStack req = this.config.getAEStackInSlot(slot);
        if (req != null && req.getStackSize() <= 0L) {
            this.config.setStackInSlot(slot, ItemStack.field_190927_a);
            req = null;
        }
        ItemStack stored = this.storage.getStackInSlot(slot);
        if (req == null && !stored.func_190926_b()) {
            IAEItemStack work = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stored);
            this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            if (stored.func_190926_b()) {
                this.requireWork[slot] = req.copy();
                return;
            }
            if (req.isSameType(stored)) {
                if (req.getStackSize() == (long)stored.func_190916_E()) {
                    this.requireWork[slot] = null;
                } else {
                    this.requireWork[slot] = req.copy();
                    this.requireWork[slot].setStackSize(req.getStackSize() - (long)stored.func_190916_E());
                }
                return;
            }
            IAEItemStack work = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stored);
            this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
            return;
        }
        this.requireWork[slot] = null;
    }

    public void notifyNeighbors() {
        TileEntity te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getTileEntity()) != null && te.func_145831_w() != null) {
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.func_174877_v());
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)item).getPatternForItem(is, this.iHost.getTileEntity().func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    private boolean hasItemsToSend() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    private boolean hasItemsToSendFacing() {
        if (this.waitingToSendFacing != null) {
            for (EnumFacing enumFacing : this.waitingToSendFacing.keySet()) {
                if (this.waitingToSendFacing.get(enumFacing).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void dropExcessPatterns() {
        IItemHandler patterns = this.getPatterns();
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (int invSlot = 0; invSlot < patterns.getSlots(); ++invSlot) {
            ItemStack is;
            if (invSlot <= 8 + this.getInstalledUpgrades(Upgrades.PATTERN_EXPANSION) * 9 || (is = patterns.getStackInSlot(invSlot)).func_190926_b()) continue;
            dropList.add(patterns.extractItem(invSlot, Integer.MAX_VALUE, false));
        }
        if (dropList.size() > 0) {
            World world = this.getLocation().getWorld();
            BlockPos blockPos = this.getLocation().getPos();
            Platform.spawnDrops(world, blockPos, dropList);
        }
        this.gridProxy.setIdlePowerUsage(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.PATTERN_EXPANSION)));
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        IAEItemStack out = this.destination.injectItems((IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stack), Actionable.SIMULATE, null);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.func_190916_E();
    }

    public IItemHandler getConfig() {
        return this.config;
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    public void gridChanged() {
        try {
            this.items.setInternal(this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            this.fluids.setInternal(this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)));
        }
        catch (GridAccessException gae) {
            this.items.setInternal(new NullInventory());
            this.fluids.setInternal(new NullInventory());
        }
        this.notifyNeighbors();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getTileEntity());
    }

    public IItemHandler getInternalInventory() {
        return this.storage;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemsToSend()) {
            this.pushItemsOut(this.iHost.getTargets());
        }
        if (this.hasItemsToSendFacing()) {
            for (EnumFacing enumFacing : this.waitingToSendFacing.keySet()) {
                this.pushItemsOut(enumFacing);
            }
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    private void pushItemsOut(EnumSet<EnumFacing> possibleDirections) {
        if (!this.hasItemsToSend()) {
            return;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        Iterator<ItemStack> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            for (EnumFacing s : possibleDirections) {
                InventoryAdaptor ad;
                TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
                if (te == null || (ad = InventoryAdaptor.getAdaptor(te, s.func_176734_d())) == null) continue;
                ItemStack result = ad.addItems(whatToSend);
                if (result.func_190926_b()) {
                    whatToSend = ItemStack.field_190927_a;
                } else {
                    whatToSend.func_190920_e(result.func_190916_E());
                    whatToSend.func_77982_d(result.func_77978_p());
                }
                if (!whatToSend.func_190926_b()) continue;
                break;
            }
            if (!whatToSend.func_190926_b()) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    private void pushItemsOut(EnumFacing s) {
        if (!this.waitingToSendFacing.containsKey(s) || this.waitingToSendFacing.containsKey(s) && this.waitingToSendFacing.get(s).isEmpty()) {
            return;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
        if (te == null) {
            return;
        }
        if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
            block13: {
                try {
                    IInterfaceHost targetTE = te instanceof IInterfaceHost ? (IInterfaceHost)te : (IInterfaceHost)((Object)((TileCableBus)te).getPart(s.func_176734_d()));
                    if (!targetTE.getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                        IMEMonitor<IAEItemStack> inv;
                        IStorageMonitorable sm;
                        IStorageMonitorableAccessor mon = (IStorageMonitorableAccessor)te.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d());
                        if (mon != null && (sm = mon.getInventory(this.mySource)) != null && Platform.canAccess(targetTE.getInterfaceDuality().gridProxy, this.mySource) && (inv = sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))) != null) {
                            Iterator<ItemStack> i = this.waitingToSendFacing.get(s).iterator();
                            while (i.hasNext()) {
                                ItemStack whatToSend = i.next();
                                IAEItemStack result = inv.injectItems(AEItemStack.fromItemStack(whatToSend), Actionable.MODULATE, this.mySource);
                                if (result != null) {
                                    whatToSend.func_190920_e((int)result.getStackSize());
                                    whatToSend.func_77982_d(result.getDefinition().func_77978_p());
                                    continue;
                                }
                                i.remove();
                            }
                            if (this.waitingToSendFacing.get(s).isEmpty()) {
                                this.waitingToSendFacing.remove(s);
                            }
                        }
                        break block13;
                    }
                    return;
                }
                catch (GridAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.func_176734_d());
        Iterator<ItemStack> i = this.waitingToSendFacing.get(s).iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            if (ad == null) continue;
            ItemStack result = ad.addItems(whatToSend);
            if (!result.func_190926_b()) {
                whatToSend.func_190920_e(result.func_190916_E());
                whatToSend.func_77982_d(result.func_77978_p());
                continue;
            }
            i.remove();
        }
        if (this.waitingToSendFacing.get(s).isEmpty()) {
            this.waitingToSendFacing.remove(s);
        }
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 9; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x, this.requireWork[x]) || didSomething;
        }
        return didSomething;
    }

    private boolean usePlan(int x, IAEItemStack itemStack) {
        InventoryAdaptor adaptor = this.getAdaptor(x);
        this.isWorking = x;
        boolean changed = false;
        try {
            this.destination = this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (itemStack.getStackSize() < 0L) {
                IAEItemStack toStore = itemStack.copy();
                toStore.setStackSize(-toStore.getStackSize());
                long diff = toStore.getStackSize();
                ItemStack canExtract = adaptor.simulateRemove((int)diff, toStore.getDefinition(), null);
                if (canExtract.func_190926_b()) {
                    changed = true;
                    throw new GridAccessException();
                }
                if ((toStore = Platform.poweredInsert(src, this.destination, toStore, this.interfaceRequestSource)) != null) {
                    diff -= toStore.getStackSize();
                }
                if (diff != 0L) {
                    changed = true;
                    ItemStack removed = adaptor.removeItems((int)diff, ItemStack.field_190927_a, null);
                    if (removed.func_190926_b()) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                    }
                }
            }
            if (this.craftingTracker.isBusy(x)) {
                changed = this.handleCrafting(x, adaptor, itemStack) || changed;
            } else if (itemStack.getStackSize() > 0L) {
                ItemStack inputStack = itemStack.getCachedItemStack(itemStack.getStackSize());
                ItemStack remaining = adaptor.simulateAdd(inputStack);
                if (!remaining.func_190926_b()) {
                    itemStack.setCachedItemStack(remaining);
                    changed = true;
                    throw new GridAccessException();
                }
                IAEItemStack storedStack = this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList().findPrecise(itemStack);
                if (storedStack != null) {
                    IAEItemStack acquired = Platform.poweredExtraction(src, this.destination, itemStack, this.interfaceRequestSource);
                    if (acquired != null) {
                        changed = true;
                        inputStack.func_190920_e(Ints.saturatedCast((long)acquired.getStackSize()));
                        ItemStack issue = adaptor.addItems(inputStack);
                        if (!issue.func_190926_b()) {
                            throw new IllegalStateException("bad attempt at managing inventory. ( addItems )");
                        }
                    } else if (storedStack.isCraftable()) {
                        itemStack.setCachedItemStack(inputStack);
                        boolean bl = changed = this.handleCrafting(x, adaptor, itemStack) || changed;
                    }
                    if (acquired == null) {
                        itemStack.setCachedItemStack(inputStack);
                    }
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(x);
        }
        this.isWorking = -1;
        return changed;
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorItemHandler((IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.storage, slot, slot + 1));
    }

    private boolean handleCrafting(int x, InventoryAdaptor d, IAEItemStack itemStack) {
        try {
            if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && itemStack != null) {
                return this.craftingTracker.handleCrafting(x, itemStack.getStackSize(), itemStack, d, this.iHost.getTileEntity().func_145831_w(), this.gridProxy.getGrid(), this.gridProxy.getCrafting(), this.mySource);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public TileEntity getTile() {
        return (TileEntity)(this.iHost instanceof TileEntity ? this.iHost : null);
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            if (this.hasConfig()) {
                if (this.resetConfigCache) {
                    this.resetConfigCache = false;
                    this.configCachedHandler = new InterfaceInventory(this);
                }
                return this.configCachedHandler;
            }
            return this.items;
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            if (this.hasConfig()) {
                return null;
            }
            return this.fluids;
        }
        return null;
    }

    private boolean hasConfig() {
        return this.hasConfig;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("storage")) {
            return this.storage;
        }
        if (name.equals("patterns")) {
            return this.patterns;
        }
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public IItemHandler getStorage() {
        return this.storage;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) == 0) {
            this.cancelCrafting();
        }
        this.iHost.saveChanges();
    }

    private void cancelCrafting() {
        this.craftingTracker.cancel();
    }

    public IStorageMonitorable getMonitorable(IActionSource src, IStorageMonitorable myInterface) {
        if (Platform.canAccess(this.gridProxy, src)) {
            return myInterface;
        }
        final DualityInterface di = this;
        return new IStorageMonitorable(){

            @Override
            public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
                if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                    return new InterfaceInventory(di);
                }
                return null;
            }
        };
    }

    private boolean invIsBlocked(InventoryAdaptor inv) {
        return inv.containsItems();
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hasItemsToSend() || this.hasItemsToSendFacing() || !this.gridProxy.isActive() || !this.craftingList.contains(patternDetails)) {
            return false;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        if (this.visitedFaces.isEmpty()) {
            this.visitedFaces = this.iHost.getTargets();
        }
        for (EnumFacing s : this.visitedFaces) {
            InventoryAdaptor ad;
            IImprovedMAC impMac;
            TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
            if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
                this.visitedFaces.remove(s);
                try {
                    ItemStack is;
                    int x;
                    IStorageMonitorable sm;
                    IStorageMonitorableAccessor mon;
                    IInterfaceHost targetTE = te instanceof IInterfaceHost ? (IInterfaceHost)te : (IInterfaceHost)((Object)((TileCableBus)te).getPart(s.func_176734_d()));
                    if (targetTE.getInterfaceDualityPer().sameGrid(this.gridProxy.getGrid()) || targetTE.getInterfaceDualityImp().sameGrid(this.gridProxy.getGrid()) || targetTE.getInterfaceDualityAdv().sameGrid(this.gridProxy.getGrid()) || targetTE.getInterfaceDualityPer().sameGrid(this.gridProxy.getGrid()) || targetTE.getInterfaceDualityPatt().sameGrid(this.gridProxy.getGrid()) || targetTE.getInterfaceDuality().sameGrid(this.gridProxy.getGrid()) || (mon = (IStorageMonitorableAccessor)te.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d())) == null || (sm = mon.getInventory(this.mySource)) == null || !Platform.canAccess(targetTE.getInterfaceDuality().gridProxy, this.mySource) || this.isBlocking() && sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList().size() > 0) continue;
                    IMEMonitor<IAEItemStack> inv = sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    for (x = 0; x < table.func_70302_i_(); ++x) {
                        IAEItemStack result;
                        is = table.func_70301_a(x);
                        if (is.func_190926_b() || (result = inv.injectItems(AEItemStack.fromItemStack(is), Actionable.SIMULATE, this.mySource)) == null) continue;
                        return false;
                    }
                    for (x = 0; x < table.func_70302_i_(); ++x) {
                        is = table.func_70301_a(x);
                        if (is.func_190926_b()) continue;
                        this.addToSendListFacing(is, s);
                    }
                    this.pushItemsOut(s);
                    return true;
                }
                catch (GridAccessException e) {
                    continue;
                }
            }
            if (te instanceof ICraftingMachine) {
                ICraftingMachine cm = (ICraftingMachine)te;
                if (cm.acceptsPlans()) {
                    this.visitedFaces.remove(s);
                    if (!cm.pushPattern(patternDetails, table, s.func_176734_d())) continue;
                    return true;
                }
            } else if (te instanceof IImprovedMAC && (impMac = (IImprovedMAC)te).acceptsPlans()) {
                this.visitedFaces.remove(s);
                if (!impMac.pushPattern(patternDetails, table, s.func_176734_d())) continue;
                return true;
            }
            if ((ad = InventoryAdaptor.getAdaptor(te, s.func_176734_d())) != null) {
                if (this.isBlocking()) {
                    if (Loader.isModLoaded((String)"actuallyadditions") && te instanceof IPhantomTile) {
                        IPhantomTile phantomTE = (IPhantomTile)te;
                        if (phantomTE.hasBoundPosition()) {
                            TileEntity phantom = w.func_175625_s(phantomTE.getBoundPosition());
                            if (NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(phantomTE.getBoundPosition()).func_177230_c().getRegistryName().func_110624_b()) && this.isCustomInvBlocking(phantom, s)) {
                                this.visitedFaces.remove(s);
                                continue;
                            }
                        }
                    } else if (NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(tile.func_174877_v().func_177972_a(s)).func_177230_c().getRegistryName().func_110624_b())) {
                        if (this.isCustomInvBlocking(te, s)) {
                            this.visitedFaces.remove(s);
                            continue;
                        }
                    } else if (this.invIsBlocked(ad)) {
                        this.visitedFaces.remove(s);
                        continue;
                    }
                }
                if (this.acceptsItems(ad, table)) {
                    this.visitedFaces.remove(s);
                    for (int x = 0; x < table.func_70302_i_(); ++x) {
                        ItemStack is = table.func_70301_a(x);
                        if (is.func_190926_b()) continue;
                        this.addToSendListFacing(is, s);
                    }
                    this.pushItemsOut(s);
                    return true;
                }
            }
            this.visitedFaces.remove(s);
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        boolean busy = false;
        if (this.hasItemsToSend() || this.hasItemsToSendFacing()) {
            return true;
        }
        if (this.isBlocking()) {
            EnumSet<EnumFacing> possibleDirections = this.iHost.getTargets();
            TileEntity tile = this.iHost.getTileEntity();
            World w = tile.func_145831_w();
            boolean allAreBusy = true;
            for (EnumFacing s : possibleDirections) {
                TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
                if (te instanceof IInterfaceHost || te instanceof TileCableBus && ((TileCableBus)te).getPart(s.func_176734_d()) instanceof PartInterface) {
                    try {
                        IStorageMonitorable sm;
                        IStorageMonitorableAccessor mon;
                        IInterfaceHost targetTE = te instanceof IInterfaceHost ? (IInterfaceHost)te : (IInterfaceHost)((Object)((TileCableBus)te).getPart(s.func_176734_d()));
                        if (targetTE.getInterfaceDuality().sameGrid(this.gridProxy.getGrid()) || (mon = (IStorageMonitorableAccessor)te.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d())) == null || (sm = mon.getInventory(this.mySource)) == null || !Platform.canAccess(targetTE.getInterfaceDuality().gridProxy, this.mySource) || !sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList().isEmpty()) continue;
                        allAreBusy = false;
                        break;
                    }
                    catch (GridAccessException e) {
                        continue;
                    }
                }
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.func_176734_d());
                if (ad == null) continue;
                if (Loader.isModLoaded((String)"actuallyadditions") && Platform.GTLoaded && te instanceof IPhantomTile) {
                    IPhantomTile phantomTE = (IPhantomTile)te;
                    if (!phantomTE.hasBoundPosition()) continue;
                    TileEntity phantom = w.func_175625_s(phantomTE.getBoundPosition());
                    if (!NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(phantomTE.getBoundPosition()).func_177230_c().getRegistryName().func_110624_b()) || this.isCustomInvBlocking(phantom, s)) continue;
                    allAreBusy = false;
                    break;
                }
                if (NonBlockingItems.INSTANCE.getMap().containsKey(w.func_180495_p(tile.func_174877_v().func_177972_a(s)).func_177230_c().getRegistryName().func_110624_b())) {
                    if (this.isCustomInvBlocking(te, s)) continue;
                    allAreBusy = false;
                    break;
                }
                if (this.invIsBlocked(ad)) continue;
                allAreBusy = false;
                break;
            }
            busy = allAreBusy;
        }
        return busy;
    }

    boolean isCustomInvBlocking(TileEntity te, EnumFacing s) {
        BlockingInventoryAdaptor blockingInventoryAdaptor = BlockingInventoryAdaptor.getAdaptor(te, s.func_176734_d());
        return DualityInterface.invIsCustomBlocking(blockingInventoryAdaptor);
    }

    public boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    private boolean isBlocking() {
        return this.cm.getSetting(Settings.BLOCK) == YesNo.YES;
    }

    private boolean acceptsItems(InventoryAdaptor ad, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is.func_190926_b() || ad.simulateAdd(is).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.gridProxy.isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption(this, details);
            }
        }
    }

    public void addDrops(List<ItemStack> drops) {
        if (this.waitingToSend != null) {
            for (ItemStack itemStack : this.waitingToSend) {
                if (itemStack.func_190926_b()) continue;
                drops.add(itemStack);
            }
        }
        if (this.waitingToSendFacing != null) {
            for (List list : this.waitingToSendFacing.values()) {
                for (ItemStack is : list) {
                    if (is.func_190926_b()) continue;
                    drops.add(is);
                }
            }
        }
        for (ItemStack itemStack : this.upgrades) {
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        for (ItemStack itemStack : this.storage) {
            if (itemStack.func_190926_b()) continue;
            int maxStackSize = itemStack.func_77976_d();
            while (itemStack.func_190916_E() > maxStackSize) {
                ItemStack portionedStack = itemStack.func_77946_l();
                portionedStack.func_190920_e(maxStackSize);
                itemStack.func_190918_g(maxStackSize);
                drops.add(portionedStack);
            }
            drops.add(itemStack);
        }
        for (ItemStack itemStack : this.patterns) {
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
    }

    public IUpgradeableHost getHost() {
        if (this.getPart() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)((Object)this.getPart());
        }
        if (this.getTile() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)this.getTile();
        }
        return null;
    }

    private IPart getPart() {
        return (IPart)((Object)(this.iHost instanceof IPart ? this.iHost : null));
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack acquired, Actionable mode) {
        int slot = this.craftingTracker.getSlot(link);
        if (acquired != null && slot >= 0 && slot <= this.requireWork.length) {
            InventoryAdaptor adaptor = this.getAdaptor(slot);
            if (mode == Actionable.SIMULATE) {
                return AEItemStack.fromItemStack(adaptor.simulateAdd(acquired.createItemStack()));
            }
            AEItemStack is = AEItemStack.fromItemStack(adaptor.addItems(acquired.createItemStack()));
            this.updatePlan(slot);
            return is;
        }
        return acquired;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    public String getTermName() {
        TileEntity hostTile = this.iHost.getTileEntity();
        World hostWorld = hostTile.func_145831_w();
        if (((ICustomNameObject)((Object)this.iHost)).hasCustomInventoryName()) {
            return ((ICustomNameObject)((Object)this.iHost)).getCustomInventoryName();
        }
        EnumSet<EnumFacing> possibleDirections = this.iHost.getTargets();
        for (EnumFacing direction : possibleDirections) {
            MetaTileEntity metaTileEntity;
            BlockPos targ = hostTile.func_174877_v().func_177972_a(direction);
            TileEntity directedTile = hostWorld.func_175625_s(targ);
            if (directedTile == null) continue;
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(directedTile, direction.func_176734_d());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || adaptor != null && !adaptor.hasSlots()) continue;
            IBlockState directedBlockState = hostWorld.func_180495_p(targ);
            Block directedBlock = directedBlockState.func_177230_c();
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
            if (Platform.GTLoaded && directedBlock instanceof BlockMachine && (metaTileEntity = Platform.getMetaTileEntity((IBlockAccess)directedTile.func_145831_w(), directedTile.func_174877_v())) != null) {
                return metaTileEntity.getMetaFullName();
            }
            try {
                ItemStack g;
                Vec3d from = new Vec3d((double)hostTile.func_174877_v().func_177958_n() + 0.5, (double)hostTile.func_174877_v().func_177956_o() + 0.5, (double)hostTile.func_174877_v().func_177952_p() + 0.5);
                from = from.func_72441_c((double)direction.func_82601_c() * 0.501, (double)direction.func_96559_d() * 0.501, (double)direction.func_82599_e() * 0.501);
                Vec3d to = from.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                RayTraceResult mop = hostWorld.func_72901_a(from, to, true);
                if (mop != null && !BAD_BLOCKS.contains(directedBlock) && mop.func_178782_a().equals((Object)directedTile.func_174877_v()) && !(g = directedBlock.getPickBlock(directedBlockState, mop, hostWorld, directedTile.func_174877_v(), null)).func_190926_b()) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.func_77973_b() != Items.field_190931_a) {
                return what.func_77973_b().func_77653_i(what);
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != Items.field_190931_a) continue;
            return directedBlock.func_149739_a();
        }
        return GuiText.Nothing.getLocal();
    }

    public long getSortValue() {
        TileEntity te = this.iHost.getTileEntity();
        return (long)te.func_174877_v().func_177952_p() << 24 ^ (long)te.func_174877_v().func_177958_n() << 8 ^ (long)te.func_174877_v().func_177956_o();
    }

    public void initialize() {
        this.updateCraftingList();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.iHost.saveChanges();
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean hasCapability(Capability<?> capabilityClass, EnumFacing facing) {
        return capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capabilityClass == Capabilities.STORAGE_MONITORABLE_ACCESSOR;
    }

    public <T> T getCapability(Capability<T> capabilityClass, EnumFacing facing) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.storage;
        }
        if (capabilityClass == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)this.accessor;
        }
        return null;
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            return DualityInterface.this.getMonitorable(src, DualityInterface.this);
        }
    }

    private class InterfaceRequestSource
    extends MachineSource {
        private final InterfaceRequestContext context;

        public InterfaceRequestSource(IActionHost v) {
            super(v);
            this.context = new InterfaceRequestContext();
        }

        @Override
        public <T> Optional<T> context(Class<T> key) {
            if (key == InterfaceRequestContext.class) {
                return Optional.of(this.context);
            }
            return super.context(key);
        }
    }

    private class InterfaceInventory
    extends MEMonitorIInventory {
        public InterfaceInventory(DualityInterface tileInterface) {
            super(new AdaptorItemHandler((IItemHandler)tileInterface.storage));
        }

        @Override
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean isInterface = context.isPresent();
            if (isInterface) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEItemStack extractItems(IAEItemStack request, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean hasLowerOrEqualPriority = context.map(c -> c.compareTo(DualityInterface.this.priority) <= 0).orElse(false);
            if (hasLowerOrEqualPriority) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }

    private class InterfaceRequestContext
    implements Comparable<Integer> {
        private InterfaceRequestContext() {
        }

        @Override
        public int compareTo(Integer o) {
            return Integer.compare(DualityInterface.this.priority, o);
        }
    }
}

