/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.helper;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.settings.TickRates;
import appeng.fluids.helper.IConfigurableFluidInventory;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.ICustomNameObject;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEMonitorIFluidHandler;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class DualityFluidInterface
implements IGridTickable,
IStorageMonitorable,
IAEFluidInventory,
IAEAppEngInventory,
IUpgradeableHost,
IConfigManagerHost,
IConfigurableFluidInventory {
    public static final int NUMBER_OF_TANKS = 9;
    public static final int TANK_CAPACITY = 8000;
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);
    private final ConfigManager cm = new ConfigManager(this);
    private final AENetworkProxy gridProxy;
    private final IFluidInterfaceHost iHost;
    private final IActionSource mySource;
    private final IActionSource interfaceRequestSource;
    private final UpgradeInventory upgrades;
    private boolean hasConfig = false;
    private final IStorageMonitorableAccessor accessor = this::getMonitorable;
    private final AEFluidInventory tanks = new AEFluidInventory(this, 9, 8000);
    private final AEFluidInventory config = new AEFluidInventory(this, 9);
    private final IAEFluidStack[] requireWork;
    private int isWorking = -1;
    private int priority;
    private final MEMonitorPassThrough<IAEItemStack> items = new MEMonitorPassThrough(new NullInventory(), AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final MEMonitorPassThrough<IAEFluidStack> fluids = new MEMonitorPassThrough(new NullInventory(), AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    private boolean resetConfigCache = true;
    private IMEMonitor<IAEFluidStack> configCachedHandler;

    public DualityFluidInterface(AENetworkProxy networkProxy, IFluidInterfaceHost ih) {
        this.gridProxy = networkProxy;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.upgrades = new StackUpgradeInventory(this.gridProxy.getMachineRepresentation(), this, 2);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, (Enum)YesNo.YES);
        this.iHost = ih;
        this.mySource = new MachineSource(this.iHost);
        this.interfaceRequestSource = new InterfaceRequestSource(this.iHost);
        this.fluids.setChangeSource(this.mySource);
        this.items.setChangeSource(this.mySource);
        this.requireWork = new IAEFluidStack[9];
        for (int i = 0; i < 9; ++i) {
            this.requireWork[i] = null;
        }
    }

    public IUpgradeableHost getHost() {
        return this.iHost;
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            if (this.hasConfig()) {
                return null;
            }
            return this.items;
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            if (this.hasConfig()) {
                if (this.resetConfigCache) {
                    this.resetConfigCache = false;
                    this.configCachedHandler = new InterfaceInventory(this);
                }
                return this.configCachedHandler;
            }
            return this.fluids;
        }
        return null;
    }

    public IStorageMonitorable getMonitorable(IActionSource src) {
        if (Platform.canAccess(this.gridProxy, src)) {
            return this;
        }
        return null;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    public void notifyNeighbors() {
        TileEntity te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getTileEntity()) != null && te.func_145831_w() != null) {
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.func_174877_v());
        }
    }

    public void gridChanged() {
        try {
            this.items.setInternal(this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            this.fluids.setInternal(this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)));
        }
        catch (GridAccessException gae) {
            this.items.setInternal(new NullInventory());
            this.fluids.setInternal(new NullInventory());
        }
        this.notifyNeighbors();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getTileEntity());
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    public String getTermName() {
        TileEntity hostTile = this.iHost.getTileEntity();
        World hostWorld = hostTile.func_145831_w();
        if (((ICustomNameObject)((Object)this.iHost)).hasCustomInventoryName()) {
            return ((ICustomNameObject)((Object)this.iHost)).getCustomInventoryName();
        }
        EnumSet<EnumFacing> possibleDirections = this.iHost.getTargets();
        for (EnumFacing direction : possibleDirections) {
            MetaTileEntity metaTileEntity;
            BlockPos targ = hostTile.func_174877_v().func_177972_a(direction);
            TileEntity directedTile = hostWorld.func_175625_s(targ);
            if (directedTile == null) continue;
            if (directedTile instanceof IFluidInterfaceHost) {
                try {
                    if (((IFluidInterfaceHost)directedTile).getDualityFluidInterface().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(directedTile, direction.func_176734_d());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || adaptor != null && !adaptor.hasSlots()) continue;
            IBlockState directedBlockState = hostWorld.func_180495_p(targ);
            Block directedBlock = directedBlockState.func_177230_c();
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
            if (Platform.GTLoaded && directedBlock instanceof BlockMachine && (metaTileEntity = Platform.getMetaTileEntity((IBlockAccess)directedTile.func_145831_w(), directedTile.func_174877_v())) != null) {
                return metaTileEntity.getMetaFullName();
            }
            try {
                ItemStack g;
                Vec3d from = new Vec3d((double)hostTile.func_174877_v().func_177958_n() + 0.5, (double)hostTile.func_174877_v().func_177956_o() + 0.5, (double)hostTile.func_174877_v().func_177952_p() + 0.5);
                from = from.func_72441_c((double)direction.func_82601_c() * 0.501, (double)direction.func_96559_d() * 0.501, (double)direction.func_82599_e() * 0.501);
                Vec3d to = from.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                RayTraceResult mop = hostWorld.func_72901_a(from, to, true);
                if (mop != null && !BAD_BLOCKS.contains(directedBlock) && mop.func_178782_a().equals((Object)directedTile.func_174877_v()) && !(g = directedBlock.getPickBlock(directedBlockState, mop, hostWorld, directedTile.func_174877_v(), null)).func_190926_b()) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.func_77973_b() != Items.field_190931_a) {
                return what.func_77973_b().func_77653_i(what);
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != Items.field_190931_a) continue;
            return directedBlock.func_149739_a();
        }
        return "Nothing";
    }

    public long getSortValue() {
        TileEntity te = this.iHost.getTileEntity();
        return (long)te.func_174877_v().func_177952_p() << 24 ^ (long)te.func_174877_v().func_177958_n() << 8 ^ (long)te.func_174877_v().func_177956_o();
    }

    public boolean hasCapability(Capability<?> capabilityClass, EnumFacing facing) {
        return capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capabilityClass == Capabilities.STORAGE_MONITORABLE_ACCESSOR;
    }

    public <T> T getCapability(Capability<T> capabilityClass, EnumFacing facing) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tanks;
        }
        if (capabilityClass == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)this.accessor;
        }
        return null;
    }

    private boolean hasConfig() {
        return this.hasConfig;
    }

    private void readConfig() {
        this.hasConfig = false;
        for (int i = 0; i < this.config.getSlots(); ++i) {
            if (this.config.getFluidInSlot(i) == null) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 9; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeighbors();
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 9; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x) || didSomething;
        }
        return didSomething;
    }

    private boolean hasWorkToDo() {
        for (IAEFluidStack requiredWork : this.requireWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan(int slot) {
        IAEFluidStack req = this.config.getFluidInSlot(slot);
        IAEFluidStack stored = this.tanks.getFluidInSlot(slot);
        if (req == null && stored != null && stored.getStackSize() > 0L) {
            IAEFluidStack work = stored.copy();
            this.requireWork[slot] = (IAEFluidStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            int tankSize = (int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0);
            if (stored == null || stored.getStackSize() == 0L) {
                this.requireWork[slot] = req.copy();
                this.requireWork[slot].setStackSize(tankSize);
                return;
            }
            if (req.equals(stored)) {
                if (stored.getStackSize() != (long)tankSize) {
                    this.requireWork[slot] = req.copy();
                    this.requireWork[slot].setStackSize((long)tankSize - stored.getStackSize());
                    return;
                }
            } else {
                IAEFluidStack work = stored.copy();
                this.requireWork[slot] = (IAEFluidStack)work.setStackSize(-work.getStackSize());
                return;
            }
        }
        this.requireWork[slot] = null;
    }

    private boolean usePlan(int slot) {
        IAEFluidStack work = this.requireWork[slot];
        this.isWorking = slot;
        boolean changed = false;
        try {
            IMEMonitor<IAEFluidStack> dest = this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (work.getStackSize() > 0L) {
                IAEFluidStack acquired;
                if ((long)this.tanks.fill(slot, work.getFluidStack(), false) != work.getStackSize()) {
                    changed = true;
                } else if (this.gridProxy.getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)).getStorageList().findPrecise(work) != null && (acquired = Platform.poweredExtraction(src, dest, work, this.interfaceRequestSource)) != null) {
                    changed = true;
                    int filled = this.tanks.fill(slot, acquired.getFluidStack(), true);
                    if ((long)filled != acquired.getStackSize()) {
                        throw new IllegalStateException("bad attempt at managing tanks. ( fill )");
                    }
                }
            } else if (work.getStackSize() < 0L) {
                IAEFluidStack toStore = work.copy();
                toStore.setStackSize(-toStore.getStackSize());
                FluidStack canExtract = this.tanks.drain(slot, toStore.getFluidStack(), false);
                if (canExtract == null || (long)canExtract.amount != toStore.getStackSize()) {
                    changed = true;
                } else {
                    IAEFluidStack notStored = Platform.poweredInsert(src, dest, toStore, this.interfaceRequestSource);
                    toStore.setStackSize(toStore.getStackSize() - (notStored == null ? 0L : notStored.getStackSize()));
                    if (toStore.getStackSize() > 0L) {
                        changed = true;
                        FluidStack removed = this.tanks.drain(slot, toStore.getFluidStack(), true);
                        if (removed == null || toStore.getStackSize() != (long)removed.amount) {
                            throw new IllegalStateException("bad attempt at managing tanks. ( drain )");
                        }
                    }
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(slot);
        }
        this.isWorking = -1;
        return changed;
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inventory, int slot) {
        if (this.isWorking == slot) {
            return;
        }
        if (inventory == this.config) {
            boolean cfg = this.hasConfig();
            this.readConfig();
            if (cfg != this.hasConfig) {
                this.resetConfigCache = true;
                this.notifyNeighbors();
            }
        } else if (inventory == this.tanks) {
            this.saveChanges();
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("priority", this.priority);
        this.tanks.writeToNBT(data, "storage");
        this.config.writeToNBT(data, "config");
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void readFromNBT(NBTTagCompound data) {
        this.config.readFromNBT(data, "config");
        this.tanks.readFromNBT(data, "storage");
        this.priority = data.func_74762_e("priority");
        this.upgrades.readFromNBT(data, "upgrades");
        this.tanks.setCapacity((int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0));
        this.readConfig();
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    public IAEFluidTank getTanks() {
        return this.tanks;
    }

    @Override
    public void saveChanges() {
        this.iHost.saveChanges();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgrades) {
            this.tanks.setCapacity((int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 1000.0));
            try {
                this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            for (int x = 0; x < 9; ++x) {
                this.updatePlan(x);
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public IFluidHandler getFluidInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    public void addDrops(List<ItemStack> drops) {
        for (ItemStack is : this.upgrades) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public TileEntity getTile() {
        return (TileEntity)(this.iHost instanceof TileEntity ? this.iHost : null);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    private class InterfaceRequestSource
    extends MachineSource {
        private final InterfaceRequestContext context;

        InterfaceRequestSource(IActionHost v) {
            super(v);
            this.context = new InterfaceRequestContext();
        }

        @Override
        public <T> Optional<T> context(Class<T> key) {
            if (key == InterfaceRequestContext.class) {
                return Optional.of(this.context);
            }
            return super.context(key);
        }
    }

    private class InterfaceInventory
    extends MEMonitorIFluidHandler {
        InterfaceInventory(DualityFluidInterface tileInterface) {
            super(tileInterface.tanks);
        }

        @Override
        public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean isInterface = context.isPresent();
            if (isInterface) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean hasLowerOrEqualPriority = context.map(c -> c.compareTo(DualityFluidInterface.this.priority) <= 0).orElse(false);
            if (hasLowerOrEqualPriority) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }

    private class InterfaceRequestContext
    implements Comparable<Integer> {
        private InterfaceRequestContext() {
        }

        @Override
        public int compareTo(Integer o) {
            return Integer.compare(DualityFluidInterface.this.priority, o);
        }
    }
}

