/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.me.SlotDisconnected;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerInterfaceConfigurationTerminal;
import appeng.container.slot.IJEITargetSlot;
import appeng.container.slot.SlotFake;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketFluidSlot;
import appeng.fluids.client.gui.widgets.GuiFluidSlot;
import appeng.fluids.container.ContainerFluidConfigurable;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperRangeItemHandler;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class PacketInventoryAction
extends AppEngPacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public PacketInventoryAction(ByteBuf stream) throws IOException {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.fromPacket(stream) : null;
    }

    public PacketInventoryAction(InventoryAction action, int slot, IAEItemStack slotItem) throws IOException {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public PacketInventoryAction(InventoryAction action, IJEITargetSlot slot, IAEItemStack slotItem) throws IOException {
        this.action = action;
        if (slot instanceof SlotFake) {
            this.slot = ((SlotFake)slot).field_75222_d;
            this.id = 0L;
        } else if (slot instanceof SlotDisconnected) {
            this.slot = ((SlotDisconnected)slot).getSlotIndex();
            this.id = ((SlotDisconnected)slot).getSlot().getId();
        } else {
            this.slot = ((GuiFluidSlot)slot).getId();
            this.id = 0L;
        }
        this.slotItem = slotItem;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(this.slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public PacketInventoryAction(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container container = sender.field_71070_bA;
        if (container instanceof AEBaseContainer) {
            AEBaseContainer baseContainer = (AEBaseContainer)container;
            if (this.action == InventoryAction.AUTO_CRAFT) {
                ContainerOpenContext context = baseContainer.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    Platform.openGUI((EntityPlayer)sender, te, baseContainer.getOpenContext().getSide(), GuiBridge.GUI_CRAFTING_AMOUNT);
                    Container container2 = sender.field_71070_bA;
                    if (container2 instanceof ContainerCraftAmount) {
                        ContainerCraftAmount cca = (ContainerCraftAmount)container2;
                        if (baseContainer.getTargetStack() != null) {
                            cca.getCraftingItem().func_75215_d(baseContainer.getTargetStack().asItemStackRepresentation());
                            cca.setItemToCraft(baseContainer.getTargetStack());
                        }
                        cca.func_75142_b();
                    }
                }
            } else if (this.action == InventoryAction.PLACE_JEI_GHOST_ITEM) {
                Slot senderSlot;
                if (sender.field_71070_bA instanceof ContainerFluidConfigurable) {
                    IAEFluidStack aefs;
                    if (this.slotItem != null && (aefs = AEFluidStack.fromNBT(this.slotItem.getDefinition().func_77978_p())) != null) {
                        aefs.setStackSize(1000L);
                        ((ContainerFluidConfigurable)sender.field_71070_bA).getFluidConfigInventory().setFluidInSlot(this.slot, aefs);
                        NetworkHandler.instance().sendToServer(new PacketFluidSlot(Collections.singletonMap(this.slot, aefs)));
                    }
                } else if (sender.field_71070_bA instanceof ContainerInterfaceConfigurationTerminal) {
                    ContainerInterfaceConfigurationTerminal.ConfigTracker inv = ((ContainerInterfaceConfigurationTerminal)sender.field_71070_bA).getSlotByID(this.id);
                    WrapperRangeItemHandler theSlot = new WrapperRangeItemHandler(inv.getServer(), 0, this.slot + 1);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, this.slot, this.slotItem.createItemStack());
                } else if (this.slot < sender.field_71070_bA.field_75151_b.size() && (senderSlot = (Slot)sender.field_71070_bA.field_75151_b.get(this.slot)) instanceof SlotFake) {
                    if (this.slotItem != null) {
                        IAEFluidStack aefs;
                        senderSlot.func_75215_d(this.slotItem.createItemStack());
                        if (senderSlot.func_75211_c().func_190926_b() && (aefs = AEFluidStack.fromNBT(this.slotItem.getDefinition().func_77978_p())) != null) {
                            FluidStack fluid = aefs.getFluidStack();
                            senderSlot.func_75215_d(AEFluidStack.fromFluidStack(fluid).asItemStackRepresentation());
                        }
                    } else {
                        senderSlot.func_75215_d(ItemStack.field_190927_a);
                    }
                    try {
                        NetworkHandler.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.fromItemStack(ItemStack.field_190927_a)), sender);
                    }
                    catch (IOException e) {
                        AELog.debug(e);
                    }
                }
            } else {
                baseContainer.doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            if (this.slotItem == null) {
                AppEng.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(ItemStack.field_190927_a);
            } else {
                AppEng.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(this.slotItem.createItemStack());
            }
        }
    }
}

