/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.implementations.GuiFluidInterfaceConfigurationTerminal;
import appeng.client.gui.implementations.GuiInterfaceConfigurationTerminal;
import appeng.client.gui.implementations.GuiInterfaceConfigurationTerminalAdv;
import appeng.client.gui.implementations.GuiInterfaceConfigurationTerminalImp;
import appeng.client.gui.implementations.GuiInterfaceConfigurationTerminalPer;
import appeng.client.gui.implementations.GuiInterfaceTerminal;
import appeng.client.gui.implementations.GuiInterfaceTerminalAdv;
import appeng.client.gui.implementations.GuiInterfaceTerminalImp;
import appeng.client.gui.implementations.GuiInterfaceTerminalPatt;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCompressedNBT
extends AppEngPacket {
    private final NBTTagCompound in;
    private final ByteBuf data;
    private final GZIPOutputStream compressFrame;

    public PacketCompressedNBT(final ByteBuf stream) throws IOException {
        this.data = null;
        this.compressFrame = null;
        GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                if (stream.readableBytes() <= 0) {
                    return -1;
                }
                return stream.readByte() & 0xFF;
            }
        });
        DataInputStream inStream = new DataInputStream(gzReader);
        this.in = CompressedStreamTools.func_74794_a((DataInputStream)inStream);
        inStream.close();
    }

    public PacketCompressedNBT(NBTTagCompound din) throws IOException {
        this.data = Unpooled.buffer((int)2048);
        this.data.writeInt(this.getPacketID());
        this.in = din;
        this.compressFrame = new GZIPOutputStream(new OutputStream(){

            @Override
            public void write(int value) throws IOException {
                PacketCompressedNBT.this.data.writeByte(value);
            }
        });
        CompressedStreamTools.func_74800_a((NBTTagCompound)din, (DataOutput)new DataOutputStream(this.compressFrame));
        this.compressFrame.close();
        this.configureWrite(this.data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiInterfaceTerminal) {
            ((GuiInterfaceTerminal)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceTerminalImp) {
            ((GuiInterfaceTerminalImp)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceTerminalAdv) {
            ((GuiInterfaceTerminalAdv)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceTerminalPatt) {
            ((GuiInterfaceTerminalPatt)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceConfigurationTerminal) {
            ((GuiInterfaceConfigurationTerminal)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceConfigurationTerminalImp) {
            ((GuiInterfaceConfigurationTerminalImp)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceConfigurationTerminalAdv) {
            ((GuiInterfaceConfigurationTerminalAdv)gs).postUpdate(this.in);
        } else if (gs instanceof GuiInterfaceConfigurationTerminalPer) {
            ((GuiInterfaceConfigurationTerminalPer)gs).postUpdate(this.in);
        } else if (gs instanceof GuiFluidInterfaceConfigurationTerminal) {
            ((GuiFluidInterfaceConfigurationTerminal)gs).postUpdate(this.in);
        }
    }
}

