/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.container.slot.AppEngSlot;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class SlotRestrictedInput
extends AppEngSlot {
    private final PlacableItemType which;
    private final InventoryPlayer p;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public SlotRestrictedInput(PlacableItemType valid, IItemHandler i, int slotIndex, int x, int y, InventoryPlayer p) {
        super(i, slotIndex, x, y);
        this.which = valid;
        this.setIIcon(valid.IIcon);
        this.p = p;
    }

    public PlacableItemType getPlaceableItemType() {
        return this.which;
    }

    @Override
    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.func_75219_a();
    }

    public boolean isValid(ItemStack is, World theWorld) {
        if (this.which == PlacableItemType.VALID_ENCODED_PATTERN_W_OUTPUT) {
            ICraftingPatternDetails ap = is.func_77973_b() instanceof ICraftingPatternItem ? ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, theWorld) : null;
            return ap != null;
        }
        return true;
    }

    public Slot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    @Override
    public boolean func_75214_a(ItemStack i) {
        if (!this.getContainer().isValidForSlot(this, i)) {
            return false;
        }
        if (i.func_190926_b()) {
            return false;
        }
        if (i.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (!super.func_75214_a(i)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        IMaterials materials = definitions.materials();
        IItems items = definitions.items();
        switch (this.which) {
            case ENCODED_CRAFTING_PATTERN: {
                ICraftingPatternItem b;
                ICraftingPatternDetails de;
                Item item = i.func_77973_b();
                if (item instanceof ICraftingPatternItem && (de = (b = (ICraftingPatternItem)item).getPatternForItem(i, this.p.field_70458_d.field_70170_p)) != null) {
                    return de.isCraftable();
                }
                return false;
            }
            case VALID_ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                return i.func_77973_b() instanceof ICraftingPatternItem;
            }
            case BLANK_PATTERN: {
                return materials.blankPattern().isSameAs(i);
            }
            case PATTERN: {
                if (i.func_77973_b() instanceof ICraftingPatternItem) {
                    return true;
                }
                return materials.blankPattern().isSameAs(i);
            }
            case INSCRIBER_PLATE: {
                if (materials.namePress().isSameAs(i)) {
                    return true;
                }
                for (ItemStack optional : AEApi.instance().registries().inscriber().getOptionals()) {
                    if (!Platform.itemComparisons().isSameItem(i, optional)) continue;
                    return true;
                }
                return false;
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return SlotRestrictedInput.isMetalIngot(i);
            }
            case VIEW_CELL: {
                return items.viewCell().isSameAs(i);
            }
            case ORE: {
                return AEApi.instance().registries().grinder().getRecipeForInput(i) != null;
            }
            case FUEL: {
                return TileEntityFurnace.func_145952_a((ItemStack)i) > 0;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(i);
            }
            case QE_SINGULARITY: {
                return materials.qESingularity().isSameAs(i);
            }
            case RANGE_BOOSTER: {
                return materials.wirelessBooster().isSameAs(i);
            }
            case SPATIAL_STORAGE_CELLS: {
                return i.func_77973_b() instanceof ISpatialStorageCell && ((ISpatialStorageCell)i.func_77973_b()).isSpatialStorage(i);
            }
            case STORAGE_CELLS: {
                return AEApi.instance().registries().cell().isCellHandled(i);
            }
            case WORKBENCH_CELL: {
                return i.func_77973_b() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)i.func_77973_b()).isEditable(i);
            }
            case STORAGE_COMPONENT: {
                return i.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
            }
            case TRASH: {
                if (AEApi.instance().registries().cell().isCellHandled(i)) {
                    return false;
                }
                return !(i.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
            }
            case ENCODABLE_ITEM: {
                return i.func_77973_b() instanceof INetworkEncodable || AEApi.instance().registries().wireless().isWirelessTerminal(i);
            }
            case BIOMETRIC_CARD: {
                return i.func_77973_b() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return i.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)i.func_77973_b()).getType(i) != null;
            }
            case CARD_QUANTUM: {
                if (AEApi.instance().definitions().materials().cardQuantumLink().maybeItem().isPresent()) {
                    return AEApi.instance().definitions().materials().cardQuantumLink().maybeItem().get() == i.func_77973_b();
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return this.isAllowEdit();
    }

    @Override
    public ItemStack getDisplayStack() {
        ItemEncodedPattern iep;
        ItemStack out;
        Item item;
        ItemStack is;
        if (Platform.isClient() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.func_75211_c()).func_190926_b() && (item = is.func_77973_b()) instanceof ItemEncodedPattern && !(out = (iep = (ItemEncodedPattern)item).getOutput(is)).func_190926_b()) {
            return out;
        }
        return super.func_75211_c();
    }

    public static boolean isMetalIngot(ItemStack i) {
        if (Platform.itemComparisons().isSameItem(i, new ItemStack(Items.field_151042_j))) {
            return true;
        }
        for (String name : new String[]{"Copper", "Tin", "Obsidian", "Iron", "Lead", "Bronze", "Brass", "Nickel", "Aluminium"}) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                if (!Platform.itemComparisons().isSameItem(i, ingot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(15),
        ORE(31),
        STORAGE_COMPONENT(63),
        ENCODABLE_ITEM(79),
        TRASH(95),
        VALID_ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_CRAFTING_PATTERN(127),
        ENCODED_PATTERN(127),
        PATTERN(143),
        BLANK_PATTERN(143),
        POWERED_TOOL(159),
        RANGE_BOOSTER(111),
        QE_SINGULARITY(175),
        CARD_QUANTUM(223),
        SPATIAL_STORAGE_CELLS(191),
        FUEL(207),
        UPGRADES(223),
        WORKBENCH_CELL(15),
        BIOMETRIC_CARD(239),
        VIEW_CELL(78),
        INSCRIBER_PLATE(46),
        INSCRIBER_INPUT(62),
        METAL_INGOTS(62);

        public final int IIcon;

        private PlacableItemType(int o) {
            this.IIcon = o;
        }
    }
}

