/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.networking.crafting.ICraftingCPU;
import javax.annotation.Nonnull;

public class CraftingCPURecord
implements Comparable<CraftingCPURecord> {
    private final String myName;
    private final ICraftingCPU cpu;
    private final long size;
    private final long processors;

    public CraftingCPURecord(long size, long coProcessors, ICraftingCPU server) {
        this.size = size;
        this.processors = coProcessors;
        this.cpu = server;
        this.myName = server.getName();
    }

    @Override
    public int compareTo(@Nonnull CraftingCPURecord o) {
        int a = Long.compare(o.getProcessors(), this.getProcessors());
        if (a != 0) {
            return a;
        }
        return Long.compare(o.getSize(), this.getSize());
    }

    ICraftingCPU getCpu() {
        return this.cpu;
    }

    String getName() {
        return this.myName;
    }

    long getProcessors() {
        return this.processors;
    }

    long getSize() {
        return this.size;
    }
}

