/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterfaceAdv;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.helpers.ItemStackHelper;
import appeng.parts.misc.PartInterfaceAdv;
import appeng.parts.reporting.PartInterfaceConfigurationTerminalAdv;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterfaceAdv;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperRangeItemHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public final class ContainerInterfaceConfigurationTerminalAdv
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IInterfaceHost, ConfigTracker> diList = new HashMap<IInterfaceHost, ConfigTracker>();
    private final Map<Long, ConfigTracker> byId = new HashMap<Long, ConfigTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceConfigurationTerminalAdv(InventoryPlayer ip, PartInterfaceConfigurationTerminalAdv anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 14, 153);
    }

    @Override
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterfaceAdv dual;
            ConfigTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterfaceAdv.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDualityAdv().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDualityAdv();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartInterfaceAdv.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDualityAdv().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDualityAdv();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, ConfigTracker> en : this.diList.entrySet()) {
                ConfigTracker inv = en.getValue();
                for (int x = 0; x < inv.server.getSlots(); ++x) {
                    if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance().sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    public ConfigTracker getSlotByID(long id) {
        return this.byId.get(id);
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        ConfigTracker inv = this.byId.get(id);
        if (inv != null) {
            boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
            WrapperRangeItemHandler theSlot = new WrapperRangeItemHandler(inv.server, slot, slot + 1);
            ItemStack inSlot = theSlot.getStackInSlot(0);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, player.field_71071_by.func_70445_o().func_77946_l());
                        break;
                    }
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ItemStack.field_190927_a);
                    break;
                }
                case PLACE_SINGLE: {
                    if (inSlot.func_190916_E() >= inSlot.func_77976_d() * 8) break;
                    inSlot.func_190917_f(1);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot);
                    break;
                }
                case PICKUP_SINGLE: {
                    if (theSlot.getStackInSlot(0).func_190916_E() <= 1) break;
                    inSlot.func_190918_g(1);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot);
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        if (ItemStack.func_179545_c((ItemStack)inSlot, (ItemStack)player.field_71071_by.func_70445_o()) && ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)player.field_71071_by.func_70445_o())) {
                            inSlot.func_190917_f(1);
                            ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot.func_77946_l());
                            break;
                        }
                        ItemStack configuredStack = player.field_71071_by.func_70445_o().func_77946_l();
                        configuredStack.func_190920_e(1);
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, configuredStack);
                        break;
                    }
                    if (inSlot.func_190926_b()) break;
                    inSlot.func_190918_g(1);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot.func_77946_l());
                    break;
                }
                case SHIFT_CLICK: {
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ItemStack.field_190927_a);
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || !hasItemInHand) break;
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, player.field_71071_by.func_70445_o().func_77946_l());
                    break;
                }
                case HALVE: {
                    if (inSlot.func_190916_E() <= 1) break;
                    ItemStack halved = inSlot.func_77946_l();
                    halved.func_190920_e(inSlot.func_190916_E() / 2);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, halved);
                    break;
                }
                case DOUBLE: {
                    ItemStack doubled = inSlot.func_77946_l();
                    doubled.func_190920_e(Math.min(512, inSlot.func_190916_E() * 2));
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, doubled);
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterfaceAdv dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterfaceAdv.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDualityAdv();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new ConfigTracker(dual, dual.getConfig(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterfaceAdv.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDualityAdv();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new ConfigTracker(dual, dual.getConfig(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IInterfaceHost, ConfigTracker> en : this.diList.entrySet()) {
            ConfigTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.getSlots());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return false;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, ConfigTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
            tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)inv.pos));
            tag.func_74768_a("dim", inv.dim);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            ItemHandlerUtil.setStackInSlot(inv.client, x + offset, is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
            if (!is.func_190926_b()) {
                ItemStackHelper.stackWriteToNBT(is, itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$708() {
        return autoBase++;
    }

    public static class ConfigTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceConfigurationTerminalAdv.access$708();
        private final String unlocalizedName;
        private final IItemHandler client;
        private final IItemHandler server;
        private final BlockPos pos;
        private final int dim;

        public ConfigTracker(DualityInterfaceAdv dual, IItemHandler configSlots, String unlocalizedName) {
            this.server = configSlots;
            this.client = new AppEngInternalInventory(null, this.server.getSlots());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
            this.pos = dual.getLocation().getPos();
            this.dim = dual.getLocation().getWorld().field_73011_w.getDimension();
        }

        public IItemHandler getServer() {
            return this.server;
        }
    }
}

