/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import appeng.api.util.AECableSize;
import appeng.api.util.AECableVariant;
import java.util.Objects;

public enum AECableType {
    NONE(AECableVariant.NONE, AECableSize.NONE),
    GLASS(AECableVariant.GLASS, AECableSize.NORMAL),
    COVERED(AECableVariant.COVERED, AECableSize.NORMAL),
    SMART(AECableVariant.SMART, AECableSize.NORMAL),
    DENSE_COVERED(AECableVariant.COVERED, AECableSize.DENSE),
    DENSE_SMART(AECableVariant.SMART, AECableSize.DENSE),
    CABLE_X64(AECableVariant.X64, AECableSize.X64),
    CABLE_X128(AECableVariant.X128, AECableSize.X128),
    CABLE_X256(AECableVariant.X256, AECableSize.X256);

    public static final AECableType[] VALIDCABLES;
    private final AECableVariant variant;
    private final AECableSize size;

    private AECableType(AECableVariant variant, AECableSize size) {
        this.variant = variant;
        this.size = size;
    }

    public AECableSize size() {
        return this.size;
    }

    public AECableVariant variant() {
        return this.variant;
    }

    public boolean isValid() {
        return this.variant != AECableVariant.NONE && this.size != AECableSize.NONE;
    }

    public boolean isDense() {
        return this.size == AECableSize.DENSE;
    }

    public boolean isSmart() {
        return this.variant == AECableVariant.SMART;
    }

    public static AECableType min(AECableType a, AECableType b) {
        AECableVariant v = AECableVariant.min(a.variant(), b.variant());
        AECableSize s = AECableSize.min(a.size(), b.size());
        return AECableType.from(v, s);
    }

    public static AECableType max(AECableType a, AECableType b) {
        AECableVariant v = AECableVariant.max(a.variant(), b.variant());
        AECableSize s = AECableSize.max(a.size(), b.size());
        return AECableType.from(v, s);
    }

    private static AECableType from(AECableVariant variant, AECableSize size) {
        switch (variant) {
            case GLASS: {
                if (Objects.requireNonNull(size) != AECableSize.NORMAL) break;
                return GLASS;
            }
            case COVERED: {
                switch (size) {
                    case NORMAL: {
                        return COVERED;
                    }
                    case DENSE: {
                        return DENSE_COVERED;
                    }
                }
                break;
            }
            case SMART: {
                switch (size) {
                    case NORMAL: {
                        return SMART;
                    }
                    case DENSE: {
                        return DENSE_SMART;
                    }
                }
                break;
            }
            case X64: {
                return CABLE_X64;
            }
            case X128: {
                return CABLE_X128;
            }
            case X256: {
                return CABLE_X256;
            }
        }
        return NONE;
    }

    static {
        VALIDCABLES = new AECableType[]{GLASS, COVERED, SMART, DENSE_COVERED, DENSE_SMART, CABLE_X64, CABLE_X128, CABLE_X256};
    }
}

