/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LanternBlock
extends BaseBlock {
    protected static final BlockShape AABB = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)});
    protected static final BlockShape HANGING_AABB = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    public static final PropertyBool REDSTONE = PropertyBool.func_177716_a((String)"redstone");
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");
    public final LanternMaterial material;
    public final LanternColor color;

    public LanternBlock(LanternMaterial material, LanternColor color) {
        super(false, material.getLanternBlockProperties());
        this.material = material;
        this.color = color;
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)REDSTONE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(IBlockState state, World level, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing hitSide, Vec3d hitLocation) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.material.canBeColored && stack.func_77973_b() instanceof ItemDye) {
            LanternColor color = LanternColor.fromDyeColor(EnumDyeColor.func_176766_a((int)stack.func_77960_j()));
            IBlockState newState = this.material.getLanternBlock(color).func_176223_P();
            newState = newState.func_177226_a((IProperty)ON, state.func_177229_b((IProperty)ON));
            newState = newState.func_177226_a((IProperty)REDSTONE, state.func_177229_b((IProperty)REDSTONE));
            newState = newState.func_177226_a((IProperty)HANGING, state.func_177229_b((IProperty)HANGING));
            level.func_180501_a(pos, newState, 3);
        } else {
            level.func_180501_a(pos, state.func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)ON) == false)), 3);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ON, REDSTONE, HANGING});
    }

    public IBlockState getStateForPlacement(World level, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)REDSTONE, (Comparable)Boolean.valueOf(level.func_175640_z(pos))).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(facing == EnumFacing.UP));
        if (LanternBlock.canSurvive(level, pos, state)) {
            return state;
        }
        if (LanternBlock.canSurvive(level, pos, state = state.func_177231_a((IProperty)HANGING))) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private static boolean canSurvive(World level, BlockPos pos, IBlockState state) {
        EnumFacing direction = (Boolean)state.func_177229_b((IProperty)HANGING) != false ? EnumFacing.UP : EnumFacing.DOWN;
        BlockFaceShape shape = level.func_180495_p(pos.func_177972_a(direction)).func_193401_d((IBlockAccess)level, pos.func_177972_a(direction), direction.func_176734_d());
        return shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG || shape == BlockFaceShape.CENTER_SMALL || shape == BlockFaceShape.MIDDLE_POLE || shape == BlockFaceShape.MIDDLE_POLE_THICK || shape == BlockFaceShape.MIDDLE_POLE_THIN || shape == BlockFaceShape.SOLID;
    }

    public boolean func_176196_c(World level, BlockPos pos) {
        return level.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)level, pos) && (LanternBlock.canSurvive(level, pos, this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false))) || LanternBlock.canSurvive(level, pos, this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(true))));
    }

    public void func_176213_c(World level, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && !LanternBlock.canSurvive(level, pos, state) && level.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(level, pos, state, 0);
            level.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World level, BlockPos pos, Block block, BlockPos fromPos) {
        if (state.func_177230_c() == this && !level.field_72995_K) {
            if (!LanternBlock.canSurvive(level, pos, state)) {
                this.func_176226_b(level, pos, state, 0);
                level.func_175698_g(pos);
            } else {
                boolean redstone = (Boolean)state.func_177229_b((IProperty)REDSTONE);
                if (redstone != level.func_175640_z(pos)) {
                    level.func_180501_a(pos, state.func_177226_a((IProperty)REDSTONE, (Comparable)Boolean.valueOf(!redstone)), 7);
                }
            }
        }
    }

    public static boolean emitsLight(IBlockState state) {
        return state.func_177229_b((IProperty)REDSTONE) != state.func_177229_b((IProperty)ON);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)HANGING) != false ? HANGING_AABB.simplify() : AABB.simplify();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue() ? (face == EnumFacing.UP ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.UNDEFINED) : (face == EnumFacing.DOWN ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ON)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)REDSTONE)).booleanValue()) {
            meta |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)REDSTONE, (Comparable)Boolean.valueOf((meta & 2) != 0)).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }
}

