/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.model.ModelBase;
import xaero.common.misc.SeparatedKeysParser;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconModelFieldResolver {
    public static final SeparatedKeysParser KEYS_PARSER = new SeparatedKeysParser(new Predicate<Character>(){

        @Override
        public boolean test(Character c) {
            return c.charValue() == ',' || c.charValue() == ';';
        }
    });

    public static Object[] handleDeclaredField(Field f, Object currentChainNode, String matchedFilterElement, Object[] oneResultArray) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object referencedObject = f.get(currentChainNode);
            if (referencedObject == null) {
                Object[] objectArray = null;
                return objectArray;
            }
            FieldReferenceType<?> referenceType = EntityIconModelFieldResolver.getReferenceType(referencedObject);
            Object[] collectionArray = referenceType.getArray(referencedObject, oneResultArray);
            if (collectionArray.length > 0) {
                if (matchedFilterElement != null && matchedFilterElement.endsWith("]")) {
                    int lastStartBracket = matchedFilterElement.lastIndexOf(91);
                    if (lastStartBracket == -1) {
                        throw new IllegalArgumentException("Field name " + matchedFilterElement + " ends with ] but is missing [!");
                    }
                    try {
                        String keysString = matchedFilterElement.substring(lastStartBracket + 1, matchedFilterElement.length() - 1);
                        String[] keys = KEYS_PARSER.parseKeys(keysString);
                        Object[] result = keys.length == 1 ? oneResultArray : (Object[])Array.newInstance(oneResultArray.getClass().getComponentType(), keys.length);
                        for (int i = 0; i < keys.length; ++i) {
                            Object element;
                            String keyString = keys[i];
                            result[i] = element = referenceType.getElement(referencedObject, collectionArray, keyString);
                        }
                        Object[] objectArray = result;
                        return objectArray;
                    }
                    catch (Exception nfe) {
                        throw new IllegalArgumentException("Invalid element index/indices in " + matchedFilterElement + "!", nfe);
                    }
                }
                Object[] objectArray = collectionArray;
                return objectArray;
            }
            throw new IllegalArgumentException("Empty collection referenced " + matchedFilterElement + "!");
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public static void searchSuperclassFields(Object currentChainNode, List<String> filter, Listener listener, Object[] oneResultArray) {
        Class<?> nodeClass = currentChainNode.getClass();
        while (nodeClass != ModelBase.class && nodeClass != Object.class) {
            Field[] declaredModelFields = nodeClass.getDeclaredFields();
            EntityIconModelFieldResolver.handleFields(currentChainNode, declaredModelFields, filter, listener, oneResultArray);
            if (!listener.shouldStop() && (nodeClass = nodeClass.getSuperclass()) != null) continue;
        }
    }

    public static void handleFields(Object currentChainNode, Field[] declaredModelFields, List<String> filter, Listener listener, Object[] oneResultArray) {
        for (Field f : declaredModelFields) {
            if (!listener.isFieldAllowed(f)) continue;
            try {
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                String matchedFilterElement = null;
                if (filter != null && (matchedFilterElement = EntityIconModelFieldResolver.passesFilter(comparisonName, filter)) == null) continue;
                Object[] matchingObjects = EntityIconModelFieldResolver.handleDeclaredField(f, currentChainNode, matchedFilterElement, oneResultArray);
                if (matchingObjects != null) {
                    listener.onFieldResolved(matchingObjects, matchedFilterElement);
                }
                if (!listener.shouldStop()) continue;
                break;
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    private static String passesFilter(String entry, List<String> filter) {
        for (String f : filter) {
            if (f.equals(entry)) {
                return f;
            }
            int indexOfBracket = f.lastIndexOf(91);
            if (indexOfBracket == -1 || !f.substring(0, indexOfBracket).equals(entry)) continue;
            return f;
        }
        return null;
    }

    private static FieldReferenceType<?> getReferenceType(Object o) {
        if (o instanceof Object[]) {
            return FieldReferenceType.ARRAY;
        }
        if (o instanceof Collection) {
            return FieldReferenceType.COLLECTION;
        }
        if (o instanceof Map) {
            return FieldReferenceType.MAP;
        }
        return FieldReferenceType.SINGLE;
    }

    public static interface Listener {
        public boolean isFieldAllowed(Field var1);

        public boolean shouldStop();

        public void onFieldResolved(Object[] var1, String var2);
    }

    @FunctionalInterface
    private static interface FieldReferenceElementGetter<T> {
        public Object get(T var1, Object[] var2, String var3);
    }

    private static class FieldReferenceType<T> {
        public static FieldReferenceType<Object> SINGLE = new FieldReferenceType<Object>(new FieldReferenceElementGetter<Object>(){

            @Override
            public Object get(Object o, Object[] a, String k) {
                throw new RuntimeException(String.format("%s is not an array/collection!", new Object[0]));
            }
        }, new BiFunction<Object, Object[], Object[]>(){

            @Override
            public Object[] apply(Object o, Object[] ora) {
                ora[0] = o;
                return ora;
            }
        });
        public static FieldReferenceType<Object[]> ARRAY = new FieldReferenceType<Object[]>(new FieldReferenceElementGetter<Object[]>(){

            @Override
            public Object get(Object[] o, Object[] a, String k) {
                return o[Integer.parseInt(k.trim())];
            }
        }, new BiFunction<Object[], Object[], Object[]>(){

            @Override
            public Object[] apply(Object[] o, Object[] ora) {
                return o;
            }
        });
        public static FieldReferenceType<Collection<?>> COLLECTION = new FieldReferenceType(new FieldReferenceElementGetter<Collection<?>>(){

            @Override
            public Object get(Collection<?> o, Object[] a, String k) {
                return a[Integer.parseInt(k.trim())];
            }
        }, new BiFunction<Collection<?>, Object[], Object[]>(){

            @Override
            public Object[] apply(Collection<?> o, Object[] ora) {
                return o.toArray(ora);
            }
        });
        public static FieldReferenceType<Map<?, ?>> MAP = new FieldReferenceType(new FieldReferenceElementGetter<Map<?, ?>>(){

            @Override
            public Object get(Map<?, ?> o, Object[] a, String k) {
                Object result = o.get(k);
                if (result == null) {
                    try {
                        int integerAttemptKey = Integer.parseInt(k.trim());
                        result = o.get(integerAttemptKey);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return result;
            }
        }, new BiFunction<Map<?, ?>, Object[], Object[]>(){

            @Override
            public Object[] apply(Map<?, ?> o, Object[] ora) {
                return o.values().toArray(ora);
            }
        });
        private FieldReferenceElementGetter<T> elementGetter;
        private BiFunction<T, Object[], Object[]> arrayGetter;

        private FieldReferenceType(FieldReferenceElementGetter<T> elementGetter, BiFunction<T, Object[], Object[]> arrayGetter) {
            this.elementGetter = elementGetter;
            this.arrayGetter = arrayGetter;
        }

        public Object[] getArray(Object referencedObject, Object[] oneResultArray) {
            return this.arrayGetter.apply(referencedObject, oneResultArray);
        }

        public Object getElement(Object referencedObject, Object[] array, String key) {
            return this.elementGetter.get(referencedObject, array, key);
        }
    }
}

