/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category.rule;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.rule.ObjectCategoryHardRule;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.minimap.radar.RadarUtils;
import xaero.common.minimap.radar.category.EntityRadarCategoryConstants;

public final class EntityRadarCategoryHardRules {
    private static BlockPos.MutableBlockPos MUTABLE_POS = new BlockPos.MutableBlockPos();
    public static final List<ObjectCategoryHardRule<Entity, EntityPlayer>> HARD_RULES_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final Map<String, ObjectCategoryHardRule<Entity, EntityPlayer>> HARD_RULES = EntityRadarCategoryConstants.MAP_FACTORY.get();
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_NOTHING = new ObjectCategoryHardRule.Builder().setName("nothing").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return false;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_ANYTHING = new ObjectCategoryHardRule.Builder().setName("anything").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return true;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_LIVING = new ObjectCategoryHardRule.Builder().setName("living").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e instanceof EntityLivingBase;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_PLAYER = new ObjectCategoryHardRule.Builder().setName("players").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e instanceof EntityPlayer;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_SAME_TEAM = new ObjectCategoryHardRule.Builder().setName("same-team").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return p.func_96124_cp() == e.func_96124_cp();
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_HOSTILE = new ObjectCategoryHardRule.Builder().setName("hostile").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return RadarUtils.isHostile(e);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_TAMED = new ObjectCategoryHardRule.Builder().setName("tamed").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return RadarUtils.isTamed(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_ITEM = new ObjectCategoryHardRule.Builder().setName("items").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e instanceof EntityItem;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_FRIENDLY = new ObjectCategoryHardRule.Builder().setName("friendly").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_HOSTILE.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_OTHER_TEAMS = new ObjectCategoryHardRule.Builder().setName("other-teams").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_SAME_TEAM.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_BABY = new ObjectCategoryHardRule.Builder().setName("baby").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70631_g_();
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_VANILLA = new ObjectCategoryHardRule.Builder().setName("vanilla").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            if (e instanceof EntityPlayer) {
                return true;
            }
            EntityEntry type = EntityRegistry.getEntry(e.getClass());
            ResourceLocation resourceLocation = type == null ? null : type.getRegistryName();
            return resourceLocation == null ? false : resourceLocation.func_110624_b().equals("minecraft");
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_MODDED = new ObjectCategoryHardRule.Builder().setName("modded").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_VANILLA.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_ABOVE_GROUND = new ObjectCategoryHardRule.Builder().setName("above-ground").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e.field_70170_p.func_175642_b(EnumSkyBlock.SKY, (BlockPos)MUTABLE_POS.func_189535_a(e)) == 15;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_BELOW_GROUND = new ObjectCategoryHardRule.Builder().setName("below-ground").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_ABOVE_GROUND.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_MY_GROUND = new ObjectCategoryHardRule.Builder().setName("my-ground").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return Minecraft.func_71410_x().func_175606_aa() == null || IS_ABOVE_GROUND.isFollowedBy(e, p) == !XaeroMinimapSession.getCurrentSession().getMinimapProcessor().isCaveModeDisplayed();
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_NOT_MY_GROUND = new ObjectCategoryHardRule.Builder().setName("not-my-ground").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_MY_GROUND.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_LIT = new ObjectCategoryHardRule.Builder().setName("block-lit").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)MUTABLE_POS.func_189535_a(e)) > 0;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_UNLIT = new ObjectCategoryHardRule.Builder().setName("block-unlit").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_LIT.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> HAS_CUSTOM_NAME = new ObjectCategoryHardRule.Builder().setName("has-custom-name").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e.func_145818_k_();
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> NO_CUSTOM_NAME = new ObjectCategoryHardRule.Builder().setName("no-custom-name").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !HAS_CUSTOM_NAME.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_TRACKED = new ObjectCategoryHardRule.Builder().setName("tracked").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e instanceof EntityPlayer && XaeroMinimapCore.modMain.getTrackedPlayerRenderer().getCollector().playerExists(e.func_110124_au());
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_IN_TEAM = new ObjectCategoryHardRule.Builder().setName("in-a-team").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return e.func_96124_cp() != null;
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, EntityPlayer> IS_TEAMLESS = new ObjectCategoryHardRule.Builder().setName("teamless").setPredicate(new ObjectCategoryHardRule.Predicate<Entity, EntityPlayer>(){

        @Override
        public boolean test(Entity e, EntityPlayer p) {
            return !IS_IN_TEAM.isFollowedBy(e, p);
        }
    }).build(HARD_RULES, HARD_RULES_LIST);
}

