/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiEntityRadarSettings;
import xaero.common.gui.GuiMinimapBlockMapSettings;
import xaero.common.gui.GuiMinimapInfoSettings;
import xaero.common.gui.GuiMinimapMiscSettings;
import xaero.common.gui.GuiMinimapOverlaysSettings;
import xaero.common.gui.GuiMinimapSettings;
import xaero.common.gui.GuiMinimapViewSettings;
import xaero.common.gui.GuiReset;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.GuiWaypointSettings;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiMinimapMain
extends GuiMinimapSettings {
    private ISettingEntry[] mainEntries;
    private ISettingEntry[] searchableEntries;

    public GuiMinimapMain(GuiScreen current) {
        this(HudMod.INSTANCE, current, GuiMinimapMain.tryToGetEscape(current));
    }

    public GuiMinimapMain(final IXaeroMinimap modMain, final GuiScreen par1GuiScreen, GuiScreen escScreen) {
        super(modMain, (ITextComponent)new TextComponentTranslation("gui.xaero_minimap_settings", new Object[0]), par1GuiScreen, escScreen);
        ScreenSwitchSettingEntry changePositionEntry = new ScreenSwitchSettingEntry("gui.xaero_change_position", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return par1GuiScreen instanceof GuiEditMode ? par1GuiScreen : new GuiEditMode(modMain, current, escape, false, (ITextComponent)new TextComponentTranslation("gui.xaero_minimap_guide", new Object[0]));
            }
        }, null, true);
        ScreenSwitchSettingEntry viewSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_view_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapViewSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry entityRadarSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_entity_radar_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiEntityRadarSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry blockMapSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_block_map_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapBlockMapSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry overlaySettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_overlay_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapOverlaysSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry infoSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_info_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapInfoSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry waypointSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoint_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiWaypointSettings(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry miscSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_misc_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapMiscSettings(modMain, current, escape);
            }
        }, null, true);
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        ScreenSwitchSettingEntry waypointsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoints", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                XaeroMinimapSession minimapSession2 = XaeroMinimapSession.getCurrentSession();
                if (minimapSession2 != null && modMain.getSettings().waypointsGUI(minimapSession2.getWaypointsManager())) {
                    return new GuiWaypoints(modMain, minimapSession2, GuiMinimapMain.this, escape);
                }
                return null;
            }
        }, null, minimapSession != null && modMain.getSettings().waypointsGUI(minimapSession.getWaypointsManager()));
        ArrayList mainEntriesBuilder = Lists.newArrayList((Object[])new ISettingEntry[]{new ConfigSettingEntry(ModOptions.MINIMAP), changePositionEntry, viewSettingsEntry, blockMapSettingsEntry, entityRadarSettingsEntry, overlaySettingsEntry, infoSettingsEntry, waypointSettingsEntry, miscSettingsEntry, waypointsEntry});
        if (modMain.isStandalone()) {
            mainEntriesBuilder.add(new ScreenSwitchSettingEntry("gui.xaero_reset_defaults", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

                @Override
                public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                    return new GuiReset(modMain, par1GuiScreen, escape);
                }
            }, null, true));
        }
        this.mainEntries = mainEntriesBuilder.toArray(new ISettingEntry[0]);
        LinkedHashSet<ISettingEntry> searchableEntriesBuilder = new LinkedHashSet<ISettingEntry>();
        for (ISettingEntry entry : this.mainEntries) {
            if (entry instanceof ScreenSwitchSettingEntry) {
                ScreenSwitchSettingEntry screenSwitchEntry = (ScreenSwitchSettingEntry)entry;
                GuiScreen tempScreen = screenSwitchEntry.getScreenFactory().apply(this, this);
                if (tempScreen instanceof GuiSettings) {
                    GuiSettings tempSettingsScreen = (GuiSettings)tempScreen;
                    ISettingEntry[] settingsScreenEntries = tempSettingsScreen.getEntriesCopy();
                    if (settingsScreenEntries == null) continue;
                    searchableEntriesBuilder.addAll(Arrays.asList(settingsScreenEntries));
                    continue;
                }
                searchableEntriesBuilder.add(entry);
                continue;
            }
            searchableEntriesBuilder.add(entry);
        }
        this.searchableEntries = searchableEntriesBuilder.toArray(new ISettingEntry[0]);
    }

    @Override
    public void func_73866_w_() {
        this.entries = this.entryFilter.isEmpty() ? this.mainEntries : this.searchableEntries;
        super.func_73866_w_();
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = new TextComponentString("\u00a7e" + I18n.func_135052_a((String)"gui.xaero_server_disabled", (Object[])new Object[0]));
        }
    }
}

