/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.TooltipButton;
import xaero.common.gui.WaypointEditForm;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.gui.dropdown.IDropDownWidgetCallback;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.CustomTextFieldFontRendererWrapper;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;
import xaero.hud.minimap.MinimapLogs;

public class GuiAddWaypoint
extends ScreenBase
implements IDropDownWidgetCallback {
    private static final CursorBox VISIBILITY_TYPE_TOOLTIP = new CursorBox("gui.xaero_box_visibility_type");
    private static final CursorBox TYPE_TOOLTIP = new CursorBox("gui.xaero_box_waypoint_type");
    private WaypointsManager waypointsManager;
    protected String screenTitle;
    private static final Function<WaypointEditForm, String> NAME_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getName();
        }
    };
    private static final Function<WaypointEditForm, String> X_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getxText();
        }
    };
    private static final Function<WaypointEditForm, String> Y_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getyText();
        }
    };
    private static final Function<WaypointEditForm, String> Z_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getzText();
        }
    };
    private static final Function<WaypointEditForm, String> YAW_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getYawText();
        }
    };
    private static final Function<WaypointEditForm, String> INITIAL_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getInitial();
        }
    };
    private static final Function<WaypointEditForm, Integer> DISABLED_OR_TEMP_VALUE = new Function<WaypointEditForm, Integer>(){

        @Override
        public Integer apply(WaypointEditForm w) {
            return w.getDisabledOrTemporary();
        }
    };
    private static final Function<WaypointEditForm, Integer> VISIBILITY_TYPE_VALUE = new Function<WaypointEditForm, Integer>(){

        @Override
        public Integer apply(WaypointEditForm w) {
            return w.getVisibilityType();
        }
    };
    private static final Function<WaypointEditForm, Integer> COLOR_VALUE = new Function<WaypointEditForm, Integer>(){

        @Override
        public Integer apply(WaypointEditForm w) {
            return w.getColor();
        }
    };
    private GuiButton leftButton;
    private GuiButton rightButton;
    private GuiButton modeSwitchButton;
    private GuiTextField nameTextField;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField initialTextField;
    private WaypointEditForm mutualForm;
    private ArrayList<WaypointEditForm> editForms;
    private int selectedWaypointIndex;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private DropDownWidget containersDD;
    private DropDownWidget worldsDD;
    private DropDownWidget setsDD;
    private DropDownWidget colorDD;
    private String fromSet;
    private ArrayList<Waypoint> waypointsEdited;
    private GuiButton disableButton;
    private GuiButton visibilityTypeButton;
    private NumericFieldValidator fieldValidator;
    private NumericFieldValidator fieldYValidator;
    private boolean adding;
    private boolean prefilled;
    private boolean startPrefilled;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private GuiButton defaultYawButton;
    private GuiButton defaultDisabledButton;
    private GuiButton defaultVisibilityTypeButton;
    private boolean censorCoordsIfNeeded;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private CustomTextFieldFontRendererWrapper censoredTextFormatter;
    private boolean hasForcedPlayerPos;
    private int forcedPlayerX;
    private int forcedPlayerY;
    private int forcedPlayerZ;
    private double forcedPlayerScale;
    private WaypointWorld forcedCoordSrcWorld;

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, waypointsManager, par1GuiScreen, null, point, defaultParentContainer, defaultWorld, defaultWorld.getCurrent());
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, point, defaultParentContainer, defaultWorld, waypointSet, false, 0, 0, 0);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ, double forcedPlayerScale, WaypointWorld forcedCoordSrcWorld) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, point == null ? new ArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, waypointSet, point == null || point.getActualColor() == -1, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, forcedPlayerScale, forcedCoordSrcWorld);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this(modMain, waypointsManager, par1GuiScreen, null, waypointsEdited, defaultParentContainer, defaultWorld, defaultWorld.getCurrent(), adding);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, waypointsEdited, defaultParentContainer, defaultWorld, waypointSet, adding, false, 0, 0, 0);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ, double forcedPlayerScale, WaypointWorld forcedCoordSrcWorld) {
        super(modMain, par1GuiScreen, escapeScreen);
        this.hasForcedPlayerPos = hasForcedPlayerPos;
        this.forcedPlayerX = forcedPlayerX;
        this.forcedPlayerY = forcedPlayerY;
        this.forcedPlayerZ = forcedPlayerZ;
        this.forcedPlayerScale = forcedPlayerScale;
        this.forcedCoordSrcWorld = forcedCoordSrcWorld;
        this.waypointsEdited = waypointsEdited;
        this.waypointsManager = waypointsManager;
        this.fromSet = waypointSet;
        this.defaultWorld = defaultWorld;
        this.frozenAutoContainerID = waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = waypointsManager.getAutoWorldID();
        this.containers = new GuiWaypointContainers(modMain, waypointsManager, defaultParentContainer, this.frozenAutoContainerID);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(waypointsManager.getWorldContainer(defaultParentContainer), waypointsManager, defaultWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.sets = new GuiWaypointSets(false, defaultWorld, this.fromSet);
        this.prefilled = !waypointsEdited.isEmpty();
        this.startPrefilled = this.prefilled;
        this.createForms();
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.fieldYValidator = modMain.getFieldValidators().getWpCoordFieldValidator();
        this.adding = adding;
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
        this.censorCoordsIfNeeded = true;
        this.censoredTextFormatter = new CustomTextFieldFontRendererWrapper(Minecraft.func_71410_x()){

            @Override
            public String censor(String p_195610_0_) {
                if (!GuiAddWaypoint.this.censorCoordsIfNeeded) {
                    return p_195610_0_;
                }
                int formatIndex = p_195610_0_.indexOf("\u00a7".charAt(0));
                if (formatIndex == -1) {
                    return p_195610_0_.replaceAll("[^_]", "#");
                }
                return p_195610_0_.substring(0, formatIndex).replaceAll(".", "#") + p_195610_0_.substring(formatIndex);
            }
        };
        this.canSkipWorldRender = true;
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, waypointsEdited, defaultParentContainer, defaultWorld, waypointSet, adding, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, Misc.getDimensionTypeScale((World)Minecraft.func_71410_x().field_71441_e), null);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, GuiScreen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ) {
        this(modMain, waypointsManager, par1GuiScreen, escapeScreen, point, defaultParentContainer, defaultWorld, waypointSet, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, Misc.getDimensionTypeScale((World)Minecraft.func_71410_x().field_71441_e), null);
    }

    private void fillFormWaypoint(WaypointEditForm form, Waypoint w) {
        form.name = w.getLocalizedName();
        form.xText = w.getX() + "";
        form.yText = w.isYIncluded() ? w.getY() + "" : "~";
        form.zText = w.getZ() + "";
        form.yawText = w.isRotation() ? w.getYaw() + "" : "";
        form.initial = w.getSymbol() + "";
        form.disabledOrTemporary = w.isOneoffDestination() ? 3 : (w.isTemporary() ? 2 : (w.isDisabled() ? 1 : 0));
        form.color = 1 + (w.getActualColor() == -1 ? (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) : w.getActualColor());
        form.visibilityType = w.getVisibilityType();
        if (form.initial.length() == 0) {
            form.autoInitial = true;
        }
    }

    private double getDimDiv(double waypointDimScale) {
        double playerDimScale = this.hasForcedPlayerPos ? this.forcedPlayerScale : Misc.getDimensionTypeScale(this.field_146297_k.func_175606_aa().field_70170_p);
        return playerDimScale / waypointDimScale;
    }

    private int getAutomaticX(double waypointDimScale) {
        int playerX = this.hasForcedPlayerPos ? this.forcedPlayerX : OptimizedMath.myFloor(this.field_146297_k.func_175606_aa().field_70165_t);
        return OptimizedMath.myFloor((double)playerX * this.getDimDiv(waypointDimScale));
    }

    private String getAutomaticYInput(WaypointWorld destinationWorld) {
        if (this.hasForcedPlayerPos && (this.forcedPlayerY == -1 || this.forcedCoordSrcWorld != null && this.forcedCoordSrcWorld != destinationWorld)) {
            return "~";
        }
        int playerY = this.hasForcedPlayerPos ? this.forcedPlayerY : OptimizedMath.myFloor(this.field_146297_k.func_175606_aa().field_70163_u + 0.0625);
        return OptimizedMath.myFloor(playerY) + "";
    }

    private int getAutomaticZ(double waypointDimScale) {
        int playerZ = this.hasForcedPlayerPos ? this.forcedPlayerZ : OptimizedMath.myFloor(this.field_146297_k.func_175606_aa().field_70161_v);
        return OptimizedMath.myFloor((double)playerZ * this.getDimDiv(waypointDimScale));
    }

    private void fillFormAutomatic(WaypointEditForm form) {
        form.xText = "";
        form.yText = "";
        form.zText = "";
        form.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) + 1;
        form.autoInitial = true;
    }

    private void createForms() {
        this.editForms = new ArrayList();
        this.mutualForm = new WaypointEditForm();
        for (int i = 0; i < this.waypointsEdited.size(); ++i) {
            Waypoint w = this.waypointsEdited.get(i);
            WaypointEditForm form = new WaypointEditForm();
            this.fillFormWaypoint(form, w);
            this.editForms.add(form);
        }
        if (!this.startPrefilled) {
            WaypointEditForm createdForm = new WaypointEditForm();
            this.fillFormAutomatic(createdForm);
            this.editForms.add(createdForm);
        }
        this.updateMutual();
    }

    private void resetCurrentForm() {
        if (this.selectedWaypointIndex >= this.waypointsEdited.size()) {
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormAutomatic(freshForm);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        } else {
            Waypoint w = this.waypointsEdited.get(this.selectedWaypointIndex);
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormWaypoint(freshForm, w);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        }
    }

    private void updateMutual() {
        String nameTextMutual = "";
        String initialMutual = "";
        String yawMutual = "";
        String xTextMutual = "";
        String yTextMutual = "";
        String zTextMutual = "";
        int waypointDisabledOrTemporaryMutual = 0;
        int waypointVisibilityTypeMutual = 0;
        int colorMutual = 0;
        colorMutual = this.differentValues(COLOR_VALUE) ? 0 : this.editForms.get((int)0).color;
        xTextMutual = "";
        yTextMutual = "";
        zTextMutual = "";
        WaypointEditForm firstForm = this.editForms.get(0);
        this.mutualForm.keepName = this.differentValues(NAME_VALUE);
        this.mutualForm.keepXText = this.editForms.size() > 1 && firstForm.xText.isEmpty() || this.differentValues(X_VALUE);
        this.mutualForm.keepYText = this.editForms.size() > 1 && firstForm.yText.isEmpty() || this.differentValues(Y_VALUE);
        this.mutualForm.keepZText = this.editForms.size() > 1 && firstForm.zText.isEmpty() || this.differentValues(Z_VALUE);
        this.mutualForm.defaultKeepYawText = this.mutualForm.keepYawText = this.differentValues(YAW_VALUE);
        this.mutualForm.keepInitial = this.differentValues(INITIAL_VALUE);
        this.mutualForm.autoInitial = this.editForms.size() == 1 && firstForm.autoInitial;
        this.mutualForm.defaultKeepDisabledOrTemporary = this.mutualForm.keepDisabledOrTemporary = this.differentValues(DISABLED_OR_TEMP_VALUE);
        this.mutualForm.defaultKeepVisibilityType = this.mutualForm.keepVisibilityType = this.differentValues(VISIBILITY_TYPE_VALUE);
        if (!this.mutualForm.keepName) {
            nameTextMutual = firstForm.name;
        }
        if (!this.mutualForm.keepXText) {
            xTextMutual = firstForm.xText;
        }
        if (!this.mutualForm.keepYText) {
            yTextMutual = firstForm.yText;
        }
        if (!this.mutualForm.keepZText) {
            zTextMutual = firstForm.zText;
        }
        if (!this.mutualForm.keepYawText) {
            yawMutual = firstForm.yawText;
        }
        if (!this.mutualForm.keepInitial) {
            initialMutual = firstForm.initial;
        }
        if (!this.mutualForm.keepDisabledOrTemporary) {
            waypointDisabledOrTemporaryMutual = firstForm.disabledOrTemporary;
        }
        if (!this.mutualForm.keepVisibilityType) {
            waypointVisibilityTypeMutual = firstForm.visibilityType;
        }
        this.mutualForm.name = nameTextMutual;
        this.mutualForm.xText = xTextMutual;
        this.mutualForm.yText = yTextMutual;
        this.mutualForm.zText = zTextMutual;
        this.mutualForm.yawText = yawMutual;
        this.mutualForm.initial = initialMutual;
        this.mutualForm.disabledOrTemporary = waypointDisabledOrTemporaryMutual;
        this.mutualForm.visibilityType = waypointVisibilityTypeMutual;
        this.mutualForm.color = colorMutual;
    }

    private void confirmMutual() {
        for (int i = 0; i < this.editForms.size(); ++i) {
            WaypointEditForm individualForm = this.editForms.get(i);
            if (!this.mutualForm.keepName) {
                individualForm.name = this.mutualForm.name;
            }
            if (!this.mutualForm.keepXText) {
                individualForm.xText = this.mutualForm.xText;
            }
            if (!this.mutualForm.keepYText) {
                individualForm.yText = this.mutualForm.yText;
            }
            if (!this.mutualForm.keepZText) {
                individualForm.zText = this.mutualForm.zText;
            }
            if (!this.mutualForm.keepYawText) {
                individualForm.yawText = this.mutualForm.yawText;
            }
            if (!this.mutualForm.keepInitial) {
                if (!individualForm.initial.equals(this.mutualForm.initial)) {
                    individualForm.autoInitial = false;
                }
                individualForm.initial = this.mutualForm.initial;
            }
            if (!this.mutualForm.keepDisabledOrTemporary) {
                individualForm.disabledOrTemporary = this.mutualForm.disabledOrTemporary;
            }
            if (!this.mutualForm.keepVisibilityType) {
                individualForm.visibilityType = this.mutualForm.visibilityType;
            }
            if (this.mutualForm.color == 0) continue;
            individualForm.color = this.mutualForm.color;
        }
    }

    private <T> boolean differentValues(Function<WaypointEditForm, T> s) {
        if (this.editForms.size() == 1) {
            return false;
        }
        WaypointEditForm testWaypoint = this.editForms.get(0);
        for (int i = 1; i < this.editForms.size(); ++i) {
            WaypointEditForm w = this.editForms.get(i);
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.getCurrent().color == 0;
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String string = this.screenTitle = this.adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (this.editForms.size() > 1) {
            this.screenTitle = this.screenTitle + (this.editForms.size() > 1 ? " (" + (this.modMain.getSettings().waypointsMutualEdit ? "" : this.selectedWaypointIndex + 1 + "/") + this.editForms.size() + ")" : "");
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.leftButton = new GuiButton(208, this.field_146294_l / 2 - 203, 104, 20, 20, "<");
        this.rightButton = new GuiButton(209, this.field_146294_l / 2 + 183, 104, 20, 20, ">");
        this.modeSwitchButton = new GuiButton(210, this.field_146294_l / 2 + 106, 56, 99, 20, I18n.func_135052_a((String)(this.modMain.getSettings().waypointsMutualEdit ? "gui.xaero_waypoints_edit_mode_all" : "gui.xaero_waypoints_edit_mode_individually"), (Object[])new Object[0]));
        if (this.editForms.size() > 1) {
            this.field_146292_n.add(this.leftButton);
            this.field_146292_n.add(this.rightButton);
            this.field_146292_n.add(this.modeSwitchButton);
        }
        this.field_146292_n.add(new GuiButton(211, this.field_146294_l / 2 - 204, 56, 99, 20, I18n.func_135052_a((String)"gui.xaero_waypoints_edit_reset", (Object[])new Object[0])));
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 104, 200, 20);
        this.xTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 - 109, 134, 50, 20);
        this.yTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 - 53, 134, 50, 20);
        this.zTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 + 3, 134, 50, 20);
        this.yawTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 59, 134, 50, 20);
        this.initialTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 25, 164, 50, 20);
        this.nameTextField.func_146180_a(this.getCurrent().name);
        this.xTextField.func_146180_a(this.getCurrent().xText);
        this.yTextField.func_146180_a(this.getCurrent().yText);
        this.zTextField.func_146180_a(this.getCurrent().zText);
        this.yawTextField.func_146180_a(this.getCurrent().yawText);
        this.initialTextField.func_146180_a(this.getCurrent().initial);
        this.disableButton = new TooltipButton(this.field_146294_l / 2 + 31, 164, 79, 20, this.getDisableButtonText(), new Function<IXaeroMinimap, CursorBox>(){

            @Override
            public CursorBox apply(IXaeroMinimap modMain) {
                return TYPE_TOOLTIP;
            }
        }){

            @Override
            protected void onPress() {
                ((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().disabledOrTemporary = (((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().disabledOrTemporary + 1) % 4;
                ((GuiAddWaypoint)GuiAddWaypoint.this).disableButton.field_146126_j = GuiAddWaypoint.this.getDisableButtonText();
                ((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().keepDisabledOrTemporary = false;
                if (GuiAddWaypoint.this.defaultDisabledButton != null) {
                    ((GuiAddWaypoint)GuiAddWaypoint.this).defaultDisabledButton.field_146124_l = true;
                }
            }
        };
        this.field_146292_n.add(this.disableButton);
        this.visibilityTypeButton = new TooltipButton(this.field_146294_l / 2 - 109, 164, 79, 20, I18n.func_135052_a((String)WaypointVisibilityType.values()[this.getCurrent().visibilityType].getTranslation(), (Object[])new Object[0]), new Function<IXaeroMinimap, CursorBox>(){

            @Override
            public CursorBox apply(IXaeroMinimap modMain) {
                return VISIBILITY_TYPE_TOOLTIP;
            }
        }){

            @Override
            protected void onPress() {
                ((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().visibilityType = (((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().visibilityType + 1) % WaypointVisibilityType.values().length;
                ((GuiAddWaypoint)GuiAddWaypoint.this).visibilityTypeButton.field_146126_j = I18n.func_135052_a((String)WaypointVisibilityType.values()[((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().visibilityType].getTranslation(), (Object[])new Object[0]);
                ((GuiAddWaypoint)GuiAddWaypoint.this).getCurrent().keepVisibilityType = false;
                if (GuiAddWaypoint.this.defaultVisibilityTypeButton != null) {
                    ((GuiAddWaypoint)GuiAddWaypoint.this).defaultVisibilityTypeButton.field_146124_l = true;
                }
            }
        };
        this.func_189646_b(this.visibilityTypeButton);
        if (this.getCurrent().defaultKeepYawText) {
            this.defaultYawButton = new GuiButton(206, this.field_146294_l / 2 + 111, 134, 20, 20, "-");
            this.func_189646_b(this.defaultYawButton);
            boolean bl = this.defaultYawButton.field_146124_l = !this.getCurrent().keepYawText;
        }
        if (this.getCurrent().defaultKeepDisabledOrTemporary) {
            this.defaultDisabledButton = new GuiButton(207, this.field_146294_l / 2 + 110, 164, 20, 20, "-");
            this.func_189646_b(this.defaultDisabledButton);
            boolean bl = this.defaultDisabledButton.field_146124_l = !this.getCurrent().keepDisabledOrTemporary;
        }
        if (this.getCurrent().defaultKeepVisibilityType) {
            this.defaultVisibilityTypeButton = new GuiButton(214, this.field_146294_l / 2 - 130, 164, 20, 20, "-");
            this.func_189646_b(this.defaultVisibilityTypeButton);
            boolean bl = this.defaultVisibilityTypeButton.field_146124_l = !this.getCurrent().keepVisibilityType;
        }
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.func_189646_b(new MySuperTinyButton(212, this.field_146294_l / 2 + 115, 134, I18n.func_135052_a((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), (Object[])new Object[0])));
        }
        int currentColor = this.getCurrent().color;
        this.colorDD = DropDownWidget.Builder.begin().setOptions(this.createColorOptions()).setX(this.field_146294_l / 2 - 60).setY(82).setW(120).setSelected(currentColor == 0 ? 0 : currentColor - 1).setCallback(this).setContainer(this).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_waypoint_color", (Object[])new Object[0])).build();
        this.addWidget(this.colorDD);
        this.setsDD = this.createSetsDropdown();
        this.addWidget(this.setsDD);
        this.containersDD = this.createContainersDropdown();
        this.addWidget(this.containersDD);
        this.worldsDD = this.createWorldsDropdown();
        this.addWidget(this.worldsDD);
        this.nameTextField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    private DropDownWidget createSetsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.sets.getOptions()).setX(this.field_146294_l / 2 - 101).setY(60).setW(201).setSelected(this.sets.getCurrentSet()).setCallback(this).setContainer(this).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_waypoint_set", (Object[])new Object[0])).build();
    }

    private DropDownWidget createContainersDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.containers.options).setX(this.field_146294_l / 2 - 203).setY(38).setW(200).setSelected(this.containers.current).setCallback(this).setContainer(this).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_waypoint_container", (Object[])new Object[0])).build();
    }

    private DropDownWidget createWorldsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.worlds.options).setX(this.field_146294_l / 2 + 2).setY(38).setW(200).setSelected(this.worlds.current).setCallback(this).setContainer(this).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_waypoint_world", (Object[])new Object[0])).build();
    }

    private String getDisableButtonText() {
        return I18n.func_135052_a((String)(this.getCurrent().disabledOrTemporary == 3 ? "gui.xaero_destination" : (this.getCurrent().disabledOrTemporary == 1 ? "gui.xaero_toggle_disabled" : (this.getCurrent().disabledOrTemporary == 0 ? "gui.xaero_toggle_enabled" : "gui.xaero_temporary2"))), (Object[])new Object[0]);
    }

    private WaypointEditForm getCurrent() {
        return this.modMain.getSettings().waypointsMutualEdit ? this.mutualForm : this.editForms.get(this.selectedWaypointIndex);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameTextField.func_146206_l()) {
            if (par2 == 15) {
                this.nameTextField.func_146195_b(false);
                this.xTextField.func_146195_b(true);
            }
            this.nameTextField.func_146201_a(par1, par2);
            if (!(!this.getCurrent().autoInitial || this.nameTextField.func_146179_b().length() <= 0 || this.getCurrent().keepInitial && this.modMain.getSettings().waypointsMutualEdit)) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1).toUpperCase());
            }
        } else if (this.xTextField.func_146206_l()) {
            if (par2 == 15) {
                this.xTextField.func_146195_b(false);
                this.yTextField.func_146195_b(true);
            }
            this.xTextField.func_146201_a(par1, par2);
        } else if (this.yTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yTextField.func_146195_b(false);
                this.zTextField.func_146195_b(true);
            }
            this.yTextField.func_146201_a(par1, par2);
        } else if (this.zTextField.func_146206_l()) {
            if (par2 == 15) {
                this.zTextField.func_146195_b(false);
                this.yawTextField.func_146195_b(true);
            }
            this.zTextField.func_146201_a(par1, par2);
        } else if (this.yawTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yawTextField.func_146195_b(false);
                this.initialTextField.func_146195_b(true);
            }
            this.yawTextField.func_146201_a(par1, par2);
        } else if (this.initialTextField.func_146206_l()) {
            this.getCurrent().autoInitial = false;
            if (par2 == 15) {
                this.initialTextField.func_146195_b(false);
                this.nameTextField.func_146195_b(true);
            }
            if (par2 != 57) {
                this.initialTextField.func_146201_a(par1, par2);
            }
        }
        if (par2 == 28 || par2 == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.checkFields();
        this.updateConfirmButton();
        super.func_73869_a(par1, par2);
    }

    private boolean canConfirm() {
        WaypointEditForm current = this.getCurrent();
        return !(!current.keepName && current.name.length() <= 0 || !current.keepInitial && current.initial.length() <= 0);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.modeSwitchButton.field_146124_l = this.canConfirm();
        this.leftButton.field_146124_l = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex > 0;
        this.rightButton.field_146124_l = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex < this.editForms.size() - 1;
    }

    private void handleCoordinateInputSpaces(GuiTextField coordinateBox, GuiTextField nextBox) {
        String startingBoxValue = coordinateBox.func_146179_b();
        int indexOfFirstSpace = startingBoxValue.indexOf(32);
        if (indexOfFirstSpace != -1) {
            String subStringToCut = startingBoxValue.substring(indexOfFirstSpace + 1);
            coordinateBox.func_146180_a(startingBoxValue.substring(0, indexOfFirstSpace));
            coordinateBox.func_146196_d();
            nextBox.func_146180_a(nextBox.func_146179_b() + subStringToCut);
            if (coordinateBox.func_146206_l()) {
                coordinateBox.func_146195_b(false);
                nextBox.func_146195_b(true);
                nextBox.func_146202_e();
            }
        }
    }

    protected void checkFields() {
        this.handleCoordinateInputSpaces(this.xTextField, this.yTextField);
        this.handleCoordinateInputSpaces(this.yTextField, this.zTextField);
        this.handleCoordinateInputSpaces(this.zTextField, this.yawTextField);
        this.fieldValidator.validate(this.yawTextField);
        if (this.yawTextField.func_146206_l()) {
            this.getCurrent().keepYawText = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.field_146124_l = true;
            }
        }
        this.fieldValidator.validate(this.xTextField);
        this.fieldYValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        WaypointEditForm current = this.getCurrent();
        current.name = this.nameTextField.func_146179_b();
        current.xText = this.xTextField.func_146179_b();
        current.yText = this.yTextField.func_146179_b();
        current.zText = this.zTextField.func_146179_b();
        current.yawText = this.yawTextField.func_146179_b();
        current.initial = this.initialTextField.func_146179_b();
        if (current.initial.length() > 2) {
            current.initial = current.initial.substring(0, 2);
            this.initialTextField.func_146180_a(current.initial);
        }
        if (current.yawText.length() > 4) {
            current.yawText = current.yawText.substring(0, 4);
            this.yawTextField.func_146180_a(current.yawText);
        }
        if (this.prefilled && this.editForms.size() > 1 && this.modMain.getSettings().waypointsMutualEdit) {
            current.keepName = current.name.isEmpty();
            current.keepXText = current.xText.isEmpty();
            current.keepYText = current.yText.isEmpty();
            current.keepZText = current.zText.isEmpty();
            current.keepInitial = current.initial.isEmpty();
        }
    }

    @Override
    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        if (this.handledMouseInput) {
            return;
        }
        this.handledMouseInput = this.handledMouseInput || this.nameTextField.func_146192_a(par1, par2, par3);
        this.handledMouseInput = this.handledMouseInput || this.xTextField.func_146192_a(par1, par2, par3);
        this.handledMouseInput = this.handledMouseInput || this.yTextField.func_146192_a(par1, par2, par3);
        this.handledMouseInput = this.handledMouseInput || this.zTextField.func_146192_a(par1, par2, par3);
        this.handledMouseInput = this.handledMouseInput || this.yawTextField.func_146192_a(par1, par2, par3);
        this.handledMouseInput = this.handledMouseInput || this.initialTextField.func_146192_a(par1, par2, par3);
    }

    private void setFieldText(GuiTextField field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void func_73876_c() {
        if (this.field_146297_k.func_175606_aa() == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        super.func_146284_a(par1GuiButton);
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MySmallButton) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.confirmMutual();
                }
                boolean creatingAWaypoint = this.adding && this.waypointsEdited.size() < this.editForms.size();
                String[] destinationWorldKeys = this.worlds.getCurrentKeys();
                WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
                double waypointDimScale = this.waypointsManager.getDimCoordinateScale(destinationWorld);
                int initialEditedWaypointsSize = this.waypointsEdited.size();
                for (int i = 0; i < this.editForms.size(); ++i) {
                    Waypoint w;
                    int z;
                    boolean shouldCreate;
                    boolean bl = shouldCreate = i >= initialEditedWaypointsSize;
                    if (!creatingAWaypoint && shouldCreate) break;
                    WaypointEditForm waypointForm = this.editForms.get(i);
                    String nameString = waypointForm.name;
                    String xString = waypointForm.xText;
                    String yString = waypointForm.yText;
                    if (yString.equals("-") || yString.isEmpty()) {
                        yString = this.getAutomaticYInput(destinationWorld);
                    }
                    String zString = waypointForm.zText;
                    String initialString = waypointForm.initial;
                    int colorInt = waypointForm.color;
                    boolean yIncluded = !yString.equals("~");
                    int x = xString.equals("-") || xString.isEmpty() ? this.getAutomaticX(waypointDimScale) : Integer.parseInt(xString);
                    int y = !yIncluded ? 0 : Integer.parseInt(yString);
                    int n = z = zString.equals("-") || zString.isEmpty() ? this.getAutomaticZ(waypointDimScale) : Integer.parseInt(zString);
                    if (shouldCreate) {
                        w = new Waypoint(x, y, z, nameString, initialString, colorInt - 1, 0, false, yIncluded);
                        this.waypointsEdited.add(w);
                    } else {
                        w = this.waypointsEdited.get(i);
                        if (w.getType() != 1 || !nameString.equals(I18n.func_135052_a((String)"gui.xaero_deathpoint", (Object[])new Object[0]))) {
                            w.setName(nameString);
                            if (w.getWaypointType() != 0) {
                                w.setType(0);
                                w.setOneoffDestination(false);
                            }
                        }
                        w.setX(x);
                        w.setY(y);
                        w.setZ(z);
                        w.setSymbol(initialString);
                        w.setColor(colorInt - 1);
                        w.setYIncluded(yIncluded);
                    }
                    String yawText = waypointForm.yawText;
                    int disableOrTemporary = waypointForm.disabledOrTemporary;
                    boolean yawIsUsable = yawText.length() > 0 && !yawText.equals("-");
                    w.setRotation(yawIsUsable);
                    if (yawIsUsable) {
                        w.setYaw(Integer.parseInt(yawText));
                    }
                    w.setOneoffDestination(disableOrTemporary == 3);
                    w.setDisabled(disableOrTemporary == 1);
                    if (disableOrTemporary == 2) {
                        w.setTemporary(true);
                    }
                    w.setVisibilityType(waypointForm.visibilityType);
                }
                WaypointWorld sourceWorld = this.defaultWorld;
                WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
                String destinationSetKey = this.sets.getCurrentSetKey();
                WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
                if (this.adding || sourceSet != destinationSet) {
                    if (!this.modMain.getSettings().waypointsBottom) {
                        destinationSet.getList().addAll(0, this.waypointsEdited);
                    } else {
                        destinationSet.getList().addAll(this.waypointsEdited);
                    }
                }
                if (sourceSet != destinationSet) {
                    sourceSet.getList().removeAll(this.waypointsEdited);
                }
                try {
                    this.modMain.getSettings().saveWaypoints(sourceWorld);
                    if (destinationWorld != sourceWorld) {
                        this.modMain.getSettings().saveWaypoints(destinationWorld);
                    }
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                this.goBack();
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.goBack();
            }
            if (par1GuiButton.field_146127_k == 206) {
                this.getCurrent().keepYawText = true;
                this.getCurrent().yawText = "";
                this.yawTextField.func_146180_a(this.getCurrent().yawText);
                par1GuiButton.field_146124_l = false;
            }
            if (par1GuiButton.field_146127_k == 207) {
                this.getCurrent().keepDisabledOrTemporary = true;
                this.getCurrent().disabledOrTemporary = 0;
                this.disableButton.field_146126_j = this.getDisableButtonText();
                par1GuiButton.field_146124_l = false;
            }
            if (par1GuiButton.field_146127_k == 208) {
                --this.selectedWaypointIndex;
                if (this.selectedWaypointIndex < 0) {
                    this.selectedWaypointIndex = 0;
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 209) {
                ++this.selectedWaypointIndex;
                if (this.selectedWaypointIndex >= this.editForms.size()) {
                    this.selectedWaypointIndex = this.editForms.size() - 1;
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 210) {
                this.modMain.getSettings().waypointsMutualEdit = !this.modMain.getSettings().waypointsMutualEdit;
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.prefilled = true;
                    this.updateMutual();
                } else {
                    this.confirmMutual();
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 211) {
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.createForms();
                    this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
                } else {
                    this.resetCurrentForm();
                    this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
                }
            }
            if (par1GuiButton.field_146127_k == 212) {
                this.censorCoordsIfNeeded = !this.censorCoordsIfNeeded;
                par1GuiButton.field_146126_j = I18n.func_135052_a((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), (Object[])new Object[0]);
            }
            if (par1GuiButton.field_146127_k == 214) {
                this.getCurrent().keepVisibilityType = true;
                this.getCurrent().visibilityType = 0;
                this.visibilityTypeButton.field_146126_j = I18n.func_135052_a((String)WaypointVisibilityType.values()[this.getCurrent().visibilityType].getTranslation(), (Object[])new Object[0]);
                this.defaultVisibilityTypeButton.field_146124_l = false;
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public List getButtons() {
        return this.field_146292_n;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        super.renderTooltips(par1, par2, par3);
    }

    @Override
    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(mouseX, mouseY, partial);
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        WaypointEditForm current = this.getCurrent();
        if (!this.nameTextField.func_146206_l() && current.keepName) {
            Misc.setFieldText(this.nameTextField, this.namePlaceholder);
            this.nameTextField.func_146190_e(0);
        }
        String[] destinationWorldKeys = this.worlds.getCurrentKeys();
        WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
        double waypointDimScale = this.waypointsManager.getDimCoordinateScale(destinationWorld);
        if (current.keepXText) {
            if (!this.xTextField.func_146206_l()) {
                Misc.setFieldText(this.xTextField, this.xPlaceholder);
            }
        } else if (current.xText.isEmpty()) {
            Misc.setFieldText(this.xTextField, "\u00a78" + this.getAutomaticX(waypointDimScale));
            this.xTextField.func_146190_e(0);
        }
        if (current.keepYText) {
            if (!this.yTextField.func_146206_l()) {
                Misc.setFieldText(this.yTextField, this.yPlaceholder);
            }
        } else if (current.yText.isEmpty()) {
            Misc.setFieldText(this.yTextField, "\u00a78" + this.getAutomaticYInput(destinationWorld));
            this.yTextField.func_146190_e(0);
        }
        if (current.keepZText) {
            if (!this.zTextField.func_146206_l()) {
                Misc.setFieldText(this.zTextField, this.zPlaceholder);
            }
        } else if (current.zText.isEmpty()) {
            Misc.setFieldText(this.zTextField, "\u00a78" + this.getAutomaticZ(waypointDimScale));
            this.zTextField.func_146190_e(0);
        }
        if (!this.yawTextField.func_146206_l() && current.yawText.isEmpty()) {
            if (current.keepYawText) {
                Misc.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                Misc.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
            this.yawTextField.func_146190_e(0);
        }
        if (!this.initialTextField.func_146206_l() && current.initial.isEmpty()) {
            if (current.keepInitial) {
                Misc.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                Misc.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
            this.initialTextField.func_146190_e(0);
        }
        this.nameTextField.func_146194_f();
        this.xTextField.func_146194_f();
        this.yTextField.func_146194_f();
        this.zTextField.func_146194_f();
        this.yawTextField.func_146194_f();
        this.initialTextField.func_146194_f();
        Misc.setFieldText(this.nameTextField, current.name);
        Misc.setFieldText(this.xTextField, current.xText);
        Misc.setFieldText(this.yTextField, current.yText);
        Misc.setFieldText(this.zTextField, current.zText);
        Misc.setFieldText(this.yawTextField, current.yawText);
        Misc.setFieldText(this.initialTextField, current.initial);
    }

    @Override
    public boolean onSelected(DropDownWidget menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
        } else if (menu == this.colorDD) {
            this.getCurrent().color = this.colorDD.size() > ModSettings.ENCHANT_COLORS.length ? selected : selected + 1;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld, this.containers.current == this.defaultContainer ? this.fromSet : currentWorld.getCurrent());
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget(this.setsDD, this.setsDD);
            this.worldsDD = this.createWorldsDropdown();
            this.replaceWidget(this.worldsDD, this.worldsDD);
        } else if (menu == this.worldsDD) {
            WaypointWorld currentWorld;
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, currentWorld, (currentWorld = this.waypointsManager.getWorld(worldKeys[0], worldKeys[1])) == this.defaultWorld ? this.fromSet : currentWorld.getCurrent());
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget(this.setsDD, this.setsDD);
        }
        return true;
    }
}

