/*
 * Decompiled with CFR 0.152.
 */
package xaero.common;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContext;
import xaero.common.PlatformContextLoaderClientOnlyForge;
import xaero.common.PlatformContextLoaderCommonForge;
import xaero.common.XaeroMinimapSession;
import xaero.common.cache.BlockStateShortShapeCache;
import xaero.common.events.ClientEvents;
import xaero.common.events.CommonEvents;
import xaero.common.events.ModClientEvents;
import xaero.common.events.ModCommonEvents;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandler;
import xaero.common.message.MinimapMessageHandlerForge;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.mods.SupportMods;

public class PlatformContextForge
extends PlatformContext {
    private SimpleNetworkWrapper network;
    private PlatformContextLoaderClientOnlyForge loaderClientOnly;
    private PlatformContextLoaderCommonForge loaderCommon;
    private final HudMod modMain;
    private ModMetadata modInfo;
    private Path modFile;
    private boolean dedicatedServer;
    private Path configFolder;
    private Path defaultConfigsFolder;

    public PlatformContextForge(HudMod modMain) {
        this.modMain = modMain;
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(MinimapMessage.MAIN_CHANNEL.toString());
    }

    private void registerEvents(Side side) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getCommonEvents());
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getModCommonEvents());
        if (side == Side.CLIENT) {
            this.registerClientEvents();
        }
    }

    private void registerClientEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getModClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getEvents());
    }

    public void loadPreCommonForge(FMLPreInitializationEvent event, Class<? extends HudMod> modClass, boolean enabled) {
        this.modInfo = event.getModMetadata();
        this.modFile = event.getSourceFile().toPath();
        this.dedicatedServer = event.getSide() == Side.SERVER;
        this.configFolder = event.getModConfigurationDirectory().toPath();
        this.defaultConfigsFolder = this.configFolder.resolveSibling("defaultconfigs");
        this.modMain.loadPreCommon(this, modClass, enabled);
        this.registerEvents(event.getSide());
    }

    public void loadCommonForge(FMLInitializationEvent event) {
        this.modMain.loadCommon();
    }

    public void loadLaterCommonForge(FMLPostInitializationEvent event) {
    }

    public void loadPreClientForge(FMLPreInitializationEvent event) {
    }

    public void loadClientForge(FMLInitializationEvent event) {
        try {
            this.modMain.loadClient();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadLaterClientForge(FMLPostInitializationEvent event) {
        this.modMain.loadLater();
    }

    public void loadPreServerForge(FMLPreInitializationEvent event) {
    }

    public void loadServerForge(FMLInitializationEvent event) {
        this.modMain.loadServer();
    }

    public void loadLaterServerForge(FMLPostInitializationEvent event) {
        this.modMain.loadLaterServer();
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        this.modMain.getCommonEvents().onServerStarting(event);
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
        this.modMain.getCommonEvents().onServerStopped(event);
    }

    @Override
    public ClientEvents createClientEvents(IXaeroMinimap modMain) {
        return modMain.createClientEvents();
    }

    @Override
    public CommonEvents createCommonEvents(IXaeroMinimap modMain) {
        return new CommonEvents(modMain);
    }

    @Override
    public MinimapMessageHandler createMessageHandler(IXaeroMinimap modMain) {
        return new MinimapMessageHandlerForge(modMain, this);
    }

    @Override
    public PlatformContextLoaderClientOnlyForge getLoaderClientOnly() {
        if (this.loaderClientOnly == null) {
            this.loaderClientOnly = new PlatformContextLoaderClientOnlyForge();
        }
        return this.loaderClientOnly;
    }

    @Override
    public PlatformContextLoaderCommonForge getLoaderCommon() {
        if (this.loaderCommon == null) {
            this.loaderCommon = new PlatformContextLoaderCommonForge();
        }
        return this.loaderCommon;
    }

    @Override
    public ModClientEvents createModClientEvents(IXaeroMinimap modMain) {
        return new ModClientEvents(modMain);
    }

    @Override
    public SupportMods createSupportMods(IXaeroMinimap modMain) {
        return new SupportMods(modMain);
    }

    @Override
    public ModCommonEvents createModCommonEvents(IXaeroMinimap modMain) {
        return new ModCommonEvents(modMain);
    }

    @Override
    public MinimapWriter createMinimapWriter(IXaeroMinimap modMain, XaeroMinimapSession xaeroMinimapSession, BlockStateShortShapeCache blockStateShortShapeCache, HighlighterRegistry highlighterRegistry) {
        return new MinimapWriter(modMain, xaeroMinimapSession, blockStateShortShapeCache, highlighterRegistry);
    }

    @Override
    public String getModInfoVersion() {
        return this.modInfo.version;
    }

    public SimpleNetworkWrapper getNetwork() {
        return this.network;
    }

    @Override
    public Path getConfigFolderPath() {
        return this.configFolder;
    }

    @Override
    public Path getDefaultConfigsFolderPath() {
        return this.defaultConfigsFolder;
    }

    @Override
    public Path getModFile() {
        return this.modFile;
    }

    @Override
    public boolean isDedicatedServer() {
        return this.dedicatedServer;
    }
}

