/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.vc.CommonUtils;
import noppes.vc.Server;
import noppes.vc.VariedCommodities;
import noppes.vc.blocks.tiles.TileBigSign;
import noppes.vc.blocks.tiles.TileBook;
import noppes.vc.constants.PacketServer;
import noppes.vc.containers.ContainerTradingBlock;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        final EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        final ByteBuf buffer = event.getPacket().payload();
        player.func_184102_h().func_152344_a(new Runnable(){

            @Override
            public void run() {
                PacketServer type = null;
                try {
                    type = PacketServer.values()[buffer.readInt()];
                    PacketHandlerServer.this.handlePacket(type, buffer, player);
                }
                catch (Exception e) {
                    VariedCommodities.Log.error("Error with EnumPacketServer." + (Object)((Object)type), (Throwable)e);
                }
            }
        });
    }

    private void handlePacket(PacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == PacketServer.TRADE_ACCEPT) {
            if (!(player.field_71070_bA instanceof ContainerTradingBlock)) {
                return;
            }
            ContainerTradingBlock con = (ContainerTradingBlock)player.field_71070_bA;
            if (!con.tile.isFull()) {
                return;
            }
            ContainerTradingBlock con2 = (ContainerTradingBlock)con.tile.other((EntityPlayer)player).field_71070_bA;
            if (con.state == 0) {
                con.setState(2);
                con2.setState(1);
            } else if (con.state == 1 || con.state == 2) {
                con.setState(3);
                con2.setState(3);
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = con.craftMatrix.func_70301_a(i);
                    con.craftMatrix.func_70299_a(i, con2.craftMatrix.func_70301_a(i));
                    con2.craftMatrix.func_70299_a(i, item);
                }
            }
        } else if (type == PacketServer.SAVE_SIGN) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile == null || !(tile instanceof TileBigSign)) {
                return;
            }
            TileBigSign sign = (TileBigSign)tile;
            if (sign.canEdit) {
                sign.setText(Server.readString(buffer));
                sign.canEdit = false;
                tile.func_70296_d();
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                player.field_70170_p.func_184138_a(pos, state, state, 3);
            }
        } else if (type == PacketServer.SAVE_BOOK) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tileentity = player.field_70170_p.func_175625_s(pos);
            if (!(tileentity instanceof TileBook)) {
                return;
            }
            TileBook tile = (TileBook)tileentity;
            if (tile.book.func_77973_b() == Items.field_151164_bB) {
                return;
            }
            boolean sign = buffer.readBoolean();
            ItemStack book = new ItemStack(Server.readNBT(buffer));
            if (book.func_190926_b()) {
                return;
            }
            if (book.func_77973_b() == Items.field_151099_bA && !sign && ItemWritableBook.func_150930_a((NBTTagCompound)book.func_77978_p())) {
                tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
            }
            if (book.func_77973_b() == Items.field_151164_bB && sign && ItemWrittenBook.func_77828_a((NBTTagCompound)book.func_77978_p())) {
                tile.book.func_77983_a("author", (NBTBase)new NBTTagString(player.func_70005_c_()));
                tile.book.func_77983_a("title", (NBTBase)new NBTTagString(book.func_77978_p().func_74779_i("title")));
                tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
                tile.book = CommonUtils.ChangeItemStack(tile.book, Items.field_151164_bB);
            }
        }
    }

    private void warn(EntityPlayer player, String warning) {
        player.func_184102_h().func_71236_h(player.func_70005_c_() + ": " + warning);
    }
}

