/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.recipe;

import com.google.common.base.Preconditions;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import shadows.singularity.recipe.ICompressorRecipe;

public class CompressorRecipe
implements ICompressorRecipe {
    protected final Ingredient input;
    protected final int numInputs;
    protected final ItemStack output;
    protected final ResourceLocation name;

    public CompressorRecipe(ResourceLocation name, Ingredient input, int numInputs, ItemStack output) {
        Preconditions.checkArgument((input != Ingredient.field_193370_a ? 1 : 0) != 0, (Object)"pls stop");
        this.input = input;
        this.numInputs = numInputs;
        this.output = output.func_77946_l();
        this.name = name;
    }

    @Override
    public int getRequiredInputs() {
        return this.numInputs;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutputStack() {
        return this.output;
    }

    @Override
    public ResourceLocation getID() {
        return this.name;
    }

    public static CompressorRecipe fromString(String s) {
        String[] split = s.split(", ");
        Preconditions.checkArgument((split.length == 4 ? 1 : 0) != 0, (Object)("Invalid Compressor Recipe (failed to split on \", \"): " + s));
        ResourceLocation name = split[0].split(":").length == 2 ? new ResourceLocation(split[0]) : new ResourceLocation("singularities", split[0]);
        Object input = split[1].split(":").length == 1 ? new OreIngredient(split[1]) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CompressorRecipe.parseItemStack(split[1])});
        int numInputs = Integer.parseInt(split[2]);
        ItemStack output = CompressorRecipe.parseItemStack(split[3]);
        return new CompressorRecipe(name, (Ingredient)input, numInputs, output);
    }

    private static ItemStack parseItemStack(String s) {
        String[] split = s.split(":");
        return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1])), 1, split.length == 3 ? Integer.parseInt(split[2]) : 0);
    }
}

