/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.recipe;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import shadows.singularity.recipe.ICompressorRecipe;

public class CompressorManager {
    private static final Map<ResourceLocation, ICompressorRecipe> RECIPES = new HashMap<ResourceLocation, ICompressorRecipe>();
    private static Collection<ICompressorRecipe> VALID_RECIPES;

    public static void registerRecipe(ICompressorRecipe recipe) {
        if (RECIPES.get(recipe.getID()) != null) {
            throw new IllegalArgumentException(String.format("This recipe (ID: %s) is already in the registry!", recipe.getID().toString()));
        }
        RECIPES.put(recipe.getID(), recipe);
    }

    public static ICompressorRecipe searchByStack(ItemStack input) {
        for (ICompressorRecipe r : RECIPES.values()) {
            if (!r.getInput().apply(input)) continue;
            return r;
        }
        return null;
    }

    public static ICompressorRecipe searchByName(ResourceLocation name) {
        return RECIPES.get(name);
    }

    public static Collection<ICompressorRecipe> getValidRecipes() {
        if (VALID_RECIPES == null) {
            VALID_RECIPES = RECIPES.values().stream().filter(r -> r.getInput().func_193365_a().length > 0).collect(Collectors.toList());
        }
        return VALID_RECIPES;
    }
}

