/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.singularity.block.VanillaPacketDispatcher;
import shadows.singularity.recipe.CompressorManager;
import shadows.singularity.recipe.ICompressorRecipe;
import shadows.singularity.recipe.SingularityConfig;

public class TileCompressor
extends TileEntity
implements ITickable {
    public static final String RECENT_KEY = "recent_eject";
    public static double distance = 1.5;
    private ICompressorRecipe recipe;
    private int ticks = 0;
    private int counter = 0;
    private final ItemStackHandler handler = new CompressorItemHandler(this);

    public ICompressorRecipe getRecipe() {
        return this.recipe;
    }

    public int getCounter() {
        return this.counter;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("count", this.counter);
        tag.func_74778_a("recipe", this.recipe == null ? "null" : this.recipe.getID().toString());
        tag.func_74782_a("handler", (NBTBase)this.handler.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.counter = tag.func_74762_e("count");
        this.recipe = CompressorManager.searchByName(new ResourceLocation(tag.func_74779_i("recipe")));
        this.handler.deserializeNBT(tag.func_74775_l("handler"));
        super.func_145839_a(tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.ticks = 0;
            for (EntityItem ei : this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b(3.0, 1.0, 3.0))) {
                if (ei.getEntityData().func_74767_n(RECENT_KEY)) continue;
                this.matchAndUse(ei.func_92059_d());
            }
        }
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.matchAndUse(this.handler.getStackInSlot(i));
        }
    }

    public void compressStack(ItemStack stack) {
        int needed = this.recipe.getRequiredInputs() - this.counter;
        this.counter += stack.func_190916_E();
        stack.func_190918_g(needed);
        if (this.counter >= this.recipe.getRequiredInputs()) {
            TileEntity e = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (e == null || !this.putOutputInHandler((IItemHandler)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP))) {
                this.spawnOutputAsItem();
            }
            this.counter = 0;
            this.recipe = null;
        }
        if (!stack.func_190926_b()) {
            this.matchAndUse(stack);
        }
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    private void matchAndUse(ItemStack stack) {
        ICompressorRecipe rec;
        if (this.recipe != null && this.recipe.getInput().apply(stack)) {
            this.compressStack(stack);
        } else if (this.recipe == null && (rec = CompressorManager.searchByStack(stack)) != null) {
            this.recipe = rec;
            this.compressStack(stack);
        }
    }

    private void spawnOutputAsItem() {
        EntityItem i = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + distance, (double)this.field_174879_c.func_177952_p(), this.recipe.getOutputStack().func_77946_l());
        i.func_174869_p();
        i.getEntityData().func_74757_a(RECENT_KEY, true);
        this.field_145850_b.func_72838_d((Entity)i);
    }

    private boolean putOutputInHandler(IItemHandler handler) {
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.insertItem(i, this.recipe.getOutputStack().func_77946_l(), false).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("count", this.counter);
        tag.func_74778_a("recipe", this.recipe == null ? "null" : this.recipe.getID().toString());
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.counter = tag.func_74762_e("count");
        this.recipe = CompressorManager.searchByName(new ResourceLocation(tag.func_74779_i("recipe")));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_72321_a(1.0, 1.0, 1.0).func_186670_a(this.field_174879_c);
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (SingularityConfig.pipeInput && facing != EnumFacing.UP && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (SingularityConfig.pipeInput && facing != EnumFacing.UP && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return (T)super.getCapability(cap, facing);
    }

    private static final class CompressorItemHandler
    extends ItemStackHandler {
        private final TileCompressor tile;

        public CompressorItemHandler(TileCompressor tile) {
            super(10);
            this.tile = tile;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.tile.recipe != null && this.tile.recipe.getInput().apply(stack)) {
                return true;
            }
            return this.tile.recipe == null && (this.tile.recipe = CompressorManager.searchByStack(stack)) != null;
        }
    }
}

