/*
 * Decompiled with CFR 0.152.
 */
package shadows.singularity.avaritia;

import codechicken.lib.item.ItemMultiType;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemSingularity;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.commons.lang3.text.WordUtils;
import shadows.singularity.item.Singularity;
import shadows.singularity.recipe.CompressorManager;
import shadows.singularity.recipe.CompressorRecipe;
import shadows.singularity.recipe.ICompressorRecipe;

public class AvaritiaCompat {
    static Map<Integer, String> names;

    public static void copyToAvaritia(ICompressorRecipe recipe) {
        if (AvaritiaRecipeManager.getCompressorRecipeFromInput((ItemStack)recipe.getInput().func_193365_a()[0]) != null) {
            return;
        }
        AvaritiaRecipeManager.COMPRESSOR_RECIPES.put(recipe.getID(), new morph.avaritia.recipe.compressor.CompressorRecipe(recipe.getOutputStack(), recipe.getRequiredInputs(), true, (List)Lists.newArrayList((Object[])new Ingredient[]{recipe.getInput()})).setRegistryName(recipe.getID()));
    }

    public static void copyFromAvaritia(morph.avaritia.recipe.compressor.ICompressorRecipe recipe) {
        if (recipe.getIngredients().isEmpty() || ((Ingredient)recipe.getIngredients().get(0)).func_193365_a().length == 0) {
            return;
        }
        if (CompressorManager.searchByStack(((Ingredient)recipe.getIngredients().get(0)).func_193365_a()[0]) != null) {
            return;
        }
        CompressorManager.registerRecipe(new CompressorRecipe(recipe.getRegistryName(), (Ingredient)recipe.getIngredients().get(0), recipe.getCost(), recipe.getResult()));
    }

    public static void copyRecipesFromAvaritia() {
        for (morph.avaritia.recipe.compressor.ICompressorRecipe r : AvaritiaRecipeManager.COMPRESSOR_RECIPES.values()) {
            AvaritiaCompat.copyFromAvaritia(r);
        }
    }

    public static void messWithCatalyst() {
        Object catalyst = null;
        for (Object r : AvaritiaRecipeManager.EXTREME_RECIPES.values()) {
            if (!r.getRecipeOutput().func_77969_a(ModItems.infinity_catalyst)) continue;
            catalyst = r;
            break;
        }
        NonNullList ing = catalyst.getIngredients();
        ing.replaceAll(i -> {
            if (i.func_193365_a()[0].func_77973_b() instanceof ItemSingularity) {
                return AvaritiaCompat.fromAvaritiaStack(i.func_193365_a()[0]);
            }
            return i;
        });
        for (Singularity s : Singularity.getSingularities()) {
            if (ing.stream().anyMatch(i -> i.apply(s.getStack()))) continue;
            ing.add((Object)new OreIngredient(s.makeOreName()));
        }
        IExtremeRecipe newCatalyst = (IExtremeRecipe)new ExtremeShapelessRecipe(ing, catalyst.getRecipeOutput()).setRegistryName(catalyst.getRegistryName());
        AvaritiaRecipeManager.EXTREME_RECIPES.put(newCatalyst.getRegistryName(), newCatalyst);
    }

    private static OreIngredient fromAvaritiaStack(ItemStack stack) {
        if (names == null) {
            names = (Map)ReflectionHelper.getPrivateValue(ItemMultiType.class, (Object)((ItemMultiType)stack.func_77973_b()), (String[])new String[]{"names"});
        }
        String ore = "singularity" + WordUtils.capitalize((String)names.get(stack.func_77960_j()));
        OreDictionary.registerOre((String)ore, (ItemStack)stack);
        return new OreIngredient(ore);
    }
}

