/*
 * Decompiled with CFR 0.152.
 */
package com.simplequarries;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.simplequarries.SimplyQuarries;
import com.simplequarries.TileAdvSimplyQuarry;
import com.simplequarries.TileImpSimplyQuarry;
import com.simplequarries.TilePerSimplyQuarry;
import com.simplequarries.TileSimplyQuarry;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockQuarry implements IMultiTileBlock
{
    simply_quarry(TileSimplyQuarry.class, 0),
    adv_simply_quarry(TileAdvSimplyQuarry.class, 1),
    imp_simply_quarry(TileImpSimplyQuarry.class, 2),
    per_simply_quarry(TilePerSimplyQuarry.class, 3);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final EnumRarity rarity;
    private TileEntityBlock dummyTe;

    private BlockQuarry(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, EnumRarity.UNCOMMON);
    }

    private BlockQuarry(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)SimplyQuarries.getIdentifier(this.func_176610_l()));
    }

    public void buildDummies() {
        for (BlockQuarry block : BlockQuarry.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String func_176610_l() {
        return this.name();
    }

    public int getId() {
        return this.itemMeta;
    }

    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    public boolean hasItem() {
        return true;
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return true;
    }

    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    public float getHardness() {
        return 3.0f;
    }

    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Wrench;
    }

    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Machine;
    }

    public boolean allowWrenchRotating() {
        return true;
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        IDENTITY = SimplyQuarries.getIdentifier("simplyquarries");
    }
}

