/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.timer;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import meldexun.renderlib.util.GLQueryResult;
import meldexun.renderlib.util.Pair;
import meldexun.renderlib.util.timer.Timer;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL33;

public class GLTimer
extends Timer {
    private final Frame[] results;
    private GLQueryResult start;

    public GLTimer(String name, int maxResultCount) {
        super(name, maxResultCount);
        this.results = (Frame[])IntStream.range(0, maxResultCount).mapToObj(i -> new Frame()).toArray(Frame[]::new);
    }

    @Override
    protected void updateInternal() {
        this.results[this.frame].reset();
    }

    @Override
    protected void startInternal() {
        this.start = GLTimer.timestamp();
    }

    @Override
    protected void stopInternal() {
        this.results[this.frame].addPending(this.start, GLTimer.timestamp());
    }

    @Override
    public LongStream results() {
        return IntStream.range(0, this.results.length).filter(i -> i != this.frame).mapToObj(i -> this.results[i]).filter(Frame::ready).mapToLong(Frame::result);
    }

    private static GLQueryResult timestamp() {
        int q = GL15.glGenQueries();
        GL33.glQueryCounter((int)q, (int)36392);
        return new GLQueryResult(q);
    }

    private static class Frame {
        private final List<Pair<GLQueryResult, GLQueryResult>> pending = new LinkedList<Pair<GLQueryResult, GLQueryResult>>();
        private long time;

        private Frame() {
        }

        public void addPending(GLQueryResult start, GLQueryResult end) {
            this.pending.add(new Pair<GLQueryResult, GLQueryResult>(start, end));
        }

        public void reset() {
            this.pending.forEach(pair -> {
                ((GLQueryResult)pair.getLeft()).dispose();
                ((GLQueryResult)pair.getRight()).dispose();
            });
            this.pending.clear();
            this.time = 0L;
        }

        public void checkPending() {
            this.pending.removeIf(pair -> {
                if (((GLQueryResult)pair.getLeft()).ready() && ((GLQueryResult)pair.getRight()).ready()) {
                    this.time += ((GLQueryResult)pair.getRight()).time() - ((GLQueryResult)pair.getLeft()).time();
                    ((GLQueryResult)pair.getLeft()).dispose();
                    ((GLQueryResult)pair.getRight()).dispose();
                    return true;
                }
                return false;
            });
        }

        public boolean ready() {
            this.checkPending();
            return this.pending.isEmpty();
        }

        public long result() {
            return this.time;
        }
    }
}

