/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.RenderLib;
import meldexun.renderlib.config.RenderLibConfig;
import meldexun.renderlib.util.BufferUtil;
import meldexun.renderlib.util.GLException;
import meldexun.renderlib.util.MemoryAccess;
import meldexun.renderlib.util.UnsafeBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL44;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebugCallback;

public class GLUtil {
    public static ContextCapabilities CAPS;
    private static final UnsafeBuffer<FloatBuffer> FLOAT_BUFFER;

    public static void init() {
        CAPS = GLContext.getCapabilities();
        RenderLib.LOGGER.info("OpenGL Vendor: {}", (Object)GL11.glGetString((int)7936));
        RenderLib.LOGGER.info("OpenGL Renderer: {}", (Object)GL11.glGetString((int)7937));
        RenderLib.LOGGER.info("OpenGL Version: {}", (Object)GL11.glGetString((int)7938));
        RenderLib.LOGGER.info("OpenGL Extensions: {}", (Object)GL11.glGetString((int)7939));
        try {
            for (Field f : ContextCapabilities.class.getFields()) {
                if (f.getType() != Boolean.TYPE) continue;
                RenderLib.LOGGER.info("{} {}", (Object)f.getName(), f.get(CAPS));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void updateDebugOutput() {
        if (CAPS == null) {
            return;
        }
        RenderLib.LOGGER.info("OpenGL Debug: supported={}, enabled={}", (Object)GLUtil.CAPS.OpenGL43, (Object)RenderLibConfig.openGLDebugOutput.enabled);
        if (!GLUtil.CAPS.OpenGL43) {
            return;
        }
        if (RenderLibConfig.openGLDebugOutput.enabled) {
            GL11.glEnable((int)37600);
            GL11.glEnable((int)33346);
            GL43.glDebugMessageCallback((KHRDebugCallback)new KHRDebugCallback((source, type, id, severity, message) -> {
                if (type == 33356) {
                    throw new GLException(String.format("OpenGL Error: %s %s %s %s %s", GLUtil.getSource(source), GLUtil.getType(type), GLUtil.getSeverity(severity), id, message));
                }
                RenderLib.LOGGER.info("OpenGL Debug: {} {} {} {} {}", (Object)GLUtil.getSource(source), (Object)GLUtil.getType(type), (Object)GLUtil.getSeverity(severity), (Object)id, (Object)message);
            }));
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)4352, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)33356, (int)4352, null, (boolean)true);
            if (RenderLibConfig.openGLDebugOutput.logHighSeverity) {
                GL43.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            }
            if (RenderLibConfig.openGLDebugOutput.logMediumSeverity) {
                GL43.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)true);
            }
            if (RenderLibConfig.openGLDebugOutput.logLowSeverity) {
                GL43.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)true);
            }
            if (RenderLibConfig.openGLDebugOutput.logNotificationSeverity) {
                GL43.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)true);
            }
        } else {
            GL11.glDisable((int)37600);
            GL11.glDisable((int)33346);
        }
    }

    private static String getSource(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return "?";
    }

    private static String getType(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return "?";
    }

    private static String getSeverity(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return "?";
    }

    public static MemoryAccess getFloat(int pname) {
        GL11.glGetFloat((int)pname, (FloatBuffer)FLOAT_BUFFER.getBuffer());
        return FLOAT_BUFFER;
    }

    public static Matrix4f getMatrix(int matrix) {
        GL11.glGetFloat((int)matrix, (FloatBuffer)FLOAT_BUFFER.getBuffer());
        Matrix4f m = new Matrix4f();
        m.load(FLOAT_BUFFER.getAddress());
        return m;
    }

    public static void setMatrix(int uniform, Matrix4f matrix) {
        matrix.store(FLOAT_BUFFER.getAddress());
        GL20.glUniformMatrix4((int)uniform, (boolean)false, (FloatBuffer)FLOAT_BUFFER.getBuffer());
    }

    public static int createBuffer(long size, int flags, int usage) {
        if (GLUtil.CAPS.OpenGL45) {
            int buffer = GL45.glCreateBuffers();
            GL45.glNamedBufferStorage((int)buffer, (long)size, (int)flags);
            return buffer;
        }
        if (GLUtil.CAPS.OpenGL44) {
            int buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)buffer);
            GL44.glBufferStorage((int)34962, (long)size, (int)flags);
            GL15.glBindBuffer((int)34962, (int)0);
            return buffer;
        }
        int buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)buffer);
        GL15.glBufferData((int)34962, (long)size, (int)usage);
        GL15.glBindBuffer((int)34962, (int)0);
        return buffer;
    }

    public static ByteBuffer map(int buffer, long length, int accessRange, int access, @Nullable ByteBuffer oldBuffer) {
        if (GLUtil.CAPS.OpenGL45) {
            return GL45.glMapNamedBufferRange((int)buffer, (long)0L, (long)length, (int)accessRange, (ByteBuffer)oldBuffer);
        }
        if (GLUtil.CAPS.OpenGL30) {
            if (!GLUtil.CAPS.OpenGL44) {
                accessRange &= 0xFFFFFF3F;
            }
            GL15.glBindBuffer((int)34962, (int)buffer);
            ByteBuffer byteBuffer = GL30.glMapBufferRange((int)34962, (long)0L, (long)length, (int)accessRange, (ByteBuffer)oldBuffer);
            GL15.glBindBuffer((int)34962, (int)0);
            return byteBuffer;
        }
        GL15.glBindBuffer((int)34962, (int)buffer);
        ByteBuffer byteBuffer = GL15.glMapBuffer((int)34962, (int)access, (long)length, (ByteBuffer)oldBuffer);
        GL15.glBindBuffer((int)34962, (int)0);
        return byteBuffer;
    }

    public static void unmap(int buffer) {
        if (GLUtil.CAPS.OpenGL45) {
            GL45.glUnmapNamedBuffer((int)buffer);
        } else {
            GL15.glBindBuffer((int)34962, (int)buffer);
            GL15.glUnmapBuffer((int)34962);
            GL15.glBindBuffer((int)34962, (int)0);
        }
    }

    static {
        FLOAT_BUFFER = new UnsafeBuffer<FloatBuffer>(BufferUtil.allocateFloat(16));
    }
}

