/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.Config;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IHasGui;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AdvEnergy;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.powerutils.ContainerTEConverter;
import com.powerutils.GuiTEConverter;
import com.powerutils.handler.TeslaHelper;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTEConverter
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IEnergyStorage,
ITeslaConsumer,
ITeslaProducer,
IUpgradableBlock {
    public final AdvEnergy energy;
    public final InvSlotUpgrade upgradeSlot;
    public final int defaultEnergyRFStorage;
    public final int defaultEnergyStorage;
    public double capacity;
    public double maxStorage2 = 400000.0;
    public double energy2 = 0.0;
    public boolean rf = true;
    public double differenceenergy = 0.0;
    public double perenergy = 0.0;
    public double differenceenergy1 = 0.0;
    public int tier = 5;
    public List<EntityPlayer> list = new ArrayList<EntityPlayer>();
    private long tick;

    public TileEntityTEConverter() {
        this.energy = (AdvEnergy)this.addComponent((AbstractComponent)new AdvEnergy((TileEntityInventory)this, 40000.0, Util.allFacings, Util.allFacings, 5, 5, false));
        this.energy.setDirections(Util.allFacings, Util.allFacings);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 4);
        this.defaultEnergyStorage = 40000;
        this.defaultEnergyRFStorage = 400000;
        this.capacity = this.energy.capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (this.hasComp(AdvEnergy.class)) {
            AdvEnergy energy = (AdvEnergy)this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSourceTier()}));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSinkTier()}));
            }
        }
    }

    protected void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nullable EnumFacing side) {
        return cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (TeslaHelper.isTeslaCapability(capability)) {
            Capability<ITeslaProducer> mjConnector = TeslaHelper.TESLA_PRODUCER;
            Capability<ITeslaConsumer> teslaConsumer = TeslaHelper.TESLA_CONSUMER;
            if (capability == mjConnector && this.canExtract()) {
                return (T)mjConnector.cast((Object)this);
            }
            if (capability == teslaConsumer && this.canReceive()) {
                return (T)teslaConsumer.cast((Object)this);
            }
            return (T)super.getCapability(capability, side);
        }
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this) : super.getCapability(capability, side));
    }

    public boolean canExtract() {
        return this.extractEnergy(1, true) != 0;
    }

    public boolean canReceive() {
        return this.receiveEnergy(1, true) != 0;
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(5);
        this.energy.setSinkTier(tier);
        this.energy.setSourceTier(tier);
        this.energy.setCapacity(this.upgradeSlot.extraEnergyStorage + (double)this.defaultEnergyStorage);
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        this.tier = tier;
        this.capacity = this.energy.capacity;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        if (this.rf) {
            return 0;
        }
        int i = (int)Math.min(this.maxStorage2 - this.energy2, (double)paramInt);
        if (!paramBoolean) {
            this.energy2 += (double)i;
            this.differenceenergy1 = i;
            if (this.tick != this.func_145831_w().func_72820_D()) {
                this.tick = this.func_145831_w().func_72820_D();
                this.perenergy = i;
            } else {
                this.perenergy += (double)i;
            }
        }
        return i;
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.energy.setReceivingEnabled(!this.shouldEmitEnergy());
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.differenceenergy = 0.0;
        this.differenceenergy1 = 0.0;
        if (this.tick != this.func_145831_w().func_72820_D()) {
            this.perenergy = 0.0;
        }
        if (this.rf) {
            if (this.energy.getEnergy() > 0.0 && this.energy2 < this.maxStorage2) {
                double add = Math.min(this.maxStorage2 - this.energy2, this.energy.getEnergy() * (double)Config.coefficientrf);
                add = Math.max(add, 0.0);
                this.energy2 += add;
                this.energy.useEnergy(add / (double)Config.coefficientrf);
            }
        } else if (this.energy2 > 0.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            double k = this.energy.addEnergy(this.energy2 / (double)Config.coefficientrf) * (double)Config.coefficientrf;
            this.energy2 -= k;
        }
        if (!this.list.isEmpty()) {
            NodeStats stats = EnergyNet.instance.getNodeStats((IEnergyTile)this.energy.getDelegate());
            if (this.rf) {
                if (stats != null) {
                    this.differenceenergy1 = stats.getEnergyIn();
                }
            } else if (stats != null) {
                this.differenceenergy = stats.getEnergyOut();
            }
        }
        int transfer = (int)Math.min(this.energy2, EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier()));
        this.energy2 -= (double)transfer;
        this.energy2 += (double)this.transmitEnergy(transfer);
        boolean needsInvUpdate = this.upgradeSlot.tickNoMark();
        if (needsInvUpdate) {
            this.setOverclockRates();
        }
        this.energy2 = Math.min(this.energy2, this.maxStorage2);
    }

    private int transmitEnergy(int energy) {
        EnumFacing[] var2;
        for (EnumFacing e : var2 = EnumFacing.values()) {
            TileEntity te;
            BlockPos neighbor = this.getBlockPos().func_177972_a(e);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IEnergyStorage storage = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, e.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, e.func_176734_d());
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (storage == null || (energy -= storage.receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    protected boolean shouldEmitEnergy() {
        return !this.rf;
    }

    public int extractEnergy(int paramInt, boolean paramBoolean) {
        if (!this.rf) {
            return 0;
        }
        int i = (int)Math.min(this.energy2, (double)paramInt);
        if (!paramBoolean) {
            this.energy2 -= (double)i;
            this.differenceenergy += (double)i;
        }
        return i;
    }

    public boolean canConnectEnergy() {
        return true;
    }

    public int getEnergyStored() {
        return (int)this.energy2;
    }

    public int getMaxEnergyStored() {
        return (int)this.maxStorage2;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy.setDirections(Util.allFacings, Util.allFacings);
        this.tier = nbttagcompound.func_74762_e("tier");
        this.energy2 = Util.limit((double)nbttagcompound.func_74769_h("energy2"), (double)0.0, (double)this.maxStorage2);
        this.rf = nbttagcompound.func_74767_n("rf");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.energy2 > 0.0) {
            nbttagcompound.func_74780_a("energy2", this.energy2);
        }
        nbttagcompound.func_74768_a("tier", this.tier);
        nbttagcompound.func_74757_a("rf", this.rf);
        return nbttagcompound;
    }

    public int getOutput() {
        return (int)EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy((double)amount);
        return amount;
    }

    public ContainerTEConverter getGuiContainer(EntityPlayer player) {
        this.list.add(player);
        return new ContainerTEConverter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiTEConverter(this.getGuiContainer(entityPlayer));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        this.rf = !this.rf;
    }

    public int gaugeICEnergyScaled(int i) {
        return (int)Math.min(this.energy.getEnergy() * (double)i / this.energy.getCapacity(), (double)i);
    }

    public int gaugeTEEnergyScaled(int i) {
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        return (int)Math.min(this.energy2 * (double)i / this.maxStorage2, (double)i);
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double v) {
        return this.energy.useEnergy(v);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }

    @Override
    public long givePower(long l, boolean b) {
        return this.receiveEnergy((int)l, b);
    }

    @Override
    public long takePower(long l, boolean b) {
        return this.extractEnergy((int)l, b);
    }
}

