/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.denfop.Config;
import com.denfop.api.inv.IHasGui;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AdvEnergy;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.TransferRFEnergy;
import com.powerutils.ContainerConverter;
import com.powerutils.GuiConverter;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConverter
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IEnergyHandler,
IEnergyReceiver,
IEnergyStorage,
IEnergyProvider,
IUpgradableBlock {
    public final AdvEnergy energy;
    public final InvSlotUpgrade upgradeSlot;
    public final double defaultEnergyRFStorage;
    public final double defaultEnergyStorage;
    public double capacity;
    public double maxStorage2 = 400000.0;
    public double energy2 = 0.0;
    public boolean rf = true;
    public double differenceenergy = 0.0;
    public double perenergy = 0.0;
    public double differenceenergy1 = 0.0;
    public int tier;
    public List<EntityPlayer> list = new ArrayList<EntityPlayer>();
    List<TransferRFEnergy> transferRFEnergyList = new ArrayList<TransferRFEnergy>();
    private long tick;

    public TileEntityConverter() {
        this.energy = (AdvEnergy)this.addComponent((AbstractComponent)new AdvEnergy((TileEntityInventory)this, 40000.0, Util.allFacings, Util.allFacings, 5, 5, false));
        this.capacity = this.energy.capacity;
        this.energy.setDirections(Util.allFacings, Util.allFacings);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 4);
        this.defaultEnergyStorage = 40000.0;
        this.defaultEnergyRFStorage = 400000.0;
        this.tier = 5;
        this.tick = 0L;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (this.hasComp(AdvEnergy.class)) {
            AdvEnergy energy = (AdvEnergy)this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSourceTier()}));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSinkTier()}));
            }
        }
    }

    protected void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(5);
        this.energy.setSinkTier(tier);
        this.energy.setSourceTier(tier);
        this.energy.setCapacity(this.upgradeSlot.extraEnergyStorage + this.defaultEnergyStorage);
        this.maxStorage2 = this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        this.tier = tier;
        this.capacity = this.energy.capacity;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return !this.rf ? this.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        int i = (int)Math.min(this.maxStorage2 - this.energy2, Math.min(EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier() * Config.coefficientrf), (double)paramInt));
        if (!paramBoolean) {
            this.energy2 += (double)i;
            this.differenceenergy1 += (double)i;
            if (this.tick != this.func_145831_w().func_72820_D()) {
                this.tick = this.func_145831_w().func_72820_D();
                this.perenergy = i;
            } else {
                this.perenergy += (double)i;
            }
        }
        return i;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.extractEnergy((int)Math.min(EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier() * Config.coefficientrf), (double)maxExtract), simulate);
    }

    protected void updateEntityServer() {
        boolean needsInvUpdate;
        super.updateEntityServer();
        this.energy.setReceivingEnabled(!this.shouldEmitEnergy());
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.differenceenergy = 0.0;
        this.differenceenergy1 = 0.0;
        if (this.tick != this.func_145831_w().func_72820_D()) {
            this.perenergy = 0.0;
        }
        if (this.rf) {
            if (this.energy.getEnergy() > 0.0 && this.energy2 < this.maxStorage2) {
                double add = Math.min(this.maxStorage2 - this.energy2, this.energy.getEnergy() * (double)Config.coefficientrf);
                add = Math.max(add, 0.0);
                this.energy2 += add;
                this.energy.useEnergy(add / (double)Config.coefficientrf);
            }
        } else if (this.energy2 > 0.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            double k = this.energy.addEnergy(this.energy2 / (double)Config.coefficientrf) * (double)Config.coefficientrf;
            this.energy2 -= k;
        }
        if (!this.list.isEmpty()) {
            NodeStats stats = EnergyNet.instance.getNodeStats((IEnergyTile)this.energy.getDelegate());
            if (this.rf) {
                if (stats != null) {
                    this.differenceenergy1 = stats.getEnergyIn();
                }
            } else if (stats != null) {
                this.differenceenergy = stats.getEnergyOut();
            }
        }
        if (this.energy2 > 0.0) {
            if (this.rf && this.func_145831_w().func_72820_D() % 60L == 0L) {
                this.transferRFEnergyList.clear();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n() + facing.func_82601_c(), this.field_174879_c.func_177956_o() + facing.func_96559_d(), this.field_174879_c.func_177952_p() + facing.func_82599_e());
                    TileEntity tile = this.func_145831_w().func_175625_s(pos);
                    if (tile == null || !(tile instanceof IEnergyReceiver)) continue;
                    this.transferRFEnergyList.add(new TransferRFEnergy(tile, (IEnergyReceiver)tile, facing));
                }
            }
            boolean refresh = false;
            for (TransferRFEnergy rfEnergy : this.transferRFEnergyList) {
                if (rfEnergy.getTile().func_145837_r()) {
                    refresh = true;
                    continue;
                }
                this.extractEnergy(rfEnergy.getFacing(), rfEnergy.getSink().receiveEnergy(rfEnergy.getFacing().func_176734_d(), this.extractEnergy(rfEnergy.getFacing(), (int)this.energy2, true), false), false);
            }
            if (refresh) {
                this.transferRFEnergyList.clear();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n() + facing.func_82601_c(), this.field_174879_c.func_177956_o() + facing.func_96559_d(), this.field_174879_c.func_177952_p() + facing.func_82599_e());
                    TileEntity tile = this.func_145831_w().func_175625_s(pos);
                    if (tile == null || !(tile instanceof IEnergyReceiver)) continue;
                    this.transferRFEnergyList.add(new TransferRFEnergy(tile, (IEnergyReceiver)tile, facing));
                }
            }
        }
        if (needsInvUpdate = this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
        this.energy2 = Math.min(this.energy2, this.maxStorage2);
    }

    protected boolean shouldEmitEnergy() {
        return !this.rf;
    }

    public int extractEnergy(int paramInt, boolean paramBoolean) {
        int i = (int)Math.min(this.energy2, (double)paramInt);
        if (!paramBoolean) {
            this.energy2 -= (double)i;
            this.differenceenergy += (double)i;
        }
        return i;
    }

    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    public int getEnergyStored(EnumFacing from) {
        return (int)this.energy2;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.maxStorage2;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy.setDirections(Util.allFacings, Util.allFacings);
        this.tier = nbttagcompound.func_74762_e("tier");
        this.energy2 = Util.limit((double)nbttagcompound.func_74769_h("energy2"), (double)0.0, (double)this.maxStorage2);
        this.rf = nbttagcompound.func_74767_n("rf");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.energy2 > 0.0) {
            nbttagcompound.func_74780_a("energy2", this.energy2);
        }
        nbttagcompound.func_74768_a("tier", this.tier);
        nbttagcompound.func_74757_a("rf", this.rf);
        return nbttagcompound;
    }

    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    public int getOutput() {
        return (int)EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public double getOutputEnergyUnitsPerTick() {
        return EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public int getStored() {
        return (int)this.energy.getEnergy();
    }

    public void setStored(int energy1) {
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy((double)amount);
        return amount;
    }

    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }

    public ContainerConverter getGuiContainer(EntityPlayer player) {
        this.list.add(player);
        return new ContainerConverter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiConverter(this.getGuiContainer(entityPlayer));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        this.rf = !this.rf;
    }

    public int gaugeICEnergyScaled(int i) {
        return (int)Math.min(this.energy.getEnergy() * (double)i / this.energy.getCapacity(), (double)i);
    }

    public int gaugeTEEnergyScaled(int i) {
        this.maxStorage2 = this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        return (int)Math.min(this.energy2 * (double)i / this.maxStorage2, (double)i);
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double v) {
        return this.energy.useEnergy(v);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }
}

